/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Ticker;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;
import org.microemu.CommandManager;
import org.microemu.DisplayAccess;
import org.microemu.GameCanvasKeyAccess;
import org.microemu.MIDletBridge;
import org.microemu.device.DeviceFactory;

public class Display {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    private PaintThread paintThread = null;
    private EventDispatcher eventDispatcher = null;
    private Displayable current = null;
    private DisplayAccessor accessor = null;
    private Object paintLock = new Object();
    private boolean repaintPending = false;

    Display() {
        Thread t;
        this.accessor = new DisplayAccessor(this);
        if (this.paintThread == null) {
            this.paintThread = new PaintThread();
            t = new Thread((Runnable)this.paintThread, "PaintThread");
            t.setDaemon(true);
            t.start();
        }
        if (this.eventDispatcher == null) {
            this.eventDispatcher = new EventDispatcher();
            t = new Thread((Runnable)this.eventDispatcher, "EventDispatcher");
            t.setDaemon(true);
            t.start();
        }
        Runnable tickerPaint = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Ticker ticker;
                if (Display.this.current != null && (ticker = Display.this.current.getTicker()) != null) {
                    Ticker ticker2 = ticker;
                    synchronized (ticker2) {
                        if (ticker.resetTextPosTo != -1) {
                            ticker.textPos = ticker.resetTextPosTo;
                            ticker.resetTextPosTo = -1;
                        }
                        ticker.textPos -= Ticker.PAINT_MOVE;
                    }
                    Display.this.repaint(Display.this.current, 0, 0, Display.this.current.getWidth(), Display.this.current.getHeight());
                }
                Display.this.eventDispatcher.schedule(this, Ticker.PAINT_TIMEOUT);
            }
        };
        this.eventDispatcher.schedule(tickerPaint, Ticker.PAINT_TIMEOUT);
        Runnable gaugePaint = new Runnable(){

            public void run() {
                if (Display.this.current != null) {
                    if (Display.this.current instanceof Alert) {
                        Gauge gauge = ((Alert)((Display)Display.this).current).indicator;
                        if (gauge != null && gauge.hasIndefiniteRange() && gauge.getValue() == 2) {
                            gauge.updateIndefiniteFrame();
                        }
                    } else if (Display.this.current instanceof Form) {
                        Item[] items = ((Form)((Display)Display.this).current).items;
                        for (int i = 0; i < items.length; ++i) {
                            Gauge gauge;
                            Item it = items[i];
                            if (it == null || !(it instanceof Gauge) || !(gauge = (Gauge)it).hasIndefiniteRange() || gauge.getValue() != 2) continue;
                            gauge.updateIndefiniteFrame();
                        }
                    }
                }
                Display.this.eventDispatcher.schedule(this, Ticker.PAINT_TIMEOUT);
            }
        };
        this.eventDispatcher.schedule(gaugePaint, Ticker.PAINT_TIMEOUT);
    }

    public void callSerially(Runnable r) {
        this.eventDispatcher.schedule(r, 0L);
    }

    public int numAlphaLevels() {
        return DeviceFactory.getDevice().getDeviceDisplay().numAlphaLevels();
    }

    public int numColors() {
        return DeviceFactory.getDevice().getDeviceDisplay().numColors();
    }

    public boolean flashBacklight(int duration) {
        return false;
    }

    public static Display getDisplay(MIDlet m) {
        Display result;
        if (MIDletBridge.getMIDletAccess(m).getDisplayAccess() == null) {
            result = new Display();
            MIDletBridge.getMIDletAccess(m).setDisplayAccess(result.accessor);
        } else {
            result = MIDletBridge.getMIDletAccess(m).getDisplayAccess().getDisplay();
        }
        return result;
    }

    public int getColor(int colorSpecifier) {
        try {
            throw new RuntimeException("Not implemented");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public int getBorderStyle(boolean highlighted) {
        try {
            throw new RuntimeException("Not implemented");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public int getBestImageWidth(int imageType) {
        try {
            throw new RuntimeException("Not implemented");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public int getBestImageHeight(int imageType) {
        try {
            throw new RuntimeException("Not implemented");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Displayable getCurrent() {
        return this.current;
    }

    public boolean isColor() {
        return DeviceFactory.getDevice().getDeviceDisplay().isColor();
    }

    public void setCurrent(Displayable nextDisplayable) {
        if (nextDisplayable != null) {
            if (this.current != null) {
                this.current.hideNotify(this);
            }
            if (nextDisplayable instanceof Alert) {
                this.setCurrent((Alert)nextDisplayable, this.current);
                return;
            }
            this.current = nextDisplayable;
            this.current.showNotify(this);
            this.setScrollUp(false);
            this.setScrollDown(false);
            this.updateCommands();
            this.current.repaint();
        }
    }

    public void setCurrent(Alert alert, Displayable nextDisplayable) {
        Alert.nextDisplayable = nextDisplayable;
        this.current = alert;
        this.current.showNotify(this);
        this.updateCommands();
        this.current.repaint();
        if (alert.getTimeout() != -2) {
            AlertTimeout at = new AlertTimeout(alert.getTimeout());
            Thread t = new Thread(at);
            t.start();
        }
    }

    public void setCurrentItem(Item item) {
        try {
            throw new RuntimeException("Not implemented");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public boolean vibrate(int duration) {
        return false;
    }

    void clearAlert() {
        this.setCurrent(Alert.nextDisplayable);
    }

    static int getGameAction(int keyCode) {
        return DeviceFactory.getDevice().getInputMethod().getGameAction(keyCode);
    }

    static int getKeyCode(int gameAction) {
        return DeviceFactory.getDevice().getInputMethod().getKeyCode(gameAction);
    }

    static String getKeyName(int keyCode) {
        return DeviceFactory.getDevice().getInputMethod().getKeyName(keyCode);
    }

    boolean isShown(Displayable d) {
        return this.current != null && this.current == d;
    }

    void repaint(Displayable d, int x, int y, int width, int height) {
        if (this.current == d) {
            this.paintThread.repaint(x, y, width, height);
        }
    }

    void serviceRepaints() {
        this.paintThread.serviceRepaints();
    }

    void setScrollDown(boolean state) {
        DeviceFactory.getDevice().getDeviceDisplay().setScrollDown(state);
    }

    void setScrollUp(boolean state) {
        DeviceFactory.getDevice().getDeviceDisplay().setScrollUp(state);
    }

    void updateCommands() {
        if (this.current == null) {
            CommandManager.getInstance().updateCommands(null);
        } else {
            CommandManager.getInstance().updateCommands(this.current.getCommands());
        }
        this.repaint(this.current, 0, 0, this.current.getWidth(), this.current.getHeight());
    }

    private class EventDispatcher
    implements Runnable {
        private boolean canceled = false;
        private Object dispatcherLock = new Object();
        private Vector times = new Vector();
        private Vector events = new Vector();

        private EventDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Runnable r, long delay) {
            Object object = Display.this.paintLock;
            synchronized (object) {
                this.times.addElement(new Long(System.currentTimeMillis() + delay));
                this.events.addElement(r);
                Object object2 = this.dispatcherLock;
                synchronized (object2) {
                    this.dispatcherLock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.canceled = true;
            Object object = this.dispatcherLock;
            synchronized (object) {
                this.dispatcherLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.canceled) {
                Runnable job = null;
                Object object = Display.this.paintLock;
                synchronized (object) {
                    if (!Display.this.repaintPending) {
                        long now = System.currentTimeMillis();
                        for (int i = 0; i < this.events.size(); ++i) {
                            if ((Long)this.times.elementAt(i) >= now) continue;
                            job = (Runnable)this.events.elementAt(i);
                            this.times.removeElementAt(i);
                            this.events.removeElementAt(i);
                            break;
                        }
                    }
                }
                if (job != null) {
                    job.run();
                } else {
                    object = this.dispatcherLock;
                    synchronized (object) {
                        try {
                            this.dispatcherLock.wait(10L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
                object = this.dispatcherLock;
                synchronized (object) {
                    if (this.events.size() > 0 || Display.this.repaintPending) {
                        continue;
                    }
                    try {
                        this.dispatcherLock.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        Display.this.eventDispatcher = null;
                        return;
                    }
                }
            }
        }
    }

    private class PaintThread
    implements Runnable {
        private boolean canceled = false;
        private Object serviceRepaintsLock = new Object();
        private int x = -1;
        private int y = -1;
        private int width = -1;
        private int height = -1;

        private PaintThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint(int x, int y, int width, int height) {
            Object object = Display.this.paintLock;
            synchronized (object) {
                Display.this.repaintPending = true;
                if (this.x == -1 && this.y == -1 && this.width == -1 && this.height == -1) {
                    this.x = x;
                    this.y = y;
                    this.width = width;
                    this.height = height;
                } else {
                    this.x = 0;
                    this.y = 0;
                    this.width = Display.this.current.getWidth();
                    this.height = Display.this.current.getHeight();
                }
                Display.this.paintLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRepaints() {
            Object object = Display.this.paintLock;
            synchronized (object) {
                if (!Display.this.repaintPending) {
                    return;
                }
            }
            object = this.serviceRepaintsLock;
            synchronized (object) {
                try {
                    this.serviceRepaintsLock.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.canceled = true;
            Object object = Display.this.paintLock;
            synchronized (object) {
                Display.this.paintLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.canceled) {
                if (Display.this.repaintPending) {
                    int repaintHeight;
                    int repaintWidth;
                    int repaintY;
                    int repaintX;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    Object object = Display.this.paintLock;
                    synchronized (object) {
                        Display.this.repaintPending = false;
                        repaintX = this.x;
                        repaintY = this.y;
                        repaintWidth = this.width;
                        repaintHeight = this.height;
                        this.x = -1;
                        this.y = -1;
                        this.width = -1;
                        this.height = -1;
                    }
                    DeviceFactory.getDevice().getDeviceDisplay().repaint(repaintX, repaintY, repaintWidth, repaintHeight);
                    if (!Display.this.repaintPending) {
                        object = this.serviceRepaintsLock;
                        synchronized (object) {
                            this.serviceRepaintsLock.notify();
                        }
                    }
                }
                Object object = Display.this.paintLock;
                synchronized (object) {
                    if (Display.this.repaintPending) {
                        continue;
                    }
                    try {
                        Display.this.paintLock.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        Display.this.paintThread = null;
                        return;
                    }
                }
            }
        }
    }

    private class AlertTimeout
    implements Runnable {
        int time;

        AlertTimeout(int time) {
            this.time = time;
        }

        public void run() {
            try {
                Thread.sleep(this.time);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            Displayable d = Display.this.current;
            if (d != null && d instanceof Alert) {
                Alert alert = (Alert)d;
                if (alert.time != -2) {
                    alert.getCommandListener().commandAction((Command)alert.getCommands().get(0), alert);
                }
            }
        }
    }

    private class DisplayAccessor
    implements DisplayAccess {
        Display display;

        DisplayAccessor(Display d) {
            this.display = d;
        }

        public void commandAction(Command cmd) {
            if (cmd.equals(CommandManager.CMD_SCREEN_UP)) {
                if (Display.this.current != null && Display.this.current instanceof Screen) {
                    ((Screen)Display.this.current).scroll(1);
                }
            } else if (cmd.equals(CommandManager.CMD_SCREEN_DOWN)) {
                if (Display.this.current != null && Display.this.current instanceof Screen) {
                    ((Screen)Display.this.current).scroll(6);
                }
            } else if (cmd.isRegularCommand()) {
                if (Display.this.current == null) {
                    return;
                }
                CommandListener listener = Display.this.current.getCommandListener();
                if (listener == null) {
                    return;
                }
                listener.commandAction(cmd, Display.this.current);
            } else {
                Item item = cmd.getFocusedItem();
                ItemCommandListener listener = item.getItemCommandListener();
                if (listener == null) {
                    return;
                }
                listener.commandAction(cmd.getOriginalCommand(), item);
            }
        }

        public Display getDisplay() {
            return this.display;
        }

        private void processGameCanvasKeyEvent(GameCanvas c, int k, boolean press) {
            GameCanvasKeyAccess access = MIDletBridge.getMIDletAccess().getGameCanvasKeyAccess();
            int gameCode = c.getGameAction(k);
            boolean suppress = false;
            if (gameCode != 0) {
                if (press) {
                    access.recordKeyPressed(c, gameCode);
                } else {
                    access.recordKeyReleased(c, gameCode);
                }
                suppress = access.suppressedKeyEvents(c);
            }
            if (!suppress) {
                if (press) {
                    c.keyPressed(k);
                } else {
                    c.keyReleased(k);
                }
            }
        }

        public void keyPressed(int keyCode) {
            if (Display.this.current != null) {
                if (Display.this.current instanceof GameCanvas) {
                    this.processGameCanvasKeyEvent((GameCanvas)Display.this.current, keyCode, true);
                } else {
                    Display.this.current.keyPressed(keyCode);
                }
            }
        }

        public void keyReleased(int keyCode) {
            if (Display.this.current != null) {
                if (Display.this.current instanceof GameCanvas) {
                    this.processGameCanvasKeyEvent((GameCanvas)Display.this.current, keyCode, false);
                } else {
                    Display.this.current.keyReleased(keyCode);
                }
            }
        }

        public void pointerPressed(int x, int y) {
            if (Display.this.current != null) {
                Display.this.current.pointerPressed(x, y);
            }
        }

        public void pointerReleased(int x, int y) {
            if (Display.this.current != null) {
                Display.this.current.pointerReleased(x, y);
            }
        }

        public void pointerDragged(int x, int y) {
            if (Display.this.current != null) {
                Display.this.current.pointerDragged(x, y);
            }
        }

        public void paint(Graphics g) {
            if (Display.this.current != null) {
                Display.this.current.paint(g);
                g.translate(-g.getTranslateX(), -g.getTranslateY());
            }
        }

        public Displayable getCurrent() {
            return this.getDisplay().getCurrent();
        }

        public boolean isFullScreenMode() {
            Displayable current = this.getCurrent();
            if (current instanceof Canvas) {
                return ((Canvas)current).fullScreenMode;
            }
            return false;
        }

        public boolean isRepaintPending() {
            return Display.this.repaintPending;
        }

        public void serviceRepaints() {
            this.getDisplay().serviceRepaints();
        }

        public void setCurrent(Displayable d) {
            this.getDisplay().setCurrent(d);
        }

        public void sizeChanged(int width, int height) {
            if (Display.this.current != null) {
                Display.this.current.sizeChanged(width, height);
                this.updateCommands();
            }
        }

        public void updateCommands() {
            this.getDisplay().updateCommands();
        }

        public void clean() {
            if (Display.this.current != null) {
                Display.this.current.hideNotify();
            }
            Display.this.eventDispatcher.cancel();
            Display.this.paintThread.cancel();
        }
    }
}

