/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.util.ArrayList;
import java.util.Arrays;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolygonZ;
import org.meteoinfo.shape.ShapeTypes;

public class PolygonZShape
extends PolygonShape {
    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.PolygonZ;
    }

    public double[] getZArray() {
        double[] zArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            zArray[i] = ((PointZ)this.getPoints().get((int)i)).Z;
        }
        return zArray;
    }

    public double[] getZRange() {
        return MIMath.arrayMinMax(this.getZArray());
    }

    public double[] getMArray() {
        double[] mArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            mArray[i] = ((PointZ)this.getPoints().get((int)i)).M;
        }
        return mArray;
    }

    public double[] getMRange() {
        return MIMath.arrayMinMax(this.getMArray());
    }

    @Override
    protected void updatePolygons() {
        this._polygons = new ArrayList();
        if (this._numParts == 1) {
            PolygonZ aPolygon = new PolygonZ();
            aPolygon.setOutLine(this._points);
            this._polygons.add(aPolygon);
        } else {
            PolygonZ aPolygon = null;
            int numPoints = this.getPointNum();
            for (int p = 0; p < this._numParts; ++p) {
                int pp;
                PointD[] Pointps;
                if (p == this._numParts - 1) {
                    Pointps = new PointZ[numPoints - this.parts[p]];
                    for (pp = this.parts[p]; pp < numPoints; ++pp) {
                        Pointps[pp - this.parts[p]] = (PointZ)this._points.get(pp);
                    }
                } else {
                    Pointps = new PointZ[this.parts[p + 1] - this.parts[p]];
                    for (pp = this.parts[p]; pp < this.parts[p + 1]; ++pp) {
                        Pointps[pp - this.parts[p]] = (PointZ)this._points.get(pp);
                    }
                }
                if (GeoComputation.isClockwise(Pointps)) {
                    if (p > 0) {
                        this._polygons.add(aPolygon);
                    }
                    aPolygon = new PolygonZ();
                    aPolygon.setOutLine(Arrays.asList(Pointps));
                    continue;
                }
                if (aPolygon == null) {
                    MIMath.arrayReverse(Pointps);
                    aPolygon = new PolygonZ();
                    aPolygon.setOutLine(Arrays.asList(Pointps));
                    continue;
                }
                aPolygon.addHole(Arrays.asList(Pointps));
            }
            this._polygons.add(aPolygon);
        }
    }
}

