/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.layout.ResizeAbility;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.legend.ChartTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.MarkerType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.legend.VectorBreak;
import org.meteoinfo.shape.CircleShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.CurvePolygonShape;
import org.meteoinfo.shape.EllipseShape;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.WindArrow;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Graphic {
    private Shape _shape = null;
    private ColorBreak _legend = null;
    private ResizeAbility _resizeAbility = ResizeAbility.ResizeAll;

    public Graphic() {
    }

    public Graphic(Shape shape, ColorBreak legend) {
        this._shape = shape;
        this._legend = legend;
        this.updateResizeAbility();
    }

    public Shape getShape() {
        return this._shape;
    }

    public void setShape(Shape aShape) {
        this._shape = aShape;
        this.updateResizeAbility();
    }

    public ColorBreak getLegend() {
        return this._legend;
    }

    public void setLegend(ColorBreak legend) {
        this._legend = legend;
        this.updateResizeAbility();
        this.updateResizeAbility();
    }

    public ResizeAbility getResizeAbility() {
        return this._resizeAbility;
    }

    public Extent getExtent() {
        return this._shape.getExtent();
    }

    public void setExtent(Extent value) {
        this._shape.setExtent(value);
    }

    public boolean isSingleLegend() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public int getNumGraphics() {
        return 1;
    }

    public Graphic getGraphicN(int idx) {
        return this;
    }

    public List<Graphic> getGraphics() {
        ArrayList<Graphic> gs = new ArrayList<Graphic>();
        gs.add(this);
        return gs;
    }

    private void updateResizeAbility() {
        if (this._shape != null && this._legend != null) {
            switch (this._shape.getShapeType()) {
                case Point: {
                    switch (this._legend.getBreakType()) {
                        case PointBreak: {
                            this._resizeAbility = ResizeAbility.SameWidthHeight;
                            break;
                        }
                        case LabelBreak: 
                        case ChartBreak: {
                            this._resizeAbility = ResizeAbility.None;
                        }
                    }
                    break;
                }
                case Circle: {
                    this._resizeAbility = ResizeAbility.SameWidthHeight;
                    break;
                }
                default: {
                    this._resizeAbility = ResizeAbility.ResizeAll;
                }
            }
        }
    }

    public void verticeMoveUpdate(int vIdx, double newX, double newY) {
        List<? extends PointD> points = this._shape.getPoints();
        switch (this._shape.getShapeType()) {
            case Polygon: 
            case CurvePolygon: 
            case Rectangle: {
                int last = points.size() - 1;
                if (vIdx == 0) {
                    if (points.get((int)0).X != points.get((int)last).X || points.get((int)0).Y != points.get((int)last).Y) break;
                    points.get((int)last).X = newX;
                    points.get((int)last).Y = newY;
                    break;
                }
                if (vIdx != last || points.get((int)0).X != points.get((int)last).X || points.get((int)0).Y != points.get((int)last).Y) break;
                points.get((int)0).X = newX;
                points.get((int)0).Y = newY;
            }
        }
        PointD aP = points.get(vIdx);
        aP.X = newX;
        aP.Y = newY;
        this._shape.setPoints(points);
    }

    public void verticeAddUpdate(int vIdx, PointD point) {
        List<? extends PointD> points = this._shape.getPoints();
        points.add(vIdx, point);
        this._shape.setPoints(points);
    }

    public void verticeRemoveUpdate(int vIdx) {
        List<? extends PointD> points = this._shape.getPoints();
        points.remove(vIdx);
        this._shape.setPoints(points);
    }

    public void exportToXML(Document doc, Element parent) {
        Element graphic = doc.createElement("Graphic");
        this.addShape(doc, graphic, this._shape);
        this.addLegend(doc, graphic, this._legend, this._shape.getShapeType());
        parent.appendChild(graphic);
    }

    protected void addShape(Document doc, Element parent, Shape aShape) {
        Element shape = doc.createElement("Shape");
        boolean hasAngle = aShape.getShapeType() == ShapeTypes.Ellipse;
        Attr shapeType = doc.createAttribute("ShapeType");
        Attr visible = doc.createAttribute("Visible");
        Attr selected = doc.createAttribute("Selected");
        shapeType.setValue(aShape.getShapeType().toString());
        visible.setValue(String.valueOf(aShape.isVisible()));
        selected.setValue(String.valueOf(aShape.isSelected()));
        shape.setAttributeNode(shapeType);
        shape.setAttributeNode(visible);
        shape.setAttributeNode(selected);
        if (hasAngle) {
            Attr angle = doc.createAttribute("Angle");
            angle.setValue(String.valueOf(((EllipseShape)aShape).getAngle()));
            shape.setAttributeNode(angle);
        }
        Element points = doc.createElement("Points");
        List<? extends PointD> pointList = aShape.getPoints();
        for (PointD pointD : pointList) {
            Element point = doc.createElement("Point");
            Attr x = doc.createAttribute("X");
            Attr y = doc.createAttribute("Y");
            x.setValue(String.valueOf(pointD.X));
            y.setValue(String.valueOf(pointD.Y));
            point.setAttributeNode(x);
            point.setAttributeNode(y);
            points.appendChild(point);
        }
        shape.appendChild(points);
        parent.appendChild(shape);
    }

    protected void addLegend(Document doc, Element parent, ColorBreak aLegend, ShapeTypes shapeType) {
        Element legend = doc.createElement("Legend");
        Attr color = doc.createAttribute("Color");
        color.setValue(ColorUtil.toHexEncoding(aLegend.getColor()));
        legend.setAttributeNode(color);
        Attr legendType = doc.createAttribute("LegendType");
        legendType.setValue(aLegend.getBreakType().toString());
        switch (aLegend.getBreakType()) {
            case PointBreak: {
                PointBreak aPB = (PointBreak)aLegend;
                Attr outlineColor = doc.createAttribute("OutlineColor");
                Attr size = doc.createAttribute("Size");
                Attr style = doc.createAttribute("Style");
                Attr drawOutline = doc.createAttribute("DrawOutline");
                Attr drawFill = doc.createAttribute("DrawFill");
                Attr markerType = doc.createAttribute("MarkerType");
                Attr fontName = doc.createAttribute("FontName");
                Attr charIndex = doc.createAttribute("CharIndex");
                Attr imagePath = doc.createAttribute("ImagePath");
                Attr angle = doc.createAttribute("Angle");
                outlineColor.setValue(ColorUtil.toHexEncoding(aPB.getOutlineColor()));
                size.setValue(String.valueOf(aPB.getSize()));
                style.setValue(aPB.getStyle().toString());
                drawOutline.setValue(String.valueOf(aPB.isDrawOutline()));
                drawFill.setValue(String.valueOf(aPB.isDrawFill()));
                markerType.setValue(aPB.getMarkerType().toString());
                fontName.setValue(aPB.getFontName());
                charIndex.setValue(String.valueOf(aPB.getCharIndex()));
                imagePath.setValue(aPB.getImagePath());
                angle.setValue(String.valueOf(aPB.getAngle()));
                legend.setAttributeNode(legendType);
                legend.setAttributeNode(outlineColor);
                legend.setAttributeNode(size);
                legend.setAttributeNode(style);
                legend.setAttributeNode(drawOutline);
                legend.setAttributeNode(drawFill);
                legend.setAttributeNode(markerType);
                legend.setAttributeNode(fontName);
                legend.setAttributeNode(charIndex);
                legend.setAttributeNode(imagePath);
                legend.setAttributeNode(angle);
                break;
            }
            case LabelBreak: {
                LabelBreak aLB = (LabelBreak)aLegend;
                Attr text = doc.createAttribute("Text");
                Attr angle = doc.createAttribute("Angle");
                Attr fontName = doc.createAttribute("FontName");
                Attr fontSize = doc.createAttribute("FontSize");
                Attr fontBold = doc.createAttribute("FontBold");
                Attr yShift = doc.createAttribute("YShift");
                text.setValue(aLB.getText());
                angle.setValue(String.valueOf(aLB.getAngle()));
                fontName.setValue(aLB.getFont().getName());
                fontSize.setValue(String.valueOf(aLB.getFont().getSize()));
                fontBold.setValue(String.valueOf(aLB.getFont().isBold()));
                yShift.setValue(String.valueOf(aLB.getYShift()));
                legend.setAttributeNode(legendType);
                legend.setAttributeNode(text);
                legend.setAttributeNode(angle);
                legend.setAttributeNode(fontName);
                legend.setAttributeNode(fontSize);
                legend.setAttributeNode(fontBold);
                legend.setAttributeNode(yShift);
                break;
            }
            case ChartBreak: {
                ChartBreak aChB = (ChartBreak)aLegend;
                Attr shapeIndex = doc.createAttribute("ShapeIndex");
                Attr chartType = doc.createAttribute("ChartType");
                Attr chartData = doc.createAttribute("ChartData");
                Attr xShift = doc.createAttribute("XShift");
                Attr yShift = doc.createAttribute("YShift");
                Attr fontName = doc.createAttribute("FontName");
                Attr fontSize = doc.createAttribute("FontSize");
                Attr labelColor = doc.createAttribute("LabelColor");
                shapeIndex.setValue(String.valueOf(aChB.getShapeIndex()));
                chartType.setValue(aChB.getChartType().toString());
                String cdata = "";
                for (int i = 0; i < aChB.getItemNum(); ++i) {
                    cdata = i == 0 ? String.valueOf(aChB.getChartData().get(i)) : cdata + "," + String.valueOf(aChB.getChartData().get(i));
                }
                chartData.setValue(cdata);
                xShift.setValue(String.valueOf(aChB.getXShift()));
                yShift.setValue(String.valueOf(aChB.getYShift()));
                fontName.setValue(aChB.getLabelFont().getFontName());
                fontSize.setValue(String.valueOf(aChB.getLabelFont().getSize()));
                labelColor.setValue(ColorUtil.toHexEncoding(aChB.getLabelColor()));
                legend.setAttributeNode(legendType);
                legend.setAttributeNode(shapeIndex);
                legend.setAttributeNode(chartType);
                legend.setAttributeNode(chartData);
                legend.setAttributeNode(xShift);
                legend.setAttributeNode(yShift);
                legend.setAttributeNode(fontName);
                legend.setAttributeNode(fontSize);
                legend.setAttributeNode(labelColor);
                break;
            }
            case VectorBreak: {
                legend.setAttributeNode(legendType);
                break;
            }
            case PolylineBreak: {
                PolylineBreak aPLB = (PolylineBreak)aLegend;
                Attr size = doc.createAttribute("Size");
                Attr style = doc.createAttribute("Style");
                Attr drawSymbol = doc.createAttribute("DrawSymbol");
                Attr symbolSize = doc.createAttribute("SymbolSize");
                Attr symbolStyle = doc.createAttribute("SymbolStyle");
                Attr symbolColor = doc.createAttribute("SymbolColor");
                Attr symbolInterval = doc.createAttribute("SymbolInterval");
                size.setValue(String.valueOf(aPLB.getWidth()));
                style.setValue(aPLB.getStyle().toString());
                drawSymbol.setValue(String.valueOf(aPLB.getDrawSymbol()));
                symbolSize.setValue(String.valueOf(aPLB.getSymbolSize()));
                symbolStyle.setValue(String.valueOf((Object)aPLB.getSymbolStyle()));
                symbolColor.setValue(ColorUtil.toHexEncoding(aPLB.getSymbolColor()));
                symbolInterval.setValue(String.valueOf(aPLB.getSymbolInterval()));
                legend.setAttributeNode(legendType);
                legend.setAttributeNode(size);
                legend.setAttributeNode(style);
                legend.setAttributeNode(drawSymbol);
                legend.setAttributeNode(symbolSize);
                legend.setAttributeNode(symbolStyle);
                legend.setAttributeNode(symbolColor);
                legend.setAttributeNode(symbolInterval);
                break;
            }
            case PolygonBreak: {
                PolygonBreak aPGB = (PolygonBreak)aLegend;
                Attr outlineColor = doc.createAttribute("OutlineColor");
                Attr drawOutline = doc.createAttribute("DrawOutline");
                Attr drawFill = doc.createAttribute("DrawFill");
                Attr outlineSize = doc.createAttribute("OutlineSize");
                Attr backColor = doc.createAttribute("BackColor");
                Attr isMaskout = doc.createAttribute("IsMaskout");
                outlineColor.setValue(ColorUtil.toHexEncoding(aPGB.getOutlineColor()));
                drawOutline.setValue(String.valueOf(aPGB.isDrawOutline()));
                drawFill.setValue(String.valueOf(aPGB.isDrawFill()));
                outlineSize.setValue(String.valueOf(aPGB.getOutlineSize()));
                backColor.setValue(ColorUtil.toHexEncoding(aPGB.getBackColor()));
                isMaskout.setValue(String.valueOf(aPGB.isMaskout()));
                legend.setAttributeNode(legendType);
                legend.setAttributeNode(outlineColor);
                legend.setAttributeNode(drawOutline);
                legend.setAttributeNode(drawFill);
                legend.setAttributeNode(outlineSize);
                legend.setAttributeNode(backColor);
                legend.setAttributeNode(isMaskout);
            }
        }
        parent.appendChild(legend);
    }

    public void importFromXML(Element graphicNode) {
        Node shape = graphicNode.getElementsByTagName("Shape").item(0);
        this._shape = this.loadShape(shape);
        Node legend = graphicNode.getElementsByTagName("Legend").item(0);
        this._legend = this.loadLegend(legend, this._shape.getShapeType());
        this.updateResizeAbility();
    }

    protected Shape loadShape(Node shapeNode) {
        Shape aShape = null;
        try {
            Node angleNode;
            ShapeTypes shapeType = ShapeTypes.valueOf(shapeNode.getAttributes().getNamedItem("ShapeType").getNodeValue());
            switch (shapeType) {
                case Point: {
                    aShape = new PointShape();
                    break;
                }
                case WindArraw: {
                    aShape = new WindArrow();
                    break;
                }
                case Polyline: {
                    aShape = new PolylineShape();
                    break;
                }
                case CurveLine: {
                    aShape = new CurveLineShape();
                    break;
                }
                case Circle: {
                    aShape = new CircleShape();
                    break;
                }
                case Polygon: 
                case Rectangle: {
                    aShape = new PolygonShape();
                    break;
                }
                case CurvePolygon: {
                    aShape = new CurvePolygonShape();
                    break;
                }
                case Ellipse: {
                    aShape = new EllipseShape();
                }
            }
            aShape.setVisible(Boolean.parseBoolean(shapeNode.getAttributes().getNamedItem("Visible").getNodeValue()));
            aShape.setSelected(Boolean.parseBoolean(shapeNode.getAttributes().getNamedItem("Selected").getNodeValue()));
            if (aShape.getShapeType() == ShapeTypes.Ellipse && (angleNode = shapeNode.getAttributes().getNamedItem("Angle")) != null) {
                ((EllipseShape)aShape).setAngle(Float.parseFloat(angleNode.getNodeValue()));
            }
            ArrayList<PointD> pointList = new ArrayList<PointD>();
            Node pointsNode = ((Element)shapeNode).getElementsByTagName("Points").item(0);
            NodeList nl = ((Element)pointsNode).getElementsByTagName("Point");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node pNode = nl.item(i);
                PointD aPoint = new PointD(Double.parseDouble(pNode.getAttributes().getNamedItem("X").getNodeValue()), Double.parseDouble(pNode.getAttributes().getNamedItem("Y").getNodeValue()));
                pointList.add(aPoint);
            }
            aShape.setPoints(pointList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aShape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColorBreak loadLegend(Node legendNode, ShapeTypes shapeType) {
        ColorBreak legend = new ColorBreak();
        try {
            Color color = ColorUtil.parseToColor(legendNode.getAttributes().getNamedItem("Color").getNodeValue());
            String legendType = legendNode.getAttributes().getNamedItem("LegendType").getNodeValue();
            BreakTypes breakType = BreakTypes.valueOf(legendType);
            switch (breakType) {
                case PointBreak: {
                    PointBreak aPB = new PointBreak();
                    try {
                        aPB.setColor(color);
                        aPB.setDrawFill(Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("DrawFill").getNodeValue()));
                        aPB.setDrawOutline(Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("DrawOutline").getNodeValue()));
                        aPB.setOutlineColor(ColorUtil.parseToColor(legendNode.getAttributes().getNamedItem("OutlineColor").getNodeValue()));
                        aPB.setSize(Float.parseFloat(legendNode.getAttributes().getNamedItem("Size").getNodeValue()));
                        aPB.setStyle(PointStyle.valueOf(legendNode.getAttributes().getNamedItem("Style").getNodeValue()));
                        aPB.setMarkerType(MarkerType.valueOf(legendNode.getAttributes().getNamedItem("MarkerType").getNodeValue()));
                        aPB.setFontName(legendNode.getAttributes().getNamedItem("FontName").getNodeValue());
                        aPB.setCharIndex(Integer.parseInt(legendNode.getAttributes().getNamedItem("CharIndex").getNodeValue()));
                        aPB.setImagePath(legendNode.getAttributes().getNamedItem("ImagePath").getNodeValue());
                        aPB.setAngle(Float.parseFloat(legendNode.getAttributes().getNamedItem("Angle").getNodeValue()));
                        break;
                    }
                    catch (Exception exception) {
                        break;
                    }
                    finally {
                        legend = aPB;
                    }
                }
                case LabelBreak: {
                    LabelBreak aLB = new LabelBreak();
                    try {
                        aLB.setColor(color);
                        aLB.setAngle(Float.parseFloat(legendNode.getAttributes().getNamedItem("Angle").getNodeValue()));
                        aLB.setText(legendNode.getAttributes().getNamedItem("Text").getNodeValue());
                        String fontName = legendNode.getAttributes().getNamedItem("FontName").getNodeValue();
                        float fontSize = Float.parseFloat(legendNode.getAttributes().getNamedItem("FontSize").getNodeValue());
                        boolean fontBold = Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("FontBold").getNodeValue());
                        if (fontBold) {
                            aLB.setFont(new Font(fontName, 1, (int)fontSize));
                        } else {
                            aLB.setFont(new Font(fontName, 0, (int)fontSize));
                        }
                        aLB.setYShift(Float.parseFloat(legendNode.getAttributes().getNamedItem("YShift").getNodeValue()));
                        break;
                    }
                    catch (Exception fontName) {
                        break;
                    }
                    finally {
                        legend = aLB;
                    }
                }
                case ChartBreak: {
                    ChartBreak aChB = new ChartBreak(ChartTypes.BarChart);
                    try {
                        ChartTypes chartType = ChartTypes.valueOf(legendNode.getAttributes().getNamedItem("ChartType").getNodeValue());
                        aChB = new ChartBreak(chartType);
                        aChB.setShapeIndex(Integer.parseInt(legendNode.getAttributes().getNamedItem("ShapeIndex").getNodeValue()));
                        ArrayList<Float> cData = new ArrayList<Float>();
                        String[] cDataStr = legendNode.getAttributes().getNamedItem("ChartData").getNodeValue().split(",");
                        for (int i = 0; i < cDataStr.length; ++i) {
                            cData.add(Float.valueOf(Float.parseFloat(cDataStr[i])));
                        }
                        aChB.setChartData(cData);
                        aChB.setXShift(Integer.parseInt(legendNode.getAttributes().getNamedItem("XShift").getNodeValue()));
                        aChB.setYShift(Integer.parseInt(legendNode.getAttributes().getNamedItem("YShift").getNodeValue()));
                        String fontName = legendNode.getAttributes().getNamedItem("FontName").getNodeValue();
                        float fontSize = Float.parseFloat(legendNode.getAttributes().getNamedItem("FontSize").getNodeValue());
                        aChB.setLabelFont(new Font(fontName, 0, (int)fontSize));
                        aChB.setLabelColor(ColorUtil.parseToColor(legendNode.getAttributes().getNamedItem("LabelColor").getNodeValue()));
                        break;
                    }
                    catch (Exception chartType) {
                        break;
                    }
                    finally {
                        legend = aChB;
                    }
                }
                case VectorBreak: {
                    VectorBreak aVB = new VectorBreak();
                    try {
                        aVB.setColor(color);
                        break;
                    }
                    catch (Exception cData) {
                        break;
                    }
                    finally {
                        legend = aVB;
                    }
                }
                case PolylineBreak: {
                    PolylineBreak aPLB = new PolylineBreak();
                    try {
                        aPLB.setColor(color);
                        aPLB.setWidth(Float.parseFloat(legendNode.getAttributes().getNamedItem("Size").getNodeValue()));
                        aPLB.setStyle(LineStyles.valueOf(legendNode.getAttributes().getNamedItem("Style").getNodeValue()));
                        aPLB.setDrawSymbol(Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("DrawSymbol").getNodeValue()));
                        aPLB.setSymbolSize(Float.parseFloat(legendNode.getAttributes().getNamedItem("SymbolSize").getNodeValue()));
                        aPLB.setSymbolStyle(PointStyle.valueOf(legendNode.getAttributes().getNamedItem("SymbolStyle").getNodeValue()));
                        aPLB.setSymbolColor(ColorUtil.parseToColor(legendNode.getAttributes().getNamedItem("SymbolColor").getNodeValue()));
                        aPLB.setSymbolInterval(Integer.parseInt(legendNode.getAttributes().getNamedItem("SymbolInterval").getNodeValue()));
                        break;
                    }
                    catch (Exception cDataStr) {
                        break;
                    }
                    finally {
                        legend = aPLB;
                    }
                }
                case PolygonBreak: {
                    PolygonBreak aPGB = new PolygonBreak();
                    try {
                        aPGB.setColor(color);
                        aPGB.setDrawFill(Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("DrawFill").getNodeValue()));
                        aPGB.setDrawOutline(Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("DrawOutline").getNodeValue()));
                        aPGB.setOutlineSize(Float.parseFloat(legendNode.getAttributes().getNamedItem("OutlineSize").getNodeValue()));
                        aPGB.setOutlineColor(ColorUtil.parseToColor(legendNode.getAttributes().getNamedItem("OutlineColor").getNodeValue()));
                        aPGB.setBackColor(ColorUtil.parseToColor(legendNode.getAttributes().getNamedItem("BackColor").getNodeValue()));
                        aPGB.setMaskout(Boolean.parseBoolean(legendNode.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    legend = aPGB;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return legend;
    }
}

