/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.script;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.global.Extent;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.script.ChartForm;

public class MeteoInfoPlot {
    private boolean batchMode = true;
    private ChartPanel charPanel = new ChartPanel(null);

    private LineStyles getLineStyle(String style) {
        LineStyles ls = null;
        if (style.contains("--")) {
            ls = LineStyles.DASH;
        } else if (style.contains(":")) {
            ls = LineStyles.DOT;
        } else if (style.contains("-.")) {
            ls = LineStyles.DASHDOT;
        } else if (style.contains("-")) {
            ls = LineStyles.SOLID;
        }
        return ls;
    }

    private PointStyle getPointStyle(String style) {
        PointStyle ps = null;
        if (style.contains("o")) {
            ps = PointStyle.Circle;
        } else if (style.contains("D")) {
            ps = PointStyle.Diamond;
        } else if (style.contains("+")) {
            ps = PointStyle.Plus;
        } else if (style.contains("s")) {
            ps = PointStyle.Square;
        } else if (style.contains("*")) {
            ps = PointStyle.StarLines;
        } else if (style.contains("^")) {
            ps = PointStyle.UpTriangle;
        } else if (style.contains("x")) {
            ps = PointStyle.XCross;
        }
        return ps;
    }

    private Color getColor(String style) {
        if (style.contains("r")) {
            return Color.red;
        }
        if (style.contains("k")) {
            return Color.black;
        }
        if (style.contains("b")) {
            return Color.blue;
        }
        if (style.contains("g")) {
            return Color.green;
        }
        if (style.contains("g")) {
            return Color.white;
        }
        return null;
    }

    private int getSymbolInterval(int n) {
        int v = 20;
        int i = n < v ? 1 : n / v;
        return i;
    }

    public void axis(List<Number> limits) {
        if (limits.size() == 4) {
            double xmin = Double.parseDouble(limits.get(0).toString());
            double xmax = Double.parseDouble(limits.get(1).toString());
            double ymin = Double.parseDouble(limits.get(2).toString());
            double ymax = Double.parseDouble(limits.get(3).toString());
            XY1DPlot plot = (XY1DPlot)this.charPanel.getChart().getPlot();
            plot.setDrawExtent(new Extent(xmin, xmax, ymin, ymax));
            this.charPanel.paintGraphics();
        }
    }

    public void ylabel(String label) {
        XY1DPlot plot = (XY1DPlot)this.charPanel.getChart().getPlot();
        plot.getYAxis().setLabel(label);
        plot.getYAxis().setDrawLabel(true);
        this.charPanel.paintGraphics();
    }

    public void xlabel(String label) {
        XY1DPlot plot = (XY1DPlot)this.charPanel.getChart().getPlot();
        plot.getXAxis().setLabel(label);
        plot.getXAxis().setDrawLabel(true);
        this.charPanel.paintGraphics();
    }

    public void show() {
        ChartForm form = new ChartForm(this.charPanel);
        form.setSize(600, 500);
        form.setLocationRelativeTo(null);
        form.setDefaultCloseOperation(2);
        form.setVisible(true);
        this.charPanel.paintGraphics();
    }

    public List<Double> linespace(double min, double max, int n) {
        ArrayList<Double> values = new ArrayList<Double>();
        double delta = (max - min) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            values.add(min + delta * (double)i);
        }
        return values;
    }

    public List<Double> sin(List<Double> values) {
        ArrayList<Double> rvalues = new ArrayList<Double>();
        for (Double v : values) {
            rvalues.add(Math.sin(v));
        }
        return rvalues;
    }
}

