/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.proj.Projection;

public class Wagner7Projection
extends Projection {
    public Wagner7Projection() {
        this.proj4Name = "wag7";
        this.name = "Wagner_VII";
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.y = 0.9063077870366499 * Math.sin(lpphi);
        double theta = Math.asin(out.y);
        double ct = Math.cos(theta);
        out.x = 2.66723 * ct * Math.sin(lplam /= 3.0);
        double D = 1.0 / Math.sqrt(0.5 * (1.0 + ct * Math.cos(lplam)));
        out.y *= 1.24104 * D;
        out.x *= D;
        return out;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Wagner VII";
    }
}

