/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.proj.Projection;
import org.meteoinfo.projection.proj4j.util.ProjectionMath;

public class Wagner2Projection
extends Projection {
    private static final double C_x = 0.92483;
    private static final double C_y = 1.38725;
    private static final double C_p1 = 0.88022;
    private static final double C_p2 = 0.8855;

    public Wagner2Projection() {
        this.proj4Name = "wag2";
        this.name = "Wagner_II";
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.y = ProjectionMath.asin(0.88022 * Math.sin(0.8855 * lpphi));
        out.x = 0.92483 * lplam * Math.cos(lpphi);
        out.y = 1.38725 * lpphi;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = xyy / 1.38725;
        out.x = xyx / (0.92483 * Math.cos(out.y));
        out.y = ProjectionMath.asin(Math.sin(out.y) / 0.88022) / 0.8855;
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Wagner II";
    }
}

