/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.proj.Projection;

public class CrasterProjection
extends Projection {
    private static final double XM = 0.9772050238058398;
    private static final double RXM = 1.0233267079464885;
    private static final double YM = 3.0699801238394655;
    private static final double RYM = 0.32573500793527993;
    private static final double THIRD = 0.3333333333333333;

    public CrasterProjection() {
        this.proj4Name = "crast";
        this.name = "Craster_Parabolic";
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = 0.9772050238058398 * lplam * (2.0 * Math.cos((lpphi *= 0.3333333333333333) + lpphi) - 1.0);
        out.y = 3.0699801238394655 * Math.sin(lpphi);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = 3.0 * Math.asin(xyy * 0.32573500793527993);
        out.x = xyx * 1.0233267079464885 / (2.0 * Math.cos((out.y + out.y) * 0.3333333333333333) - 1.0);
        return out;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Craster Parabolic (Putnins P4)";
    }
}

