/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.cmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.projection.proj4j.CRSFactory;
import org.meteoinfo.projection.proj4j.Proj4jException;
import org.meteoinfo.projection.proj4j.io.MetaCRSTestCase;
import org.meteoinfo.projection.proj4j.io.MetaCRSTestFileReader;
import org.meteoinfo.projection.proj4j.util.CRSCache;

public class MetaCRSTestCmd {
    private static final int TESTS_PER_LINE = 50;
    private static CRSFactory csFactory = new CRSFactory();
    private List<String> filenames = new ArrayList<String>();
    private boolean verbose = false;
    int count = 0;
    int failCount = 0;
    int errCount = 0;
    private CRSCache crsCache = new CRSCache();

    public static void main(String[] args) {
        MetaCRSTestCmd cmd = new MetaCRSTestCmd();
        cmd.parseArgs(args);
        try {
            cmd.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String usage() {
        return "Usage: MetaCRSTestCmd [-verbose] { <test-file-name> }";
    }

    private void parseArgs(String[] args) {
        if (args.length <= 0) {
            System.err.println(MetaCRSTestCmd.usage());
            System.exit(1);
        }
        this.parseFlags(args);
        this.parseFiles(args);
    }

    private void parseFlags(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-") || !arg.equalsIgnoreCase("-verbose")) continue;
            this.verbose = true;
        }
    }

    private void parseFiles(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            this.filenames.add(arg);
        }
    }

    private void execute() throws IOException {
        long timeInMillis = System.currentTimeMillis();
        for (String filename : this.filenames) {
            this.execute(filename);
        }
        System.out.println();
        System.out.println("Tests run: " + this.count + ",  Failures: " + this.failCount + ",  Errors: " + this.errCount);
        long timeMS = System.currentTimeMillis() - timeInMillis;
        System.out.println("Time: " + (double)timeMS / 1000.0 + " s");
    }

    private void execute(String filename) throws IOException {
        System.out.println("File: " + filename);
        File file = new File(filename);
        MetaCRSTestFileReader reader = new MetaCRSTestFileReader(file);
        List<MetaCRSTestCase> tests = reader.readTests();
        for (MetaCRSTestCase test : tests) {
            boolean isOk;
            test.setCache(this.crsCache);
            ++this.count;
            System.out.print(".");
            try {
                isOk = test.execute(csFactory);
            }
            catch (Proj4jException ex) {
                System.out.println(ex);
                ++this.errCount;
                continue;
            }
            if (!isOk) {
                ++this.failCount;
                System.out.print("F");
            }
            if (this.verbose || !isOk) {
                System.out.println();
                test.print(System.out);
            }
            if (this.count % 50 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }
}

