/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.projection.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.shape.PolygonShape;

public class TransverseMercator
extends ProjectionInfo {
    public TransverseMercator(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.cutoff = 85.0511f;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Transverse_Mercator;
    }

    @Override
    public void setCutoff(float value) {
        this.cutoff = value;
        this.updateBoundary();
    }

    @Override
    void updateBoundary() {
        double x0 = -2.0E7;
        double x1 = 2.0E7;
        double y0 = -1.0E7;
        double y1 = 1.0E7;
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(x0, y0));
        points.add(new PointD(x1, y0));
        points.add(new PointD(x1, y1));
        points.add(new PointD(x0, y1));
        points.add(new PointD(x0, y0));
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ps;
    }
}

