/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.projection.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.shape.PolygonShape;

public class Mercator
extends ProjectionInfo {
    public Mercator(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.cutoff = 85.0511f;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Mercator;
    }

    @Override
    public void setCutoff(float value) {
        this.cutoff = value;
        this.updateBoundary();
    }

    @Override
    void updateBoundary() {
        double epsilon = 1.0E-10;
        double cenLon = this.getCenterLon();
        double minLon = cenLon - 180.0 + epsilon;
        double maxLon = cenLon + 180.0 - epsilon;
        double minLat = -this.cutoff;
        double maxLat = this.cutoff;
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD(minLon, minLat));
        points.add(new PointD(maxLon, minLat));
        points.add(new PointD(maxLon, maxLat));
        points.add(new PointD(minLon, maxLat));
        points.add(new PointD(minLon, minLat));
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ProjectionUtil.projectPolygonShape(ps, KnownCoordinateSystems.geographic.world.WGS1984, this);
    }
}

