/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.util.HashMap;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.MarkerType;
import org.meteoinfo.legend.PointStyle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PointBreak
extends ColorBreak {
    protected MarkerType markerType;
    protected Color outlineColor;
    protected float outlineSize;
    protected float size;
    protected PointStyle style;
    protected boolean drawOutline;
    protected boolean drawFill;
    protected String fontName;
    protected int charIndex;
    protected String imagePath;
    protected float angle;

    public PointBreak() {
        this.breakType = BreakTypes.PointBreak;
        this.markerType = MarkerType.Simple;
        this.fontName = "Arial";
        this.charIndex = 0;
        this.outlineColor = Color.black;
        this.outlineSize = 1.0f;
        this.size = 6.0f;
        this.style = PointStyle.Circle;
        this.drawOutline = true;
        this.drawFill = true;
        this.angle = 0.0f;
    }

    public MarkerType getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(MarkerType value) {
        this.markerType = value;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String name) {
        this.fontName = name;
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public void setCharIndex(int idx) {
        this.charIndex = idx;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String path) {
        this.imagePath = path;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color c) {
        this.outlineColor = c;
    }

    public float getOutlineSize() {
        return this.outlineSize;
    }

    public void setOutlineSize(float value) {
        this.outlineSize = value;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float value) {
        this.size = value;
    }

    public PointStyle getStyle() {
        return this.style;
    }

    public void setStyle(PointStyle value) {
        if (value != null) {
            this.style = value;
        }
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean isTrue) {
        this.drawOutline = isTrue;
    }

    public boolean isDrawFill() {
        return this.drawFill;
    }

    public void setDrawFill(boolean isTrue) {
        this.drawFill = isTrue;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float value) {
        this.angle = value;
    }

    @Override
    public Object getPropertyObject() {
        HashMap<String, String> objAttr = new HashMap<String, String>();
        objAttr.put("Color", "Color");
        objAttr.put("OutlineColor", "OutlineColor");
        objAttr.put("OutlineSize", "OutlineSize");
        objAttr.put("Size", "Size");
        objAttr.put("Style", "Style");
        objAttr.put("DrawOutline", "DrawOutline");
        objAttr.put("DrawFill", "DrawFill");
        objAttr.put("DrawPoint", "DrawPoint");
        objAttr.put("Angle", "Angle");
        return objAttr;
    }

    @Override
    public Object clone() {
        PointBreak aCB = new PointBreak();
        aCB.setCaption(this.getCaption());
        aCB.setColor(this.getColor());
        aCB.setDrawShape(this.isDrawShape());
        aCB.setEndValue(this.getEndValue());
        aCB.setNoData(this.isNoData());
        aCB.setStartValue(this.getStartValue());
        aCB.setMarkerType(this.markerType);
        aCB.setFontName(this.fontName);
        aCB.setCharIndex(this.charIndex);
        aCB.setImagePath(this.imagePath);
        aCB.setOutlineColor(this.outlineColor);
        aCB.setOutlineSize(this.outlineSize);
        aCB.setSize(this.size);
        aCB.setDrawOutline(this.drawOutline);
        aCB.setDrawFill(this.drawFill);
        aCB.setStyle(this.style);
        aCB.setAngle(this.angle);
        return aCB;
    }

    @Override
    public void exportToXML(Document doc, Element parent) {
        Element brk = doc.createElement("Break");
        Attr captionAttr = doc.createAttribute("Caption");
        Attr startValueAttr = doc.createAttribute("StartValue");
        Attr endValueAttr = doc.createAttribute("EndValue");
        Attr colorAttr = doc.createAttribute("Color");
        Attr isNoDataAttr = doc.createAttribute("IsNoData");
        captionAttr.setValue(this.getCaption());
        startValueAttr.setValue(String.valueOf(this.getStartValue()));
        endValueAttr.setValue(String.valueOf(this.getEndValue()));
        colorAttr.setValue(ColorUtil.toHexEncoding(this.getColor()));
        isNoDataAttr.setValue(String.valueOf(this.isNoData()));
        brk.setAttributeNode(captionAttr);
        brk.setAttributeNode(startValueAttr);
        brk.setAttributeNode(endValueAttr);
        brk.setAttributeNode(colorAttr);
        brk.setAttributeNode(isNoDataAttr);
        parent.appendChild(brk);
    }
}

