/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import org.meteoinfo.global.event.ISizeChangedListener;
import org.meteoinfo.global.event.SizeChangedEvent;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.legend.AlignType;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;

public class LabelBreak
extends ColorBreak {
    private EventListenerList _listeners = new EventListenerList();
    private String _text;
    private float _angle;
    private Font _font;
    private AlignType _alignType;
    private float _xShift;
    private float _yShift;

    public LabelBreak() {
        this.setBreakType(BreakTypes.LabelBreak);
        this._text = "";
        this._angle = 0.0f;
        this.setColor(Color.black);
        this._font = new Font(GlobalUtil.getDefaultFontName(), 0, 7);
        this._alignType = AlignType.Center;
        this._yShift = 0.0f;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
        this.fireSizeChangedEvent(new SizeChangedEvent(this));
    }

    public float getAngle() {
        return this._angle;
    }

    public void setAngle(float angle) {
        this._angle = angle;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font f) {
        this._font = f;
        this.fireSizeChangedEvent(new SizeChangedEvent(this));
    }

    public AlignType getAlignType() {
        return this._alignType;
    }

    public void setAlignType(AlignType at) {
        this._alignType = at;
    }

    public float getYShift() {
        return this._yShift;
    }

    public void setYShift(float yshift) {
        this._yShift = yshift;
    }

    public float getXShift() {
        return this._xShift;
    }

    public void setXShift(float xshift) {
        this._xShift = xshift;
    }

    @Override
    public Object getPropertyObject() {
        HashMap<String, String> objAttr = new HashMap<String, String>();
        objAttr.put("Text", "Text");
        objAttr.put("Angle", "Angle");
        objAttr.put("Color", "Color");
        objAttr.put("Font", "Font");
        return objAttr;
    }

    @Override
    public Object clone() {
        LabelBreak aCB = new LabelBreak();
        aCB.setCaption(this.getCaption());
        aCB.setColor(this.getColor());
        aCB.setDrawShape(this.isDrawShape());
        aCB.setEndValue(this.getEndValue());
        aCB.setNoData(this.isNoData());
        aCB.setStartValue(this.getStartValue());
        aCB.setAngle(this._angle);
        aCB.setText(this._text);
        aCB.setFont(this._font);
        aCB.setAlignType(this._alignType);
        aCB.setYShift(this._yShift);
        aCB.setXShift(this._xShift);
        return aCB;
    }

    public void addSizeChangedListener(ISizeChangedListener scl) {
        this._listeners.add(ISizeChangedListener.class, scl);
    }

    public void removeSizeChangedListener(ISizeChangedListener scl) {
        this._listeners.remove(ISizeChangedListener.class, scl);
    }

    public void fireSizeChangedEvent(SizeChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ISizeChangedListener.class) continue;
            ((ISizeChangedListener)listeners[i + 1]).sizeChangedEvent(event);
        }
    }
}

