/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import com.l2fprod.common.beans.BaseBeanInfo;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.legend.Constants;
import org.meteoinfo.legend.ItemNode;
import org.meteoinfo.legend.LayerNode;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.NodeTypes;

public class GroupNode
extends ItemNode {
    private int _groupHandle = -1;
    private List<LayerNode> _layers;
    private int _checkStatus = 0;
    private MapFrame _mapFrame = null;

    public GroupNode(String name) {
        this.setText(name);
        this._layers = new ArrayList<LayerNode>();
        this.setNodeType(NodeTypes.GroupNode);
    }

    public MapFrame getMapFrame() {
        return this._mapFrame;
    }

    public void setMapFrame(MapFrame mf) {
        this._mapFrame = mf;
    }

    public int getGroupHandle() {
        return this._groupHandle;
    }

    public void setGroupHandle(int handle) {
        this._groupHandle = handle;
    }

    public List<LayerNode> getLayers() {
        return this._layers;
    }

    public int getCheckStatus() {
        return this._checkStatus;
    }

    public void setCheckStatus(int s) {
        this._checkStatus = s;
    }

    public void addLayer(LayerNode aLayer) {
        this._layers.add(aLayer);
        aLayer.setGroupHandle(this._groupHandle);
    }

    public void removeLayer(LayerNode aLayer) {
        this._layers.remove(aLayer);
        aLayer.setGroupHandle(-1);
    }

    public void addLayer(int index, LayerNode aLayer) {
        this._layers.add(index, aLayer);
        aLayer.setGroupHandle(this._groupHandle);
    }

    public int getLayerIndex(LayerNode aLayer) {
        return this._layers.indexOf(aLayer);
    }

    public void insertLayer(LayerNode aLayer, int index) {
        this._layers.add(index, aLayer);
        aLayer.setGroupHandle(this._groupHandle);
    }

    public void updateCheckStatus() {
        boolean allChecked = true;
        boolean hasChecked = false;
        for (LayerNode aLN : this._layers) {
            if (aLN.isChecked()) {
                hasChecked = true;
                continue;
            }
            allChecked = false;
        }
        this._checkStatus = allChecked ? 1 : (hasChecked ? 2 : 0);
    }

    @Override
    public int getDrawHeight() {
        if (this.isExpanded()) {
            return this.getExpandedHeight();
        }
        return this.getHeight();
    }

    @Override
    public int getExpandedHeight() {
        int height = this.getHeight();
        for (LayerNode layerNode : this._layers) {
            int lnHeight = layerNode.isExpanded() ? layerNode.getExpandedHeight() : layerNode.getHeight();
            height += lnHeight + Constants.ITEM_PAD;
        }
        return height;
    }

    public static class GroupNodeBeanBeanInfo
    extends BaseBeanInfo {
        public GroupNodeBeanBeanInfo() {
            super(GroupNodeBean.class);
            this.addProperty("text").setCategory("General").setDisplayName("Text");
        }
    }

    public class GroupNodeBean {
        public String getText() {
            return GroupNode.this.getText();
        }

        public void setText(String value) {
            GroupNode.this.setText(value);
            GroupNode.this._mapFrame.getLegend().paintGraphics();
        }
    }
}

