/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.global.colors.ColorMap;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.layer.FrmLayerProperty;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.FrmLegendSet;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.ui.ColorComboBoxModel;
import org.meteoinfo.ui.ColorListCellRender;

public class FrmLegendBreaks
extends JDialog {
    private final Dialog _parent;
    private LegendScheme _legendScheme = null;
    private double startValue;
    private double endValue;
    private double _interval;
    private boolean _isUniqueValue = false;
    private ButtonGroup buttonGroup1;
    private JButton jButton_NewColors;
    private JButton jButton_NewLegend;
    private JCheckBox jCheckBox_Log;
    private JComboBox jComboBox_ColorTable;
    private JLabel jLabel1;
    private JLabel jLabel_ColorTable;
    private JLabel jLabel_From;
    private JLabel jLabel_Interval;
    private JLabel jLabel_Max;
    private JLabel jLabel_Min;
    private JLabel jLabel_To;
    private JPanel jPanel_Interval;
    private JPanel jPanel_Values;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField_EndValue;
    private JTextField jTextField_Interval;
    private JTextField jTextField_StartValue;
    private JTextField jTextField_Values;
    private JTextField jTextField_logFactor;

    public FrmLegendBreaks(Dialog parent, boolean modal, boolean isUniqueValue) {
        super(parent, modal);
        this.initComponents();
        this._parent = parent;
        this._isUniqueValue = isUniqueValue;
    }

    private void setInterval() {
        int bnum = this._legendScheme.getBreakNum();
        if (bnum > 2) {
            ColorBreak aCB = this._legendScheme.getLegendBreaks().get(0);
            this.startValue = Double.parseDouble(aCB.getEndValue().toString());
            if (this._legendScheme.getHasNoData()) {
                aCB = this._legendScheme.getLegendBreaks().get(bnum - 2);
                this.endValue = Double.parseDouble(aCB.getStartValue().toString());
                this._interval = BigDecimalUtil.div(BigDecimalUtil.sub(this.endValue, this.startValue), bnum - 3);
            } else {
                aCB = this._legendScheme.getLegendBreaks().get(bnum - 1);
                this.endValue = Double.parseDouble(aCB.getStartValue().toString());
                switch (this._legendScheme.getShapeType()) {
                    case Polyline: 
                    case PolylineZ: {
                        this._interval = BigDecimalUtil.div(BigDecimalUtil.sub(this.endValue, this.startValue), bnum - 1);
                        break;
                    }
                    default: {
                        this._interval = BigDecimalUtil.div(BigDecimalUtil.sub(this.endValue, this.startValue), bnum - 2);
                    }
                }
            }
            this.jTextField_StartValue.setText(String.valueOf(this.startValue));
            this.jTextField_EndValue.setText(String.valueOf(this.endValue));
            this.jTextField_Interval.setText(String.valueOf(this._interval));
        }
    }

    private void setInterval_log() {
        double min = this._legendScheme.getMinValue();
        double max = this._legendScheme.getMaxValue();
        int minE = (int)Math.floor(Math.log10(min));
        int maxE = (int)Math.floor(Math.log10(max));
        if (min == 0.0) {
            minE = maxE - 3;
        }
        if (max == 0.0) {
            maxE = minE + 3;
        }
        this.jTextField_StartValue.setText(String.valueOf(minE));
        this.jTextField_EndValue.setText(String.valueOf(maxE));
        this.jTextField_Interval.setText(String.valueOf(1));
    }

    private void initialize() {
        if (!this._isUniqueValue) {
            this.jLabel_Min.setEnabled(true);
            this.jLabel_Max.setEnabled(true);
            this.jLabel_From.setEnabled(true);
            this.jTextField_StartValue.setEnabled(true);
            this.jLabel_To.setEnabled(true);
            this.jTextField_EndValue.setEnabled(true);
            this.jLabel_Interval.setEnabled(true);
            this.jTextField_Interval.setEnabled(true);
            this.jButton_NewLegend.setEnabled(true);
            this.jLabel_Min.setText("Min: " + String.format("%1$E", this._legendScheme.getMinValue()));
            this.jLabel_Max.setText("Max: " + String.format("%1$E", this._legendScheme.getMaxValue()));
            this.setInterval();
        } else {
            this.jLabel_Min.setEnabled(false);
            this.jLabel_Max.setEnabled(false);
            this.jLabel_From.setEnabled(false);
            this.jTextField_StartValue.setEnabled(false);
            this.jLabel_To.setEnabled(false);
            this.jTextField_EndValue.setEnabled(false);
            this.jLabel_Interval.setEnabled(false);
            this.jTextField_Interval.setEnabled(false);
            this.jButton_NewLegend.setEnabled(false);
        }
        try {
            ColorMap[] colorTables = ColorUtil.getColorTables();
            ColorListCellRender render = new ColorListCellRender();
            render.setPreferredSize(new Dimension(62, 21));
            this.jComboBox_ColorTable.setModel(new ColorComboBoxModel(colorTables));
            this.jComboBox_ColorTable.setRenderer(render);
            ColorMap ct = ColorUtil.findColorTable(colorTables, "grads_rainbow");
            if (ct != null) {
                this.jComboBox_ColorTable.setSelectedItem(ct);
            } else {
                this.jComboBox_ColorTable.setSelectedIndex(0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FrmLegendBreaks.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel_Min = new JLabel();
        this.jLabel_Max = new JLabel();
        this.jButton_NewLegend = new JButton();
        this.jButton_NewColors = new JButton();
        this.jComboBox_ColorTable = new JComboBox();
        this.jLabel_ColorTable = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel_Interval = new JPanel();
        this.jLabel_From = new JLabel();
        this.jTextField_StartValue = new JTextField();
        this.jLabel_To = new JLabel();
        this.jTextField_EndValue = new JTextField();
        this.jLabel_Interval = new JLabel();
        this.jTextField_Interval = new JTextField();
        this.jCheckBox_Log = new JCheckBox();
        this.jTextField_logFactor = new JTextField();
        this.jPanel_Values = new JPanel();
        this.jTextField_Values = new JTextField();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                FrmLegendBreaks.this.formWindowOpened(evt);
            }
        });
        this.jLabel_Min.setText("Min:");
        this.jLabel_Max.setText("Max:");
        this.jButton_NewLegend.setText("New Legend");
        this.jButton_NewLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendBreaks.this.jButton_NewLegendActionPerformed(evt);
            }
        });
        this.jButton_NewColors.setText("New Colors");
        this.jButton_NewColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendBreaks.this.jButton_NewColorsActionPerformed(evt);
            }
        });
        this.jComboBox_ColorTable.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel_ColorTable.setText("Color table:");
        this.jLabel_From.setText("from:");
        this.jTextField_StartValue.setPreferredSize(new Dimension(89, 24));
        this.jLabel_To.setText("to:");
        this.jTextField_EndValue.setPreferredSize(new Dimension(89, 24));
        this.jLabel_Interval.setText("Interval:");
        this.jTextField_Interval.setPreferredSize(new Dimension(89, 24));
        this.jCheckBox_Log.setText("Log");
        this.jCheckBox_Log.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendBreaks.this.jCheckBox_LogActionPerformed(evt);
            }
        });
        this.jTextField_logFactor.setText("1");
        this.jTextField_logFactor.setEnabled(false);
        GroupLayout jPanel_IntervalLayout = new GroupLayout(this.jPanel_Interval);
        this.jPanel_Interval.setLayout(jPanel_IntervalLayout);
        jPanel_IntervalLayout.setHorizontalGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_IntervalLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_Interval).addComponent(this.jLabel_From)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField_StartValue, -2, 120, -2).addComponent(this.jTextField_Interval, -2, 120, -2)).addGap(18, 18, 18).addGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_IntervalLayout.createSequentialGroup().addComponent(this.jLabel_To).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_EndValue, -1, 144, Short.MAX_VALUE)).addGroup(jPanel_IntervalLayout.createSequentialGroup().addComponent(this.jCheckBox_Log).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_logFactor))).addContainerGap()));
        jPanel_IntervalLayout.setVerticalGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_IntervalLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_From).addComponent(this.jTextField_StartValue, -2, -1, -2).addComponent(this.jLabel_To).addComponent(this.jTextField_EndValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_IntervalLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField_Interval, -2, -1, -2).addComponent(this.jLabel_Interval).addComponent(this.jCheckBox_Log).addComponent(this.jTextField_logFactor, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Interval", this.jPanel_Interval);
        this.jLabel1.setText("Delimiter is \";\"");
        GroupLayout jPanel_ValuesLayout = new GroupLayout(this.jPanel_Values);
        this.jPanel_Values.setLayout(jPanel_ValuesLayout);
        jPanel_ValuesLayout.setHorizontalGroup(jPanel_ValuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ValuesLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_ValuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ValuesLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1).addContainerGap(263, Short.MAX_VALUE)).addGroup(jPanel_ValuesLayout.createSequentialGroup().addComponent(this.jTextField_Values).addContainerGap()))));
        jPanel_ValuesLayout.setVerticalGroup(jPanel_ValuesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ValuesLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jTextField_Values, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Values", this.jPanel_Values);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel_Min).addGap(101, 101, 101).addComponent(this.jLabel_Max)).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel_ColorTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_ColorTable, 0, -1, Short.MAX_VALUE)).addComponent(this.jTabbedPane1, GroupLayout.Alignment.LEADING, -2, 437, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(82, 82, 82).addComponent(this.jButton_NewLegend).addGap(56, 56, 56).addComponent(this.jButton_NewColors).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Max).addComponent(this.jLabel_Min)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 130, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_ColorTable).addComponent(this.jComboBox_ColorTable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_NewLegend).addComponent(this.jButton_NewColors)).addContainerGap()));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.initialize();
    }

    private void jButton_NewLegendActionPerformed(ActionEvent evt) {
        double[] cValues;
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this._interval = Double.parseDouble(this.jTextField_Interval.getText());
            this.startValue = Double.parseDouble(this.jTextField_StartValue.getText());
            this.endValue = Double.parseDouble(this.jTextField_EndValue.getText());
            if ((int)((this.endValue - this.startValue) / this._interval) < 2) {
                JOptionPane.showMessageDialog(null, "Please reset the data!", "Error", 0);
                return;
            }
            if (this.jCheckBox_Log.isSelected()) {
                int ev = Integer.parseInt(this.jTextField_EndValue.getText());
                int step = Integer.parseInt(this.jTextField_Interval.getText());
                double factor = Double.parseDouble(this.jTextField_logFactor.getText());
                ArrayList<Integer> vs = new ArrayList<Integer>();
                for (int sv = Integer.parseInt(this.jTextField_StartValue.getText()); sv < ev; sv += step) {
                    vs.add(sv);
                }
                cValues = new double[vs.size()];
                for (int i = 0; i < vs.size(); ++i) {
                    cValues[i] = Math.pow(10.0, ((Integer)vs.get(i)).intValue()) * factor;
                }
            } else {
                cValues = LegendManage.createContourValuesInterval(this.startValue, this.endValue, this._interval);
            }
        } else {
            String vstr = this.jTextField_Values.getText();
            String[] vstrs = vstr.split(";");
            cValues = new double[vstrs.length];
            for (int i = 0; i < vstrs.length; ++i) {
                cValues[i] = Double.parseDouble(vstrs[i].trim());
            }
        }
        Color[] colors = this.createColors(cValues.length + 1);
        LegendScheme aLS = this._isUniqueValue ? LegendManage.createUniqValueLegendScheme(cValues, colors, this._legendScheme.getShapeType(), this._legendScheme.getMinValue(), this._legendScheme.getMaxValue(), (Boolean)this._legendScheme.getHasNoData(), this._legendScheme.getUndefValue()) : LegendManage.createGraduatedLegendScheme(cValues, colors, this._legendScheme.getShapeType(), this._legendScheme.getMinValue(), this._legendScheme.getMaxValue(), this._legendScheme.getHasNoData(), this._legendScheme.getUndefValue());
        aLS.setFieldName(this._legendScheme.getFieldName());
        this._legendScheme = aLS;
        if (this._parent.getClass() == FrmLegendSet.class) {
            ((FrmLegendSet)this._parent).setLegendScheme(aLS);
        } else if (this._parent.getClass() == FrmLayerProperty.class) {
            ((FrmLayerProperty)this._parent).setLegendScheme(aLS);
        }
    }

    private void jButton_NewColorsActionPerformed(ActionEvent evt) {
        int colorNum = this._legendScheme.getBreakNum();
        if (this._legendScheme.getShapeType() == ShapeTypes.Polyline) {
            ++colorNum;
        }
        Color[] colors = this.createColors(colorNum);
        for (int i = 0; i < this._legendScheme.getBreakNum(); ++i) {
            this._legendScheme.getLegendBreaks().get(i).setColor(colors[i]);
        }
        if (this._parent.getClass() == FrmLegendSet.class) {
            ((FrmLegendSet)this._parent).setLegendScheme(this._legendScheme);
        } else if (this._parent.getClass() == FrmLayerProperty.class) {
            ((FrmLayerProperty)this._parent).setLegendScheme(this._legendScheme);
        }
    }

    private void jCheckBox_LogActionPerformed(ActionEvent evt) {
        this.jTextField_logFactor.setEnabled(this.jCheckBox_Log.isSelected());
        if (this.jCheckBox_Log.isSelected()) {
            this.setInterval_log();
        } else {
            this.setInterval();
        }
    }

    public void setLegendScheme(LegendScheme aLS) {
        this._legendScheme = (LegendScheme)aLS.clone();
        this.initialize();
    }

    private Color[] createColors(int colorNum) {
        ColorComboBoxModel model = (ColorComboBoxModel)this.jComboBox_ColorTable.getModel();
        ColorMap ct = (ColorMap)model.getSelectedItem();
        return ct.getColors(colorNum);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmLegendBreaks.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmLegendBreaks.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmLegendBreaks.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmLegendBreaks.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmLegendBreaks dialog = new FrmLegendBreaks((Dialog)new JDialog(), true, false);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

