/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layout;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.event.ILayersUpdatedListener;
import org.meteoinfo.global.event.IMapViewUpdatedListener;
import org.meteoinfo.global.event.LayersUpdatedEvent;
import org.meteoinfo.global.event.MapViewUpdatedEvent;
import org.meteoinfo.layout.ElementType;
import org.meteoinfo.layout.LayoutElement;
import org.meteoinfo.layout.ResizeAbility;
import org.meteoinfo.legend.GridLabelPosition;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.MapFrame;

public class LayoutMap
extends LayoutElement {
    private EventListenerList _listeners = new EventListenerList();
    private MapFrame _mapFrame = null;
    private boolean _drawDegreeSymbol = false;
    private final TileLoadListener tileLoadListener;

    public void addMapViewUpdatedListener(IMapViewUpdatedListener listener) {
        this._listeners.add(IMapViewUpdatedListener.class, listener);
    }

    public void removeMapViewUpdatedListener(IMapViewUpdatedListener listener) {
        this._listeners.remove(IMapViewUpdatedListener.class, listener);
    }

    public void fireMapViewUpdatedEvent() {
        this.fireMapViewUpdatedEvent(new MapViewUpdatedEvent(this));
    }

    private void fireMapViewUpdatedEvent(MapViewUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IMapViewUpdatedListener.class) continue;
            ((IMapViewUpdatedListener)listeners[i + 1]).mapViewUpdatedEvent(event);
        }
    }

    public LayoutMap(MapFrame mapFrame, TileLoadListener tll) {
        this.setElementType(ElementType.LayoutMap);
        this.setResizeAbility(ResizeAbility.ResizeAll);
        this.setMapFrame(mapFrame);
        this.tileLoadListener = tll;
    }

    public MapFrame getMapFrame() {
        return this._mapFrame;
    }

    public void setMapFrame(MapFrame mf) {
        this._mapFrame = mf;
        this._mapFrame.addMapViewUpdatedListener(new IMapViewUpdatedListener(){

            @Override
            public void mapViewUpdatedEvent(MapViewUpdatedEvent event) {
                LayoutMap.this.fireMapViewUpdatedEvent();
            }
        });
        this._mapFrame.addLayersUpdatedListener(new ILayersUpdatedListener(){

            @Override
            public void layersUpdatedEvent(LayersUpdatedEvent event) {
                LayoutMap.this.fireMapViewUpdatedEvent();
            }
        });
    }

    @Override
    public int getLeft() {
        return this._mapFrame.getLayoutBounds().x;
    }

    @Override
    public void setLeft(int left) {
        this._mapFrame.setLayoutBounds(new Rectangle(left, this._mapFrame.getLayoutBounds().y, this._mapFrame.getLayoutBounds().width, this._mapFrame.getLayoutBounds().height));
    }

    @Override
    public int getTop() {
        return this._mapFrame.getLayoutBounds().y;
    }

    @Override
    public void setTop(int top) {
        this._mapFrame.setLayoutBounds(new Rectangle(this._mapFrame.getLayoutBounds().x, top, this._mapFrame.getLayoutBounds().width, this._mapFrame.getLayoutBounds().height));
    }

    @Override
    public int getWidth() {
        return this._mapFrame.getLayoutBounds().width;
    }

    @Override
    public void setWidth(int width) {
        this._mapFrame.setLayoutBounds(new Rectangle(this._mapFrame.getLayoutBounds().x, this._mapFrame.getLayoutBounds().y, width, this._mapFrame.getLayoutBounds().height));
    }

    @Override
    public int getHeight() {
        return this._mapFrame.getLayoutBounds().height;
    }

    @Override
    public void setHeight(int height) {
        this._mapFrame.setLayoutBounds(new Rectangle(this._mapFrame.getLayoutBounds().x, this._mapFrame.getLayoutBounds().y, this._mapFrame.getLayoutBounds().width, height));
    }

    @Override
    public Rectangle getBounds() {
        return this._mapFrame.getLayoutBounds();
    }

    public void setBounds(Rectangle rect) {
        this._mapFrame.setLayoutBounds(rect);
    }

    @Override
    public Color getBackColor() {
        return this._mapFrame.getBackColor();
    }

    @Override
    public void setBackColor(Color color) {
        this._mapFrame.setBackColor(color);
    }

    @Override
    public Color getForeColor() {
        return this._mapFrame.getForeColor();
    }

    @Override
    public void setForeColor(Color color) {
        this._mapFrame.setForeColor(color);
    }

    public boolean isDrawNeatLine() {
        return this._mapFrame.isDrawNeatLine();
    }

    public void setDrawNeatLine(boolean istrue) {
        this._mapFrame.setDrawNeatLine(istrue);
    }

    public Color getNeatLineColor() {
        return this._mapFrame.getNeatLineColor();
    }

    public void setNeatLineColor(Color color) {
        this._mapFrame.setNeatLineColor(color);
    }

    public float getNeatLineSize() {
        return this._mapFrame.getNeatLineSize();
    }

    public void setNeatLineSize(float size) {
        this._mapFrame.setNeatLineSize(size);
    }

    public Color getGridLineColor() {
        return this._mapFrame.getGridLineColor();
    }

    public void setGridLineColor(Color color) {
        this._mapFrame.setGridLineColor(color);
    }

    public float getGridLineSize() {
        return this._mapFrame.getGridLineSize();
    }

    public void setGridLineSize(float size) {
        this._mapFrame.setGridLineSize(size);
    }

    public LineStyles getGridLineStyle() {
        return this._mapFrame.getGridLineStyle();
    }

    public void setGridLineStyle(LineStyles style) {
        this._mapFrame.setGridLineStyle(style);
    }

    public boolean isDrawGridLabel() {
        return this._mapFrame.isDrawGridLabel();
    }

    public void setDrawGridLabel(boolean istrue) {
        this._mapFrame.setDrawGridLabel(istrue);
    }

    public boolean isInsideTickLine() {
        return this._mapFrame.isInsideTickLine();
    }

    public void setInsideTickLine(boolean istrue) {
        this._mapFrame.setInsideTickLine(istrue);
    }

    public int getTickLineLength() {
        return this._mapFrame.getTickLineLength();
    }

    public void setTickLineLength(int value) {
        this._mapFrame.setTickLineLength(value);
    }

    public int getGridLabelShift() {
        return this._mapFrame.getGridLabelShift();
    }

    public void setGridLabelShift(int value) {
        this._mapFrame.setGridLabelShift(value);
    }

    public GridLabelPosition getGridLabelPosition() {
        return this._mapFrame.getGridLabelPosition();
    }

    public void setGridLabelPosition(GridLabelPosition value) {
        this._mapFrame.setGridLabelPosition(value);
    }

    public boolean isDrawGridLine() {
        return this._mapFrame.isDrawGridLine();
    }

    public void setDrawGridLine(boolean istrue) {
        this._mapFrame.setDrawGridLine(istrue);
    }

    public boolean isDrawGridTickLine() {
        return this._mapFrame.isDrawGridTickLine();
    }

    public void setDrawGridTickLine(boolean istrue) {
        this._mapFrame.setDrawGridTickLine(istrue);
    }

    public boolean isDrawDegreeSymbol() {
        return this._drawDegreeSymbol;
    }

    public void setDrawDegreeSymbol(boolean value) {
        this._drawDegreeSymbol = value;
    }

    public Font getGridFont() {
        return this._mapFrame.getGridFont();
    }

    public void setGridFont(Font font) {
        this._mapFrame.setGridFont(font);
    }

    public double getGridXDelt() {
        return this._mapFrame.getGridXDelt();
    }

    public void setGridXDelt(double value) {
        this._mapFrame.setGridXDelt(value);
    }

    public double getGridYDelt() {
        return this._mapFrame.getGridYDelt();
    }

    public void setGridYDelt(double value) {
        this._mapFrame.setGridYDelt(value);
    }

    public float getGridXOrigin() {
        return this._mapFrame.getGridXOrigin();
    }

    public void setGridXOrigin(float value) {
        this._mapFrame.setGridXOrigin(value);
    }

    public float getGridYOrigin() {
        return this._mapFrame.getGridYOrigin();
    }

    public void setGridYOrigin(float value) {
        this._mapFrame.setGridYOrigin(value);
    }

    public void zoomToExtentLonLatEx(Extent aExtent) {
        if (!this._mapFrame.getMapView().getProjection().isLonLatMap()) {
            aExtent = this._mapFrame.getMapView().getProjection().getProjectedExtentFromLonLat(aExtent);
        }
        this.setSizeByExtent(aExtent);
        this._mapFrame.getMapView().setViewExtent(aExtent);
    }

    private void setSizeByExtent(Extent aExtent) {
        double scaleX = (double)this.getWidth() / (aExtent.maxX - aExtent.minX);
        double scaleY = (double)this.getHeight() / (aExtent.maxY - aExtent.minY);
        double scaleFactor = this._mapFrame.getMapView().getProjection().isLonLatMap() ? this._mapFrame.getMapView().getXYScaleFactor() : 1.0;
        if (scaleX > scaleY) {
            scaleX = scaleY / scaleFactor;
            this.setWidth((int)((aExtent.maxX - aExtent.minX) * scaleX));
        } else {
            scaleY = scaleX * scaleFactor;
            this.setHeight((int)((aExtent.maxY - aExtent.minY) * scaleY));
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (this._mapFrame != null) {
            g.setColor(this._mapFrame.getMapView().getBackground());
            g.fill(this._mapFrame.getLayoutBounds());
            this._mapFrame.getMapView().paintGraphics(g, this._mapFrame.getLayoutBounds(), this.tileLoadListener);
            if (this._mapFrame.isDrawNeatLine()) {
                g.setColor(this._mapFrame.getNeatLineColor());
                g.setStroke(new BasicStroke(this._mapFrame.getNeatLineSize()));
                g.draw(this._mapFrame.getLayoutBounds());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paintOnLayout(Graphics2D g, PointF pageLocation, float zoom) {
        block37: {
            block38: {
                if (this._mapFrame == null) break block37;
                aP = this.pageToScreen(this.getLeft(), this.getTop(), pageLocation, zoom);
                rect = new Rectangle((int)aP.X, (int)aP.Y, (int)((float)this.getWidth() * zoom), (int)((float)this.getHeight() * zoom));
                this._mapFrame.getMapView().paintGraphics(g, rect, this.tileLoadListener);
                if (!this._mapFrame.isDrawGridLabel()) break block38;
                extentList = new ArrayList<Extent>();
                maxExtent = new Extent();
                g.setColor(this._mapFrame.getGridLineColor());
                g.setStroke(new BasicStroke(this._mapFrame.getGridLineSize()));
                sP = new PointF(0.0f, 0.0f);
                eP = new PointF(0.0f, 0.0f);
                font = new Font(this._mapFrame.getGridFont().getFontName(), this._mapFrame.getGridFont().getStyle(), (int)((float)this._mapFrame.getGridFont().getSize() * zoom));
                g.setFont(font);
                len = this._mapFrame.getTickLineLength();
                space = len + this._mapFrame.getGridLabelShift();
                if (this._mapFrame.isInsideTickLine()) {
                    space = this._mapFrame.getGridLabelShift();
                }
                block24: for (i = 0; i < this._mapFrame.getMapView().getGridLabels().size(); ++i) {
                    aGL = this._mapFrame.getMapView().getGridLabels().get(i);
                    switch (3.$SwitchMap$org$meteoinfo$legend$GridLabelPosition[this._mapFrame.getGridLabelPosition().ordinal()]) {
                        case 1: {
                            switch (3.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                                case 1: 
                                case 2: {
                                    continue block24;
                                }
                            }
                            ** GOTO lbl40
                        }
                        case 2: {
                            switch (3.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                                case 1: 
                                case 3: {
                                    continue block24;
                                }
                            }
                            ** GOTO lbl40
                        }
                        case 3: {
                            switch (3.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                                case 2: 
                                case 4: {
                                    continue block24;
                                }
                            }
                            ** GOTO lbl40
                        }
                        case 4: {
                            switch (3.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                                case 3: 
                                case 4: {
                                    continue block24;
                                }
                            }
                        }
lbl40:
                        // 5 sources

                        default: {
                            labX = (float)aGL.getLabPoint().X;
                            labY = (float)aGL.getLabPoint().Y;
                            labX = labX + (float)this.getLeft() * zoom + pageLocation.X;
                            labY = labY + (float)this.getTop() * zoom + pageLocation.Y;
                            sP.X = labX;
                            sP.Y = labY;
                            drawStr = aGL.getLabString();
                            if (this._drawDegreeSymbol) {
                                drawStr = drawStr.endsWith("E") != false || drawStr.endsWith("W") != false || drawStr.endsWith("N") != false || drawStr.endsWith("S") != false ? drawStr.substring(0, drawStr.length() - 1) + String.valueOf('\u00ba') + drawStr.substring(drawStr.length() - 1) : drawStr + String.valueOf('\u00ba');
                            }
                            metrics = g.getFontMetrics(font);
                            aSF = new Dimension(metrics.stringWidth(drawStr), metrics.getHeight());
                            switch (3.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                                case 3: {
                                    labX -= (float)(aSF.width / 2);
                                    labY = labY + (float)(aSF.height * 3 / 4) + (float)space;
                                    eP.X = sP.X;
                                    if (this._mapFrame.isInsideTickLine()) {
                                        eP.Y = sP.Y - (float)len;
                                        break;
                                    }
                                    eP.Y = sP.Y + (float)len;
                                    break;
                                }
                                case 4: {
                                    labX = labX - (float)aSF.width - (float)space;
                                    labY += (float)(aSF.height / 3);
                                    eP.Y = sP.Y;
                                    if (this._mapFrame.isInsideTickLine()) {
                                        eP.X = sP.X + (float)len;
                                        break;
                                    }
                                    eP.X = sP.X - (float)len;
                                    break;
                                }
                                case 2: {
                                    labX -= (float)(aSF.width / 2);
                                    labY -= (float)space;
                                    eP.X = sP.X;
                                    if (this._mapFrame.isInsideTickLine()) {
                                        eP.Y = sP.Y + (float)len;
                                        break;
                                    }
                                    eP.Y = sP.Y - (float)len;
                                    break;
                                }
                                case 1: {
                                    labX += (float)space;
                                    labY += (float)(aSF.height / 3);
                                    eP.Y = sP.Y;
                                    eP.X = this._mapFrame.isInsideTickLine() != false ? sP.X - (float)len : sP.X + (float)len;
                                }
                            }
                            ifDraw = true;
                            aSize = aSF.width / 2;
                            bSize = aSF.height / 2;
                            aExtent = new Extent();
                            aExtent.minX = labX;
                            aExtent.maxX = labX + (float)aSF.width;
                            aExtent.minY = labY - (float)aSF.height;
                            aExtent.maxY = labY;
                            if (extentList.isEmpty()) {
                                maxExtent = (Extent)aExtent.clone();
                                extentList.add((Extent)aExtent.clone());
                            } else if (!MIMath.isExtentCross(aExtent, maxExtent).booleanValue()) {
                                extentList.add((Extent)aExtent.clone());
                                maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                            } else {
                                for (j = 0; j < extentList.size(); ++j) {
                                    if (!MIMath.isExtentCross(aExtent, (Extent)extentList.get(j)).booleanValue()) continue;
                                    ifDraw = false;
                                    break;
                                }
                                if (ifDraw) {
                                    extentList.add(aExtent);
                                    maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                                }
                            }
                            if (!ifDraw) continue block24;
                            g.setColor(this._mapFrame.getGridLineColor());
                            g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                            g.setColor(this.getForeColor());
                            g.drawString(drawStr, labX, labY);
                        }
                    }
                }
            }
            if (this._mapFrame.isDrawNeatLine()) {
                g.setColor(this._mapFrame.getNeatLineColor());
                g.setStroke(new BasicStroke(this._mapFrame.getNeatLineSize()));
                g.draw(rect);
            }
        }
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }

    public static class LineStyleEditor
    extends ComboBoxPropertyEditor {
        public LineStyleEditor() {
            LineStyles[] lutypes = LineStyles.values();
            Object[] types = new String[lutypes.length];
            int i = 0;
            for (LineStyles type : lutypes) {
                types[i] = type.toString();
                ++i;
            }
            this.setAvailableValues(types);
        }
    }

    public static class GridLabelPositionEditor
    extends ComboBoxPropertyEditor {
        public GridLabelPositionEditor() {
            GridLabelPosition[] lutypes = GridLabelPosition.values();
            Object[] types = new String[lutypes.length];
            int i = 0;
            for (GridLabelPosition type : lutypes) {
                types[i] = type.toString();
                ++i;
            }
            this.setAvailableValues(types);
        }
    }

    public static class LayoutMapBeanBeanInfo
    extends BaseBeanInfo {
        public LayoutMapBeanBeanInfo() {
            super(LayoutMapBean.class);
            this.addProperty("drawBackColor").setCategory("General").setDisplayName("Draw Background");
            this.addProperty("backColor").setCategory("General").setDisplayName("Background");
            this.addProperty("foreColor").setCategory("General").setDisplayName("Foreground");
            this.addProperty("drawNeatLine").setCategory("Neat Line").setDisplayName("Draw Neat Line");
            this.addProperty("neatLineColor").setCategory("Neat Line").setDisplayName("Neat Line Color");
            this.addProperty("neatLineSize").setCategory("Neat Line").setDisplayName("Neat Line Size");
            this.addProperty("drawGridLine").setCategory("Grid Line").setDisplayName("Draw Grid Line");
            this.addProperty("drawGridLabel").setCategory("Grid Line").setDisplayName("Draw Grid Label");
            this.addProperty("gridXDelt").setCategory("Grid Line").setDisplayName("Grid X Interval");
            this.addProperty("gridYDelt").setCategory("Grid Line").setDisplayName("Grid Y Interval");
            this.addProperty("gridXOrigin").setCategory("Grid Line").setDisplayName("Grid X Origin");
            this.addProperty("gridYOrigin").setCategory("Grid Line").setDisplayName("Grid Y Origin");
            this.addProperty("gridFont").setCategory("Grid Line").setDisplayName("Grid Label Font");
            this.addProperty("gridLabelShift").setCategory("Grid Line").setDisplayName("Grid Label Shift");
            ExtendedPropertyDescriptor e = this.addProperty("gridLabelPosition");
            e.setCategory("Grid Line").setDisplayName("Grid Label Position");
            e.setPropertyEditorClass(GridLabelPositionEditor.class);
            this.addProperty("drawDegreeSymbol").setCategory("Grid Line").setDisplayName("Draw Degree Symbol");
            this.addProperty("gridLineColor").setCategory("Grid Line").setDisplayName("Grid Line Color");
            this.addProperty("gridLineSize").setCategory("Grid Line").setDisplayName("Grid Line Size");
            e = this.addProperty("gridLineStyle");
            e.setCategory("Grid Line").setDisplayName("Grid Line Style");
            e.setPropertyEditorClass(LineStyleEditor.class);
            this.addProperty("insideTickLine").setCategory("Grid Line").setDisplayName("Inside Tick Line");
            this.addProperty("tickLineLength").setCategory("Grid Line").setDisplayName("Tick Line Length");
            this.addProperty("left").setCategory("Location").setDisplayName("Left");
            this.addProperty("top").setCategory("Location").setDisplayName("Top");
            this.addProperty("width").setCategory("Location").setDisplayName("Width");
            this.addProperty("height").setCategory("Location").setDisplayName("Height");
        }
    }

    public class LayoutMapBean {
        LayoutMapBean() {
        }

        public int getLeft() {
            return ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().x;
        }

        public void setLeft(int left) {
            LayoutMap.this._mapFrame.setLayoutBounds(new Rectangle(left, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().y, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().width, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().height));
        }

        public int getTop() {
            return ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().y;
        }

        public void setTop(int top) {
            LayoutMap.this._mapFrame.setLayoutBounds(new Rectangle(((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().x, top, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().width, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().height));
        }

        public int getWidth() {
            return ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().width;
        }

        public void setWidth(int width) {
            LayoutMap.this._mapFrame.setLayoutBounds(new Rectangle(((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().x, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().y, width, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().height));
        }

        public int getHeight() {
            return ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().height;
        }

        public void setHeight(int height) {
            LayoutMap.this._mapFrame.setLayoutBounds(new Rectangle(((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().x, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().y, ((LayoutMap)LayoutMap.this)._mapFrame.getLayoutBounds().width, height));
        }

        public Rectangle getBounds() {
            return LayoutMap.this._mapFrame.getLayoutBounds();
        }

        public void setBounds(Rectangle rect) {
            LayoutMap.this._mapFrame.setLayoutBounds(rect);
        }

        public boolean isDrawBackColor() {
            return LayoutMap.this.isDrawBackColor();
        }

        public void setDrawBackColor(boolean value) {
            LayoutMap.this.setDrawBackColor(value);
        }

        public Color getBackColor() {
            return LayoutMap.this._mapFrame.getBackColor();
        }

        public void setBackColor(Color color) {
            LayoutMap.this._mapFrame.setBackColor(color);
        }

        public Color getForeColor() {
            return LayoutMap.this._mapFrame.getForeColor();
        }

        public void setForeColor(Color color) {
            LayoutMap.this._mapFrame.setForeColor(color);
        }

        public boolean isDrawNeatLine() {
            return LayoutMap.this._mapFrame.isDrawNeatLine();
        }

        public void setDrawNeatLine(boolean istrue) {
            LayoutMap.this._mapFrame.setDrawNeatLine(istrue);
        }

        public Color getNeatLineColor() {
            return LayoutMap.this._mapFrame.getNeatLineColor();
        }

        public void setNeatLineColor(Color color) {
            LayoutMap.this._mapFrame.setNeatLineColor(color);
        }

        public float getNeatLineSize() {
            return LayoutMap.this._mapFrame.getNeatLineSize();
        }

        public void setNeatLineSize(float size) {
            LayoutMap.this._mapFrame.setNeatLineSize(size);
        }

        public Color getGridLineColor() {
            return LayoutMap.this._mapFrame.getGridLineColor();
        }

        public void setGridLineColor(Color color) {
            LayoutMap.this._mapFrame.setGridLineColor(color);
        }

        public float getGridLineSize() {
            return LayoutMap.this._mapFrame.getGridLineSize();
        }

        public void setGridLineSize(float size) {
            LayoutMap.this._mapFrame.setGridLineSize(size);
        }

        public String getGridLineStyle() {
            return LayoutMap.this._mapFrame.getGridLineStyle().toString();
        }

        public void setGridLineStyle(String style) {
            LayoutMap.this._mapFrame.setGridLineStyle(LineStyles.valueOf(style));
        }

        public boolean isDrawGridLabel() {
            return LayoutMap.this._mapFrame.isDrawGridLabel();
        }

        public void setDrawGridLabel(boolean istrue) {
            LayoutMap.this._mapFrame.setDrawGridLabel(istrue);
        }

        public boolean isInsideTickLine() {
            return LayoutMap.this._mapFrame.isInsideTickLine();
        }

        public void setInsideTickLine(boolean istrue) {
            LayoutMap.this._mapFrame.setInsideTickLine(istrue);
        }

        public int getTickLineLength() {
            return LayoutMap.this._mapFrame.getTickLineLength();
        }

        public void setTickLineLength(int value) {
            LayoutMap.this._mapFrame.setTickLineLength(value);
        }

        public int getGridLabelShift() {
            return LayoutMap.this._mapFrame.getGridLabelShift();
        }

        public void setGridLabelShift(int value) {
            LayoutMap.this._mapFrame.setGridLabelShift(value);
        }

        public String getGridLabelPosition() {
            return LayoutMap.this._mapFrame.getGridLabelPosition().toString();
        }

        public void setGridLabelPosition(String value) {
            LayoutMap.this._mapFrame.setGridLabelPosition(GridLabelPosition.valueOf(value));
        }

        public boolean isDrawGridLine() {
            return LayoutMap.this._mapFrame.isDrawGridLine();
        }

        public void setDrawGridLine(boolean istrue) {
            LayoutMap.this._mapFrame.setDrawGridLine(istrue);
        }

        public boolean isDrawGridTickLine() {
            return LayoutMap.this._mapFrame.isDrawGridTickLine();
        }

        public void setDrawGridTickLine(boolean istrue) {
            LayoutMap.this._mapFrame.setDrawGridTickLine(istrue);
        }

        public boolean isDrawDegreeSymbol() {
            return LayoutMap.this._drawDegreeSymbol;
        }

        public void setDrawDegreeSymbol(boolean value) {
            LayoutMap.this._drawDegreeSymbol = value;
        }

        public Font getGridFont() {
            return LayoutMap.this._mapFrame.getGridFont();
        }

        public void setGridFont(Font font) {
            LayoutMap.this._mapFrame.setGridFont(font);
        }

        public double getGridXDelt() {
            return LayoutMap.this._mapFrame.getGridXDelt();
        }

        public void setGridXDelt(double value) {
            LayoutMap.this._mapFrame.setGridXDelt(value);
        }

        public double getGridYDelt() {
            return LayoutMap.this._mapFrame.getGridYDelt();
        }

        public void setGridYDelt(double value) {
            LayoutMap.this._mapFrame.setGridYDelt(value);
        }

        public float getGridXOrigin() {
            return LayoutMap.this._mapFrame.getGridXOrigin();
        }

        public void setGridXOrigin(float value) {
            LayoutMap.this._mapFrame.setGridXOrigin(value);
        }

        public float getGridYOrigin() {
            return LayoutMap.this._mapFrame.getGridYOrigin();
        }

        public void setGridYOrigin(float value) {
            LayoutMap.this._mapFrame.setGridYOrigin(value);
        }
    }
}

