/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.meteoinfo.layer.FrmLabelSet;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.layout.MouseMode;
import org.meteoinfo.legend.LayersLegend;
import org.meteoinfo.map.MapView;
import org.meteoinfo.map.MouseTools;

public class MainToolBar
extends JToolBar {
    MapView mapView;
    MapLayout mapLayout;
    JButton jButton_Select;
    JButton jButton_ZoomIn;
    JButton jButton_ZoomOut;
    JButton jButton_Pan;
    JButton jButton_FullExtent;
    JButton jButton_ZoomToLayer;
    JButton jButton_Identifer;
    JButton jButton_Label;
    JLabel jLabel_Status;
    JButton currentTool;

    public MainToolBar(LayersLegend toc, JLabel jLabel_Status) {
        this(toc.getActiveMapFrame().getMapView(), toc.getMapLayout(), jLabel_Status);
    }

    public MainToolBar(MapView mapView, MapLayout mapLayout, JLabel jLabel_Status) {
        this.mapView = mapView;
        this.mapLayout = mapLayout;
        this.jLabel_Status = jLabel_Status;
        this.jButton_Select = new JButton();
        this.jButton_Select.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_None.Image.png")));
        this.jButton_Select.setToolTipText("Select");
        this.jButton_Select.setFocusable(false);
        this.jButton_Select.setHorizontalTextPosition(0);
        this.jButton_Select.setVerticalTextPosition(3);
        this.jButton_Select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_SelectActionPerformed(evt);
            }
        });
        this.add(this.jButton_Select);
        this.jButton_ZoomIn = new JButton();
        this.jButton_ZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_ZoomIn.Image.png")));
        this.jButton_ZoomIn.setToolTipText("Zoom In");
        this.jButton_ZoomIn.setFocusable(false);
        this.jButton_ZoomIn.setHorizontalTextPosition(0);
        this.jButton_ZoomIn.setVerticalTextPosition(3);
        this.jButton_ZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_ZoomInActionPerformed(evt);
            }
        });
        this.add(this.jButton_ZoomIn);
        this.jButton_ZoomOut = new JButton();
        this.jButton_ZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_ZoomOut.Image.png")));
        this.jButton_ZoomOut.setToolTipText("Zoom Out");
        this.jButton_ZoomOut.setFocusable(false);
        this.jButton_ZoomOut.setHorizontalTextPosition(0);
        this.jButton_ZoomOut.setVerticalTextPosition(3);
        this.jButton_ZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_ZoomOutActionPerformed(evt);
            }
        });
        this.add(this.jButton_ZoomOut);
        this.jButton_Pan = new JButton();
        this.jButton_Pan.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Pan.Image.png")));
        this.jButton_Pan.setToolTipText("Pan");
        this.jButton_Pan.setFocusable(false);
        this.jButton_Pan.setHorizontalTextPosition(0);
        this.jButton_Pan.setVerticalTextPosition(3);
        this.jButton_Pan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_PanActionPerformed(evt);
            }
        });
        this.add(this.jButton_Pan);
        this.jButton_FullExtent = new JButton();
        this.jButton_FullExtent.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_FullExent.Image.png")));
        this.jButton_FullExtent.setToolTipText("Full Extent");
        this.jButton_FullExtent.setFocusable(false);
        this.jButton_FullExtent.setHorizontalTextPosition(0);
        this.jButton_FullExtent.setVerticalTextPosition(3);
        this.jButton_FullExtent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_FullExtentActionPerformed(evt);
            }
        });
        this.add(this.jButton_FullExtent);
        this.jButton_ZoomToLayer = new JButton();
        this.jButton_ZoomToLayer.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_ZoomToLayer.Image.png")));
        this.jButton_ZoomToLayer.setToolTipText("Zoom to Layer");
        this.jButton_ZoomToLayer.setFocusable(false);
        this.jButton_ZoomToLayer.setHorizontalTextPosition(0);
        this.jButton_ZoomToLayer.setVerticalTextPosition(3);
        this.jButton_ZoomToLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_ZoomToLayerActionPerformed(evt);
            }
        });
        this.add(this.jButton_ZoomToLayer);
        this.jButton_Identifer = new JButton();
        this.jButton_Identifer.setIcon(new ImageIcon(this.getClass().getResource("/images/information.png")));
        this.jButton_Identifer.setToolTipText("Identifer");
        this.jButton_Identifer.setFocusable(false);
        this.jButton_Identifer.setHorizontalTextPosition(0);
        this.jButton_Identifer.setVerticalTextPosition(3);
        this.jButton_Identifer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_IdentiferActionPerformed(evt);
            }
        });
        this.add(this.jButton_Identifer);
        this.add(new JToolBar.Separator());
        this.jButton_Label = new JButton();
        this.jButton_Label.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_LabelSet.Image.png")));
        this.jButton_Label.setToolTipText("Label");
        this.jButton_Label.setFocusable(false);
        this.jButton_Label.setHorizontalTextPosition(0);
        this.jButton_Label.setVerticalTextPosition(3);
        this.jButton_Label.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainToolBar.this.jButton_LabelActionPerformed(evt);
            }
        });
        this.add(this.jButton_Label);
    }

    private void jButton_SelectActionPerformed(ActionEvent evt) {
        this.mapView.setMouseTool(MouseTools.SelectElements);
        if (this.mapLayout != null) {
            this.mapLayout.setMouseMode(MouseMode.Select);
        }
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_ZoomInActionPerformed(ActionEvent evt) {
        this.mapView.setMouseTool(MouseTools.Zoom_In);
        if (this.mapLayout != null) {
            this.mapLayout.setMouseMode(MouseMode.Map_ZoomIn);
        }
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_ZoomOutActionPerformed(ActionEvent evt) {
        this.mapView.setMouseTool(MouseTools.Zoom_Out);
        if (this.mapLayout != null) {
            this.mapLayout.setMouseMode(MouseMode.Map_ZoomOut);
        }
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_PanActionPerformed(ActionEvent evt) {
        this.mapView.setMouseTool(MouseTools.Pan);
        if (this.mapLayout != null) {
            this.mapLayout.setMouseMode(MouseMode.Map_Pan);
        }
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_FullExtentActionPerformed(ActionEvent evt) {
        this.mapView.zoomToExtent(this.mapView.getExtent());
    }

    private void jButton_ZoomToLayerActionPerformed(ActionEvent evt) {
        MapLayer layer = this.mapView.getSelectedLayer();
        if (layer != null) {
            this.mapView.zoomToExtent(layer.getExtent());
        }
    }

    private void jButton_IdentiferActionPerformed(ActionEvent evt) {
        this.mapView.setMouseTool(MouseTools.Identifer);
        if (this.mapLayout != null) {
            this.mapLayout.setMouseMode(MouseMode.Map_Identifer);
        }
        this.setCurrentTool((JButton)evt.getSource());
    }

    private void jButton_LabelActionPerformed(ActionEvent evt) {
        VectorLayer aLayer;
        MapLayer aMLayer = this.mapView.getSelectedLayer();
        if (aMLayer.getLayerType() == LayerTypes.VectorLayer && (aLayer = (VectorLayer)aMLayer).getShapeNum() > 0) {
            FrmLabelSet aFrmLabel = new FrmLabelSet(null, false, this.mapView);
            aFrmLabel.setLayer(aLayer);
            aFrmLabel.setVisible(true);
        }
    }

    private void setCurrentTool(JButton currentTool) {
        if (this.currentTool != null) {
            this.currentTool.setSelected(false);
        }
        this.currentTool = currentTool;
        this.currentTool.setSelected(true);
        if (this.jLabel_Status != null) {
            this.jLabel_Status.setText(currentTool.getToolTipText());
        }
    }
}

