/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.meteoinfo.global.util.TypeUtils;
import ucar.ma2.DataType;

public class DataConvert {
    public static float bytes2Float(byte[] b, ByteOrder byteOrder) {
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.order(byteOrder);
        return buf.getFloat();
    }

    public static double bytes2Double(byte[] b, ByteOrder byteOrder) {
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.order(byteOrder);
        return buf.getDouble();
    }

    public static int bytes2Int(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(byteOrder);
        if (bytes.length == 4) {
            return buf.getInt();
        }
        return buf.getShort();
    }

    public static short bytes2Short(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(byteOrder);
        return buf.getShort();
    }

    public static int bytes2Int(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    public static int bytes2Int3(byte[] bytes) {
        int val = 0;
        for (int bb = 0; bb < 3; ++bb) {
            val <<= 8;
            val |= bytes[bb] & 0xFF;
        }
        return val;
    }

    public static int byte2Int(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static byte[] littleToBig(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        byte[] temp = new byte[bytes.length];
        for (int i = bytes.length - 1; i >= 0; --i) {
            temp[i] = bytes[bytes.length - 1 - i];
        }
        return temp;
    }

    public static byte[] bigToLittle(byte[] bytes) {
        return DataConvert.littleToBig(bytes);
    }

    public static byte[] toBytes(int i) {
        byte[] bytes = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return bytes;
    }

    public static byte[] toUint3Int(int i) {
        byte[] ints = new byte[]{(byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return ints;
    }

    public static byte[] toUint2Int(int i) {
        byte[] ints = new byte[]{(byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return ints;
    }

    public static byte[] toUintNInt(int i, int n) {
        byte[] ints = new byte[]{(byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return ints;
    }

    public static byte[] toLittleBytes(int i) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(i >> 24 & 0xFF);
        bytes[2] = (byte)(i >> 16 & 0xFF);
        bytes[1] = (byte)(i >> 8 & 0xFF);
        bytes[0] = (byte)(i & 0xFF);
        return bytes;
    }

    public static byte[] toBytes(float f) {
        return DataConvert.toBytes(Float.floatToIntBits(f));
    }

    public static byte[] float2Bytes(float f, ByteOrder byteOrder) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(byteOrder);
        buf.putFloat(f);
        return buf.array();
    }

    public static byte[] toLittleBytes(float f) {
        return DataConvert.toLittleBytes(Float.floatToIntBits(f));
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static double[][] resizeArray2D(double[][] oldArray, int newSize) {
        int ynum = oldArray.length;
        int xnum = oldArray[0].length;
        double[][] newArray = new double[newSize][xnum];
        for (int j = 0; j < ynum; ++j) {
            for (int i = 0; i < xnum; ++i) {
                newArray[j][i] = oldArray[j][i];
            }
        }
        return newArray;
    }

    public static String doubleToString(double v) {
        BigDecimal a = new BigDecimal(Double.toString(v));
        a = a.setScale(12, 4);
        return a.stripTrailingZeros().toPlainString();
    }

    public static String removeTailingZeros(String s) {
        if (s.equals("0.0")) {
            s = "0";
        }
        if (s.length() <= 1) {
            return s;
        }
        if (s.substring(s.length() - 2).equals(".0")) {
            return new BigDecimal(s).stripTrailingZeros().toPlainString();
        }
        return s;
    }

    public static String removeTail0(String str) {
        if (!str.substring(str.length() - 1).equals("0")) {
            return str;
        }
        return DataConvert.removeTail0(str.substring(0, str.length() - 1));
    }

    public static byte[] toByte_bak1(BitSet bits) {
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static byte[] toByteArray(BitSet bits) {
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static byte[] toByteArray_bak(BitSet bitSet) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bitSet.size());
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(bitSet);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static Object convertTo(Object value, DataType dataType, String dateFormat) {
        if (value == null) {
            switch (dataType) {
                case INT: {
                    return Integer.MIN_VALUE;
                }
                case FLOAT: {
                    return Float.valueOf(Float.NaN);
                }
                case DOUBLE: {
                    return Double.NaN;
                }
                case BOOLEAN: {
                    return false;
                }
                case STRING: {
                    return "";
                }
            }
            return value;
        }
        switch (dataType) {
            case INT: {
                if (value instanceof Integer) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return Integer.MIN_VALUE;
                }
                return Integer.valueOf(vStr);
            }
            case DOUBLE: {
                if (value instanceof Double) break;
                String vStr = value.toString();
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Double.NaN;
                }
                return Double.valueOf(vStr);
            }
            case FLOAT: {
                if (value instanceof Float) break;
                String vStr = value.toString();
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Float.valueOf(Float.NaN);
                }
                try {
                    float v = Float.valueOf(vStr).floatValue();
                    return Float.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return Float.valueOf(Float.NaN);
                }
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return false;
                }
                return Boolean.valueOf(vStr);
            }
            case OBJECT: {
                if (value instanceof Date) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return null;
                }
                SimpleDateFormat dformat = new SimpleDateFormat(dateFormat);
                try {
                    return dformat.parse(vStr);
                }
                catch (ParseException ex) {
                    Logger.getLogger(DataConvert.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return value;
    }

    public static Object convertStringTo(String vStr, DataType dataType, String dateFormat) {
        if (vStr == null) {
            switch (dataType) {
                case INT: {
                    return Integer.MIN_VALUE;
                }
                case FLOAT: {
                    return Float.valueOf(Float.NaN);
                }
                case DOUBLE: {
                    return Double.NaN;
                }
                case BOOLEAN: {
                    return false;
                }
                case STRING: {
                    return "";
                }
            }
            return vStr;
        }
        switch (dataType) {
            case INT: {
                if (vStr.isEmpty()) {
                    return Integer.MIN_VALUE;
                }
                try {
                    int v = Integer.valueOf(vStr);
                    return v;
                }
                catch (NumberFormatException e) {
                    return Integer.MIN_VALUE;
                }
            }
            case DOUBLE: {
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Double.NaN;
                }
                try {
                    double v = Double.valueOf(vStr);
                    return v;
                }
                catch (NumberFormatException e) {
                    return Double.NaN;
                }
            }
            case FLOAT: {
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Float.valueOf(Float.NaN);
                }
                try {
                    float v = Float.valueOf(vStr).floatValue();
                    return Float.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return Float.valueOf(Float.NaN);
                }
            }
            case BOOLEAN: {
                if (vStr.isEmpty()) {
                    return false;
                }
                return Boolean.valueOf(vStr);
            }
            case OBJECT: {
                if (vStr.isEmpty()) {
                    return null;
                }
                SimpleDateFormat dformat = new SimpleDateFormat(dateFormat);
                try {
                    return dformat.parse(vStr);
                }
                catch (ParseException ex) {
                    Logger.getLogger(DataConvert.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
        }
        return vStr;
    }

    public static DataType getDataType(String format) {
        DataType dt = DataType.STRING;
        switch (format) {
            case "C": 
            case "s": {
                dt = DataType.STRING;
                break;
            }
            case "i": {
                dt = DataType.INT;
                break;
            }
            case "f": {
                dt = DataType.FLOAT;
                break;
            }
            case "d": {
                dt = DataType.DOUBLE;
                break;
            }
            case "B": {
                dt = DataType.BOOLEAN;
                break;
            }
            default: {
                if (!format.substring(0, 1).equals("{")) break;
                int eidx = format.indexOf("}");
                String formatStr = format.substring(1, eidx);
                dt = DataType.OBJECT;
            }
        }
        return dt;
    }

    public static String getDateFormat(String format) {
        int eidx = format.indexOf("}");
        String formatStr = format.substring(1, eidx);
        return formatStr;
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isFloat(String s) {
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isBoolean(String s) {
        return TypeUtils.TRUE_STRINGS_FOR_DETECTION.contains(s) || TypeUtils.FALSE_STRINGS_FOR_DETECTION.contains(s);
    }

    public static boolean isLocalDate(String s, DateTimeFormatter dateTimeFormatter) {
        try {
            if (dateTimeFormatter == null) {
                LocalDate.parse((String)s, (DateTimeFormatter)TypeUtils.DATE_FORMATTER);
                return true;
            }
            LocalDate.parse((String)s, (DateTimeFormatter)dateTimeFormatter);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLocalTime(String s, DateTimeFormatter formatter) {
        try {
            if (formatter == null) {
                LocalTime.parse((String)s, (DateTimeFormatter)TypeUtils.TIME_DETECTION_FORMATTER);
                return true;
            }
            LocalDate.parse((String)s, (DateTimeFormatter)formatter);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLocalDateTime(String s, DateTimeFormatter formatter) {
        try {
            if (formatter == null) {
                LocalDateTime.parse((String)s, (DateTimeFormatter)TypeUtils.DATE_TIME_FORMATTER);
                return true;
            }
            LocalDate.parse((String)s, (DateTimeFormatter)formatter);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static DataType detectDataType(List<String> valuesList, DateTimeFormatter dtFormatter) {
        LinkedList<DataType> dts = new LinkedList<DataType>(Arrays.asList(DataType.OBJECT, DataType.BOOLEAN, DataType.INT, DataType.FLOAT, DataType.DOUBLE, DataType.STRING));
        if (dtFormatter == null) {
            dts.remove(DataType.OBJECT);
        }
        for (String s : valuesList) {
            if (dts.contains(DataType.OBJECT) && dtFormatter != null && !DataConvert.isLocalDateTime(s, dtFormatter)) {
                dts.remove(DataType.OBJECT);
            }
            if (dts.contains(DataType.BOOLEAN) && !DataConvert.isBoolean(s)) {
                dts.remove(DataType.BOOLEAN);
            }
            if (dts.contains(DataType.INT) && !DataConvert.isInteger(s)) {
                dts.remove(DataType.INT);
            }
            if (dts.contains(DataType.FLOAT) && !DataConvert.isFloat(s)) {
                dts.remove(DataType.FLOAT);
            }
            if (!dts.contains(DataType.DOUBLE) || DataConvert.isDouble(s)) continue;
            dts.remove(DataType.DOUBLE);
        }
        return (DataType)dts.get(0);
    }

    public static DataType detectDataType(List<String> valuesList, int n, DateTimeFormatter dtFormatter) {
        if (n > valuesList.size()) {
            n = valuesList.size();
        }
        List<String> vl = valuesList.subList(0, n);
        return DataConvert.detectDataType(vl, dtFormatter);
    }
}

