/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.Dimension;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.DateUtil;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;

public class MICAPS131DataInfo
extends DataInfo
implements IGridDataInfo {
    private String _description;
    private String zonName;
    private String dataName;
    private String flag;
    private String version;
    private Date time;
    private int xNum;
    private int yNum;
    private int zNum;
    private int radarCount;
    private float startLon;
    private float startLat;
    private float _lon_Center;
    private float _lat_Center;
    private float lonDelta;
    private float latDelta;
    private float[] heights;
    private String[] stationNames;
    private float[] stLons;
    private float[] stLats;
    private float[] stAlts;
    private int dataByteNum;

    public MICAPS131DataInfo() {
        this.setDataType(MeteoDataType.MICAPS_131);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            int i;
            this.setFileName(fileName);
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            byte[] bytes = new byte[1024];
            br.read(bytes);
            int sidx = 0;
            int len = 12;
            byte[] bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
            this.zonName = new String(bb, "GBK").trim();
            this.addAttribute(new Attribute("Zon_Name", this.zonName));
            sidx += len;
            len = 38;
            bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
            this.dataName = new String(bb, "GBK").trim();
            this.addAttribute(new Attribute("Data_Name", this.dataName));
            sidx += len;
            len = 8;
            bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
            this.flag = new String(bb, "GBK").trim();
            this.addAttribute(new Attribute("Flag", this.flag));
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.version = new String(bb, "GBK").trim();
            this.addAttribute(new Attribute("Version", this.version));
            this._description = this.zonName + "; " + this.dataName + "; " + this.flag + "; " + this.version;
            sidx += len;
            len = 2;
            bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
            short year = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            short month = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            short day = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            short hour = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            short minute = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, minute, 0);
            this.time = cal.getTime();
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            short interval = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.xNum = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.yNum = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.zNum = DataConvert.bytes2Short(bb, ByteOrder.LITTLE_ENDIAN);
            this.dataByteNum = this.zNum > 1 ? 1 : (br.length() - 1024L == (long)(this.xNum * this.yNum) ? 1 : 2);
            sidx += len;
            len = 4;
            bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
            this.radarCount = DataConvert.bytes2Int(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.startLon = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.startLat = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this._lon_Center = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this._lat_Center = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.lonDelta = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
            this.latDelta = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            this.heights = new float[40];
            for (i = 0; i < 40; ++i) {
                bb = Arrays.copyOfRange(bytes, sidx += len, sidx + len);
                this.heights[i] = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
            }
            sidx += len;
            len = 16;
            this.stationNames = new String[20];
            for (i = 0; i < 20; ++i) {
                bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
                this.stationNames[i] = new String(bb, "GBK").trim();
                sidx += len;
            }
            len = 4;
            this.stLons = new float[20];
            for (i = 0; i < 20; ++i) {
                bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
                this.stLons[i] = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
                sidx += len;
            }
            this.stLats = new float[20];
            for (i = 0; i < 20; ++i) {
                bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
                this.stLats[i] = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
                sidx += len;
            }
            this.stAlts = new float[20];
            for (i = 0; i < 20; ++i) {
                bb = Arrays.copyOfRange(bytes, sidx, sidx + len);
                this.stAlts[i] = DataConvert.bytes2Float(bb, ByteOrder.LITTLE_ENDIAN);
                sidx += len;
            }
            br.close();
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.addValue(DateUtil.toOADate(this.time));
            this.setTimeDimension(tdim);
            this.addDimension(tdim);
            Dimension zdim = new Dimension(DimensionType.Z);
            double[] zValues = new double[this.zNum];
            for (int i2 = 0; i2 < this.zNum; ++i2) {
                zValues[i2] = this.heights[i2];
            }
            zdim.setValues(zValues);
            this.setZDimension(zdim);
            this.addDimension(zdim);
            Dimension ydim = new Dimension(DimensionType.Y);
            double[] yValues = new double[this.yNum];
            for (int i3 = 0; i3 < this.yNum; ++i3) {
                yValues[i3] = BigDecimalUtil.sub(this.startLat, BigDecimalUtil.mul(this.yNum - i3 - 1, this.latDelta));
            }
            ydim.setValues(yValues);
            this.addDimension(ydim);
            this.setYDimension(ydim);
            Dimension xdim = new Dimension(DimensionType.X);
            double[] xValues = new double[this.xNum];
            for (int i4 = 0; i4 < this.xNum; ++i4) {
                xValues[i4] = BigDecimalUtil.add((double)this.startLon, BigDecimalUtil.mul(i4, this.lonDelta));
            }
            xdim.setValues(xValues);
            this.addDimension(xdim);
            this.setXDimension(xdim);
            Variable var = new Variable();
            var.setName("var");
            var.setDimension(tdim);
            var.setDimension(zdim);
            var.setDimension(ydim);
            var.setDimension(xdim);
            var.addAttribute("data_name", this.dataName);
            this.addVariable(var);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS131DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS131DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            int rangeIdx = 1;
            Range levRange = var.getLevelNum() > 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                this.readXY(levelIdx, yRange, xRange, ii);
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(MICAPS131DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(int levelIdx, Range yRange, Range xRange, IndexIterator ii) {
        try {
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            int n = this.yNum * this.xNum * this.dataByteNum;
            byte[] bytes = new byte[n];
            br.skipBytes(1024);
            br.skipBytes(levelIdx * n);
            br.read(bytes);
            br.close();
            if (this.dataByteNum == 1) {
                for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                    for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                        int index = (this.yNum - y - 1) * this.xNum + x;
                        ii.setFloatNext((float)DataConvert.byte2Int(bytes[index]));
                    }
                }
            } else {
                for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                    for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                        int index = ((this.yNum - y - 1) * this.xNum + x) * 2;
                        ii.setFloatNext((float)DataConvert.bytes2Short(Arrays.copyOfRange(bytes, index, index + 2), ByteOrder.LITTLE_ENDIAN));
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS131DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS131DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        try {
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            int n = this.yNum * this.xNum * this.dataByteNum;
            byte[] bytes = new byte[n];
            br.skipBytes(1024);
            br.skipBytes(levelIdx * n);
            br.read(bytes);
            br.close();
            GridData gridData = new GridData();
            double[][] gData = new double[this.yNum][this.xNum];
            if (this.dataByteNum == 1) {
                for (int i = 0; i < this.yNum; ++i) {
                    for (int j = 0; j < this.xNum; ++j) {
                        gData[i][j] = DataConvert.byte2Int(bytes[(this.yNum - i - 1) * this.xNum + j]);
                    }
                }
            } else {
                for (int i = 0; i < this.yNum; ++i) {
                    for (int j = 0; j < this.xNum; ++j) {
                        int index = ((this.yNum - i - 1) * this.xNum + j) * 2;
                        gData[i][j] = DataConvert.bytes2Short(Arrays.copyOfRange(bytes, index, index + 2), ByteOrder.LITTLE_ENDIAN);
                    }
                }
            }
            gridData.data = gData;
            gridData.xArray = this.getXDimension().getValues();
            gridData.yArray = this.getYDimension().getValues();
            return gridData;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

