/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.global.util.BigDecimalUtil;

public class Dimension
extends ucar.nc2.Dimension {
    private DimensionType _dimType;
    private List<Double> _dimValue = new ArrayList<Double>();
    private int _dimId;
    private boolean reverse = false;

    public Dimension() {
        this("null", 1);
    }

    public Dimension(ucar.nc2.Dimension dim) {
        this(dim, DimensionType.Other);
    }

    public Dimension(ucar.nc2.Dimension dim, DimensionType dimType) {
        this(dim.getShortName(), dim.getLength(), dimType);
        this.setGroup(dim.getGroup());
        this.setDODSName(dim.getDODSName());
        this.setParentStructure(dim.getParentStructure());
        this.setSort(dim.getSort());
        this.setParentGroup(dim.getParentGroup());
        this.setUnlimited(dim.isUnlimited());
        this.setShared(dim.isShared());
        this.setVariableLength(dim.isVariableLength());
    }

    public Dimension(String name, int len) {
        super(name, len);
        this.setShared(true);
        this._dimType = DimensionType.Other;
        this._dimValue = new ArrayList<Double>();
    }

    public Dimension(DimensionType dimType) {
        this(dimType.toString(), 1, dimType);
    }

    public Dimension(String name, int len, DimensionType dimType) {
        super(name, len);
        this.setShared(true);
        this._dimType = dimType;
        this._dimValue = new ArrayList<Double>();
    }

    public Dimension(String name, int len, DimensionType dimType, double min, double delta, int num) {
        super(name, len);
        this.setShared(true);
        this._dimType = dimType;
        this._dimValue = new ArrayList<Double>();
        for (int i = 0; i < num; ++i) {
            this._dimValue.add(min + delta * (double)i);
        }
    }

    public void setDimLength(int value) {
        super.setLength(value);
        this._dimValue.clear();
        for (int i = 0; i < value; ++i) {
            this._dimValue.add(Double.valueOf(i));
        }
    }

    public void setLength(int value) {
        if (value <= 0) {
            return;
        }
        super.setLength(value);
        if (this._dimValue == null) {
            this._dimValue = new ArrayList<Double>();
        }
        if (this._dimValue.size() != value) {
            this._dimValue.clear();
            for (int i = 0; i < value; ++i) {
                this._dimValue.add(Double.valueOf(i));
            }
        }
    }

    public DimensionType getDimType() {
        return this._dimType;
    }

    public void setDimType(DimensionType value) {
        this._dimType = value;
    }

    public List<Double> getDimValue() {
        return this._dimValue;
    }

    public int getDimId() {
        return this._dimId;
    }

    public void setDimId(int value) {
        this._dimId = value;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean value) {
        this.reverse = value;
    }

    public boolean equals(Dimension aDim) {
        if (!this.getShortName().equals(aDim.getShortName())) {
            return false;
        }
        if (this._dimType != aDim.getDimType()) {
            return false;
        }
        return this.getLength() == aDim.getLength();
    }

    public double[] getValues() {
        int len = this.getLength();
        double[] values = new double[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this._dimValue.get(i);
        }
        return values;
    }

    public void setValues(List<Double> values) {
        this._dimValue = values;
        this.setLength(this._dimValue.size());
    }

    public void setDimValues(List<Number> values) {
        this._dimValue = new ArrayList<Double>();
        for (Number v : values) {
            this._dimValue.add(v.doubleValue());
        }
        this.setLength(this._dimValue.size());
    }

    public void setValues(double[] values) {
        this._dimValue = new ArrayList<Double>();
        for (double v : values) {
            this._dimValue.add(v);
        }
        this.setLength(this._dimValue.size());
    }

    public void setValues(float[] values) {
        this._dimValue = new ArrayList<Double>();
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double v = fArray[i];
            this._dimValue.add(v);
        }
        this.setLength(this._dimValue.size());
    }

    public void addValue(double value) {
        this._dimValue.add(value);
        this.setLength(this._dimValue.size());
    }

    public double getMinValue() {
        return this._dimValue.get(0);
    }

    public double getMaxValue() {
        return this._dimValue.get(this._dimValue.size() - 1);
    }

    public double getDeltaValue() {
        if (this._dimValue.size() <= 1) {
            return 1.0;
        }
        return BigDecimalUtil.sub(this._dimValue.get(1), this._dimValue.get(0));
    }

    public Dimension extract(int first, int last, int stride) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this._dimType);
        dim.setDimId(this._dimId);
        dim.setReverse(this.reverse);
        if (this._dimValue.size() > last) {
            ArrayList<Double> values = new ArrayList<Double>();
            int step = Math.abs(stride);
            if (this.reverse) {
                int ff = this.getLength() - last - 1;
                int ll = this.getLength() - first - 1;
                for (int i = ff; i <= ll; i += step) {
                    values.add(this._dimValue.get(i));
                }
            } else {
                for (int i = first; i <= last; i += step) {
                    values.add(this._dimValue.get(i));
                }
            }
            dim.setValues(values);
        }
        return dim;
    }

    public Dimension extract(double first, double last, double stride) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this._dimType);
        dim.setDimId(this._dimId);
        ArrayList<Double> values = new ArrayList<Double>();
        for (double v = first; v <= last; v += stride) {
            int idx = this.getValueIndex(v);
            values.add(this._dimValue.get(idx));
        }
        dim.setValues(values);
        return dim;
    }

    public Dimension extract(List<Integer> index) {
        Dimension dim = new Dimension(this.getShortName(), this.getLength(), this._dimType);
        dim.setDimId(this._dimId);
        dim.setReverse(this.reverse);
        ArrayList<Double> values = new ArrayList<Double>();
        if (this.reverse) {
            for (int i = index.size() - 1; i <= 0; --i) {
                values.add(this._dimValue.get(index.get(i)));
            }
        } else {
            for (int i = 0; i < index.size(); ++i) {
                values.add(this._dimValue.get(index.get(i)));
            }
        }
        dim.setValues(values);
        return dim;
    }

    public int getValueIndex(double v) {
        int idx = this.getLength() - 1;
        if (this.getDeltaValue() > 0.0) {
            for (int i = 0; i < this.getLength(); ++i) {
                if (!(v <= this._dimValue.get(i))) continue;
                idx = i == 0 ? 0 : (this._dimValue.get(i) - v > v - this._dimValue.get(i - 1) ? i - 1 : i);
                break;
            }
        } else {
            for (int i = 0; i < this.getLength(); ++i) {
                if (!(v >= this._dimValue.get(i))) continue;
                idx = i == 0 ? 0 : (this._dimValue.get(i - 1) - v > v - this._dimValue.get(i) ? i : i - 1);
                break;
            }
        }
        if (this.reverse) {
            idx = this.getLength() - idx - 1;
        }
        return idx;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getShortName());
        sb.append("\n");
        sb.append("Min value: ").append(String.valueOf(this.getMinValue()));
        sb.append("\n");
        sb.append("Max value: ").append(String.valueOf(this.getMaxValue()));
        sb.append("\n");
        sb.append("Size: ").append(String.valueOf(this.getLength()));
        sb.append("\n");
        sb.append("Delta: ").append(String.valueOf(this.getDeltaValue()));
        return sb.toString();
    }
}

