/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mathparser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import org.meteoinfo.data.mathparser.FunctionExpression;
import org.meteoinfo.data.mathparser.IExpression;
import org.meteoinfo.data.mathparser.NumberExpression;
import org.meteoinfo.data.mathparser.OperatorExpression;
import org.meteoinfo.data.mathparser.ParseException;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.global.MIMath;

public class MathParser {
    private boolean _isGridData;
    private StringBuilder _buffer = new StringBuilder();
    private Stack<String> _symbolStack = new Stack();
    private Queue<IExpression> _expressionQueue = new LinkedList<IExpression>();
    private Map<String, IExpression> _expressionCache = new HashMap<String, IExpression>();
    private Stack<Object> _calculationStack = new Stack();
    private Stack<Object> _parameters = new Stack();
    private List<String> _variables = new ArrayList<String>();
    private StringReader _expressionReader;
    private MeteoDataInfo _meteoDataInfo = null;

    public MathParser() {
    }

    public MathParser(MeteoDataInfo aDataInfo) {
        this._meteoDataInfo = aDataInfo;
        this._isGridData = aDataInfo.isGridData();
        this._variables = aDataInfo.getDataInfo().getVariableNames();
    }

    public Object evaluate(String expression) throws ParseException, IOException {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("expression");
        }
        this._expressionReader = new StringReader(expression);
        this._symbolStack.clear();
        this._expressionQueue.clear();
        this.parseExpressionToQueue();
        Object result = this.calculateFromQueue();
        return result;
    }

    private void parseExpressionToQueue() throws ParseException, IOException {
        int ic;
        while ((ic = this._expressionReader.read()) != -1) {
            char c = (char)ic;
            if (Character.isWhitespace(c) || this.tryNumber(c) || this.tryString(c) || this.tryStartGroup(c) || this.tryOperator(c) || this.tryEndGroup(c)) continue;
            throw new ParseException("Invalid character encountered" + c);
        }
        this.processSymbolStack();
    }

    private boolean tryNumber(char c) throws IOException, ParseException {
        double value;
        boolean isNumber = NumberExpression.isNumber(c);
        boolean isNegative = false;
        if (NumberExpression.isNegativeSign(c)) {
            if (this._expressionQueue.size() == 0) {
                isNegative = true;
            } else if (this._expressionQueue.size() > 0 && this._symbolStack.size() > 0 && this._symbolStack.peek().equals("(")) {
                isNegative = true;
            }
        }
        if (!isNumber && !isNegative) {
            return false;
        }
        this._buffer.setLength(0);
        this._buffer.append(c);
        this._expressionReader.mark(1);
        char p = (char)this._expressionReader.read();
        while (NumberExpression.isNumber(p)) {
            this._buffer.append(p);
            this._expressionReader.mark(1);
            p = (char)this._expressionReader.read();
        }
        this._expressionReader.reset();
        try {
            value = Double.parseDouble(this._buffer.toString());
        }
        catch (Exception e) {
            throw new ParseException("Invalid number format: " + this._buffer);
        }
        NumberExpression expression = new NumberExpression(value);
        this._expressionQueue.offer(expression);
        return true;
    }

    private boolean tryString(char c) throws IOException, ParseException {
        if (!Character.isLetter(c)) {
            return false;
        }
        this._buffer.setLength(0);
        this._buffer.append(c);
        this._expressionReader.mark(1);
        char p = (char)this._expressionReader.read();
        while (Character.isLetterOrDigit(p) || p == '_' || p == '@' || p == '.') {
            this._buffer.append(p);
            this._expressionReader.mark(1);
            p = (char)this._expressionReader.read();
        }
        this._expressionReader.reset();
        if (this._variables.contains(this._buffer.toString())) {
            Object value = this.getVariableValue(this._buffer.toString());
            NumberExpression expression = new NumberExpression(value);
            this._expressionQueue.offer(expression);
            return true;
        }
        if (FunctionExpression.isFunction(this._buffer.toString())) {
            this._symbolStack.push(this._buffer.toString());
            return true;
        }
        throw new ParseException("Invalid variable: " + this._buffer);
    }

    private boolean tryStartGroup(char c) {
        if (c != '(') {
            return false;
        }
        this._symbolStack.push(String.valueOf(c));
        return true;
    }

    private boolean tryOperator(char c) throws ParseException {
        boolean repeat;
        if (!OperatorExpression.isSymbol(c)) {
            return false;
        }
        String s = String.valueOf(c);
        do {
            String p = this._symbolStack.size() == 0 ? "" : this._symbolStack.peek();
            repeat = false;
            if (this._symbolStack.size() == 0) {
                this._symbolStack.push(s);
                continue;
            }
            if (p.equals("(")) {
                this._symbolStack.push(s);
                continue;
            }
            if (MathParser.precedence(s) > MathParser.precedence(p)) {
                this._symbolStack.push(s);
                continue;
            }
            IExpression e = this.getExpressionFromSymbol(this._symbolStack.pop());
            this._expressionQueue.offer(e);
            repeat = true;
        } while (repeat);
        return true;
    }

    private boolean tryEndGroup(char c) throws ParseException {
        if (c != ')') {
            return false;
        }
        boolean ok = false;
        while (this._symbolStack.size() > 0) {
            String p = this._symbolStack.pop();
            if (p.equals("(")) {
                ok = true;
                break;
            }
            IExpression e = this.getExpressionFromSymbol(p);
            this._expressionQueue.offer(e);
        }
        if (!ok) {
            throw new ParseException("Unbalance parenthese");
        }
        return true;
    }

    private void processSymbolStack() throws ParseException {
        while (this._symbolStack.size() > 0) {
            String p = this._symbolStack.pop();
            if (p.length() == 1 && p.equals("(")) {
                throw new ParseException("Unbalance parenthese");
            }
            IExpression e = this.getExpressionFromSymbol(p);
            this._expressionQueue.offer(e);
        }
    }

    private static int precedence(String c) {
        String s = c.substring(0, 1);
        if (c.length() == 1 && s.equals("*") || s.equals("/") || s.equals("%")) {
            return 2;
        }
        return 1;
    }

    private IExpression getExpressionFromSymbol(String p) throws ParseException {
        IExpression e;
        if (this._expressionCache.containsKey(p)) {
            e = this._expressionCache.get(p);
        } else if (OperatorExpression.isSymbol(p)) {
            e = new OperatorExpression(p);
            this._expressionCache.put(p, e);
        } else if (FunctionExpression.isFunction(p)) {
            e = new FunctionExpression(p, false);
            this._expressionCache.put(p, e);
        } else {
            throw new ParseException("Invalid symbol on stack" + p);
        }
        return e;
    }

    private Object calculateFromQueue() throws ParseException {
        this._calculationStack.clear();
        for (IExpression expression : this._expressionQueue) {
            if (this._calculationStack.size() < expression.getArgumentCount()) {
                throw new ParseException("Not enough numbers" + expression);
            }
            this._parameters.clear();
            for (int i = 0; i < expression.getArgumentCount(); ++i) {
                this._parameters.push(this._calculationStack.pop());
            }
            Object[] parameters = this._parameters.toArray();
            MIMath.arrayReverse(parameters);
            this._calculationStack.push(expression.evaluate(parameters));
        }
        Object result = this._calculationStack.pop();
        return result;
    }

    private Object getVariableValue(String varName) {
        if (this._meteoDataInfo == null) {
            return 100;
        }
        if (this._isGridData) {
            return this._meteoDataInfo.getGridData(varName);
        }
        return this._meteoDataInfo.getStationData(varName);
    }
}

