/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.mapdata.AttributeTable;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.PointD;
import org.meteoinfo.io.EndianDataOutputStream;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.projection.proj4j.CRSFactory;
import org.meteoinfo.projection.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.shape.PointM;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.PolygonMShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolygonZShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;

public class ShapeFileManage {
    private static final String ENCODING = "UTF-8";

    public static VectorLayer loadShapeFile(String shpfilepath) throws IOException, FileNotFoundException, Exception {
        String cpgfilepath = shpfilepath.replaceFirst(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".cpg");
        File cpgFile = new File(cpgfilepath);
        String encoding = ENCODING;
        if (cpgFile.exists()) {
            BufferedReader sr = new BufferedReader(new FileReader(cpgFile));
            String ec = sr.readLine().trim();
            sr.close();
            encoding = ec;
        }
        return ShapeFileManage.loadShapeFile(shpfilepath, encoding);
    }

    public static VectorLayer loadShapeFile(String shpfilepath, String encoding) throws IOException, FileNotFoundException, Exception {
        VectorLayer aLayer;
        String shxfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".shx");
        String dbffilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".dbf");
        String projfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".prj");
        File shpFile = new File(shpfilepath);
        File dbfFile = new File(dbffilepath);
        File shxFile = new File(shxfilepath);
        File prjFile = new File(projfilepath);
        if (!shxFile.exists()) {
            shxfilepath = shxfilepath.replace(".shx", ".SHX");
            shxFile = new File(shxfilepath);
        }
        if (!dbfFile.exists()) {
            dbffilepath = dbffilepath.replace(".dbf", ".DBF");
            dbfFile = new File(dbffilepath);
        }
        if (!prjFile.exists()) {
            projfilepath = projfilepath.replace(".prj", ".PRJ");
            prjFile = new File(projfilepath);
        }
        if ("".equals(shxfilepath)) {
            return null;
        }
        long BytesSum = shxFile.length();
        int shapeNum = (int)(BytesSum - 100L) / 8;
        ShapeFileManage.loadShxFile(shxFile);
        DataInputStream br = new DataInputStream(new BufferedInputStream(new FileInputStream(shpFile)));
        byte[] arr = new byte[100];
        br.read(arr);
        ByteBuffer buffer = ByteBuffer.wrap(arr);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)buffer).position(32);
        int aShapeType = buffer.getInt();
        ShapeTypes aST = ShapeTypes.valueOf(aShapeType);
        Extent aExtent = new Extent();
        aExtent.minX = buffer.getDouble();
        aExtent.minY = buffer.getDouble();
        aExtent.maxX = buffer.getDouble();
        aExtent.maxY = buffer.getDouble();
        switch (aST) {
            case Point: {
                aLayer = ShapeFileManage.readPointShapes(br, shapeNum);
                break;
            }
            case PointZ: {
                aLayer = ShapeFileManage.readPointZShapes(br, shapeNum);
                break;
            }
            case Polyline: {
                aLayer = ShapeFileManage.readPolylineShapes(br, shapeNum);
                break;
            }
            case PolylineZ: {
                aLayer = ShapeFileManage.readPolylineZShapes(br, shapeNum);
                break;
            }
            case Polygon: {
                aLayer = ShapeFileManage.readPolygonShapes(br, shapeNum);
                break;
            }
            case PolygonM: {
                aLayer = ShapeFileManage.readPolygonMShapes(br, shapeNum);
                break;
            }
            case PolygonZ: {
                aLayer = ShapeFileManage.readPolygonZShapes(br, shapeNum);
                break;
            }
            default: {
                System.out.println("The shape type is not supported: " + aST.toString());
                return null;
            }
        }
        br.close();
        if (aLayer != null) {
            aLayer.setExtent(aExtent);
            aLayer.setLayerDrawType(LayerDrawType.Map);
            aLayer.setFileName(shpfilepath);
            aLayer.setLayerName(shpFile.getName());
            aLayer.setVisible(true);
            AttributeTable attrTable = ShapeFileManage.loadDbfFile(shpfilepath, encoding);
            aLayer.setAttributeTable(attrTable);
            if (prjFile.exists()) {
                aLayer.setProjInfo(ShapeFileManage.loadProjFile(prjFile));
            }
        }
        return aLayer;
    }

    private static void readHeader(DataInputStream br) throws IOException {
        int i;
        int FileCode = ShapeFileManage.swapByteOrder(br.readInt());
        for (i = 0; i < 5; ++i) {
            br.readInt();
        }
        int FileLength = ShapeFileManage.swapByteOrder(br.readInt());
        int Version2 = br.readInt();
        int aShapeType = br.readInt();
        Extent aExtent = new Extent();
        aExtent.minX = br.readDouble();
        aExtent.minY = br.readDouble();
        aExtent.maxX = br.readDouble();
        aExtent.maxY = br.readDouble();
        for (i = 0; i < 4; ++i) {
            br.readDouble();
        }
    }

    private static VectorLayer readPointShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        byte[] bytes = new byte[28 * shapeNum];
        br.read(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int i = 0; i < shapeNum; ++i) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            PointShape aP = new PointShape();
            PointD aPoint = new PointD();
            aPoint.X = x;
            aPoint.Y = y;
            aP.setPoint(aPoint);
            aLayer.addShape(aP);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.black, 5.0f));
        return aLayer;
    }

    private static VectorLayer readPointZShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PointZ);
        byte[] bytes = new byte[44 * shapeNum];
        br.read(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int i = 0; i < shapeNum; ++i) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            double z = buffer.getDouble();
            double m = buffer.getDouble();
            PointZShape aP = new PointZShape();
            PointZ aPoint = new PointZ();
            aPoint.X = x;
            aPoint.Y = y;
            aPoint.Z = z;
            aPoint.M = m;
            aP.setPoint(aPoint);
            aLayer.addShape(aP);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.black, 5.0f));
        return aLayer;
    }

    private static VectorLayer readPolylineShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolylineShape aPL = new PolylineShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aPL.setExtent(extent);
            aPL.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aPL.parts = new int[aPL.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aPL.getPartNum(); ++j) {
                aPL.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            aPL.setPoints(points);
            aLayer.addShape(aPL);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.darkGray, 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolylineZShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PolylineZ);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolylineZShape aPL = new PolylineZShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aPL.setExtent(extent);
            aPL.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aPL.parts = new int[aPL.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aPL.getPartNum(); ++j) {
                aPL.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            double zmin = buffer.getDouble();
            double zmax = buffer.getDouble();
            double[] zArray = new double[numPoints];
            for (int j2 = 0; j2 < numPoints; ++j2) {
                zArray[j2] = buffer.getDouble();
            }
            double mmin = buffer.getDouble();
            double mmax = buffer.getDouble();
            double[] mArray = new double[numPoints];
            for (int j3 = 0; j3 < numPoints; ++j3) {
                mArray[j3] = buffer.getDouble();
            }
            ArrayList<PointZ> pointZs = new ArrayList<PointZ>();
            for (int j4 = 0; j4 < numPoints; ++j4) {
                pointZs.add(new PointZ(((PointD)points.get((int)j4)).X, ((PointD)points.get((int)j4)).Y, zArray[j4], mArray[j4]));
            }
            aPL.setPoints(pointZs);
            aLayer.addShape(aPL);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.darkGray, 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolygonShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polygon);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolygonShape aSPG = new PolygonShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aSPG.setExtent(extent);
            aSPG.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aSPG.parts = new int[aSPG.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aSPG.getPartNum(); ++j) {
                aSPG.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            aSPG.setPoints(points);
            aLayer.addShape(aSPG);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polygon, new Color(255, 251, 195), 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolygonMShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PolygonM);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolygonMShape aSPG = new PolygonMShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aSPG.setExtent(extent);
            aSPG.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aSPG.parts = new int[aSPG.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aSPG.getPartNum(); ++j) {
                aSPG.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            double mmin = buffer.getDouble();
            double mmax = buffer.getDouble();
            double[] mArray = new double[numPoints];
            for (int j2 = 0; j2 < numPoints; ++j2) {
                mArray[j2] = buffer.getDouble();
            }
            ArrayList<PointM> pointMs = new ArrayList<PointM>();
            for (int j3 = 0; j3 < numPoints; ++j3) {
                pointMs.add(new PointM(((PointD)points.get((int)j3)).X, ((PointD)points.get((int)j3)).Y, mArray[j3]));
            }
            aSPG.setPoints(pointMs);
            aLayer.addShape(aSPG);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polygon, new Color(255, 251, 195), 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolygonZShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PolygonZ);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolygonZShape aSPG = new PolygonZShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aSPG.setExtent(extent);
            aSPG.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aSPG.parts = new int[aSPG.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aSPG.getPartNum(); ++j) {
                aSPG.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            double zmin = buffer.getDouble();
            double zmax = buffer.getDouble();
            double[] zArray = new double[numPoints];
            for (int j2 = 0; j2 < numPoints; ++j2) {
                zArray[j2] = buffer.getDouble();
            }
            double mmin = buffer.getDouble();
            double mmax = buffer.getDouble();
            double[] mArray = new double[numPoints];
            for (int j3 = 0; j3 < numPoints; ++j3) {
                mArray[j3] = buffer.getDouble();
            }
            ArrayList<PointZ> pointZs = new ArrayList<PointZ>();
            for (int j4 = 0; j4 < numPoints; ++j4) {
                pointZs.add(new PointZ(((PointD)points.get((int)j4)).X, ((PointD)points.get((int)j4)).Y, zArray[j4], mArray[j4]));
            }
            aSPG.setPoints(pointZs);
            aLayer.addShape(aSPG);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polygon, new Color(255, 251, 195), 1.0f));
        return aLayer;
    }

    private static void loadShxFile(File shxFile) throws FileNotFoundException, IOException {
        DataInputStream bridx = new DataInputStream(new BufferedInputStream(new FileInputStream(shxFile)));
        long BytesSum = shxFile.length();
        int shapeNum = (int)(BytesSum - 100L) / 8;
        ShapeFileManage.readHeader(bridx);
        int OffSet = 0;
        int ContentLength = 0;
        for (int i = 0; i < shapeNum; ++i) {
            OffSet = ShapeFileManage.swapByteOrder(bridx.readInt());
            ContentLength = ShapeFileManage.swapByteOrder(bridx.readInt());
        }
        bridx.close();
    }

    public static AttributeTable loadDbfFile(String shpFileName, String encoding) throws Exception {
        AttributeTable attrTable = new AttributeTable();
        attrTable.setEncoding(encoding);
        attrTable.open(shpFileName);
        attrTable.fill(attrTable.getNumRecords());
        return attrTable;
    }

    public static ProjectionInfo loadProjFile(File projFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader sr = new BufferedReader(new FileReader(projFile));
        StringBuilder buffer = new StringBuilder();
        while ((line = sr.readLine()) != null) {
            buffer.append(line);
        }
        String esriString = buffer.toString();
        sr.close();
        CRSFactory crsFactory = new CRSFactory();
        CoordinateReferenceSystem crs = crsFactory.createFromEsriString(esriString);
        ProjectionInfo projInfo = ProjectionInfo.factory(crs);
        return projInfo;
    }

    public static boolean saveShapeFile(String shpfilepath, VectorLayer aLayer) throws IOException {
        String shxfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".shx");
        String dbffilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".dbf");
        String projFilePath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".prj");
        switch (aLayer.getShapeType()) {
            case Point: 
            case PointZ: 
            case Polyline: 
            case PolylineZ: 
            case Polygon: {
                ShapeFileManage.writeShxFile(shxfilepath, aLayer);
                ShapeFileManage.writeShpFile(shpfilepath, aLayer);
                ShapeFileManage.writeDbfFile(dbffilepath, aLayer);
                ShapeFileManage.writeProjFile(projFilePath, aLayer);
                return true;
            }
        }
        return false;
    }

    public static boolean saveShapeFile(String shpfilepath, VectorLayer aLayer, String encoding) throws IOException {
        String shxfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".shx");
        String dbffilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".dbf");
        String projFilePath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".prj");
        switch (aLayer.getShapeType()) {
            case Point: 
            case PointZ: 
            case Polyline: 
            case PolylineZ: 
            case Polygon: {
                ShapeFileManage.writeShxFile(shxfilepath, aLayer);
                ShapeFileManage.writeShpFile(shpfilepath, aLayer);
                ShapeFileManage.writeDbfFile(dbffilepath, aLayer, encoding);
                ShapeFileManage.writeProjFile(projFilePath, aLayer);
                return true;
            }
        }
        return false;
    }

    private static void writeShpFile(String shpfilepath, VectorLayer aLayer) throws FileNotFoundException, IOException {
        File shpFile = new File(shpfilepath);
        EndianDataOutputStream bw = new EndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(shpFile)));
        int FileLength = ShapeFileManage.getShpFileLength(aLayer);
        ShapeFileManage.writeHeader(bw, aLayer, FileLength);
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            Shape aShape = aLayer.getShapes().get(i);
            int RecordNumber = i + 1;
            ShapeFileManage.writeRecord(bw, RecordNumber, aShape, aLayer.getShapeType());
        }
        bw.close();
    }

    private static int getShpFileLength(VectorLayer aLayer) {
        int fileLength = 50;
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            Shape aShape = aLayer.getShapes().get(i);
            int cLen = ShapeFileManage.getContentLength(aShape, aLayer.getShapeType());
            fileLength += 4 + cLen;
        }
        return fileLength;
    }

    private static int getContentLength(Shape aShape, ShapeTypes aST) {
        int contentLength = 0;
        switch (aST) {
            case Point: {
                contentLength = 10;
                break;
            }
            case Polyline: {
                PolylineShape aPLS = (PolylineShape)aShape;
                contentLength = 22 + 2 * aPLS.getPartNum() + 8 * aPLS.getPointNum();
                break;
            }
            case PolylineZ: {
                PolylineZShape aPLZS = (PolylineZShape)aShape;
                contentLength = 22 + 2 * aPLZS.getPartNum() + 8 * aPLZS.getPointNum() + 4 + 4 + 4 * aPLZS.getPointNum() + 4 + 4 + 4 * aPLZS.getPointNum();
                break;
            }
            case Polygon: {
                PolygonShape aPGS = (PolygonShape)aShape;
                contentLength = 22 + 2 * aPGS.getPartNum() + 8 * aPGS.getPointNum();
            }
        }
        return contentLength;
    }

    private static void writeRecord(EndianDataOutputStream bw, int RecordNumber, Shape aShape, ShapeTypes aST) throws IOException {
        int ContentLength = ShapeFileManage.getContentLength(aShape, aST);
        bw.writeIntBE(RecordNumber);
        bw.writeIntBE(ContentLength);
        bw.writeIntLE(aST.getValue());
        switch (aST) {
            case Point: {
                PointShape aPS = (PointShape)aShape;
                bw.writeDoubleLE(aPS.getPoint().X);
                bw.writeDoubleLE(aPS.getPoint().Y);
                break;
            }
            case Polyline: {
                int i;
                PolylineShape aPLS = (PolylineShape)aShape;
                bw.writeDoubleLE(aPLS.getExtent().minX);
                bw.writeDoubleLE(aPLS.getExtent().minY);
                bw.writeDoubleLE(aPLS.getExtent().maxX);
                bw.writeDoubleLE(aPLS.getExtent().maxY);
                bw.writeIntLE(aPLS.getPartNum());
                bw.writeIntLE(aPLS.getPointNum());
                for (i = 0; i < aPLS.getPartNum(); ++i) {
                    bw.writeIntLE(aPLS.parts[i]);
                }
                for (i = 0; i < aPLS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPLS.getPoints().get((int)i).X);
                    bw.writeDoubleLE(aPLS.getPoints().get((int)i).Y);
                }
                break;
            }
            case PolylineZ: {
                int i;
                PolylineZShape aPLZS = (PolylineZShape)aShape;
                bw.writeDoubleLE(aPLZS.getExtent().minX);
                bw.writeDoubleLE(aPLZS.getExtent().minY);
                bw.writeDoubleLE(aPLZS.getExtent().maxX);
                bw.writeDoubleLE(aPLZS.getExtent().maxY);
                bw.writeIntLE(aPLZS.getPartNum());
                bw.writeIntLE(aPLZS.getPointNum());
                for (i = 0; i < aPLZS.getPartNum(); ++i) {
                    bw.writeIntLE(aPLZS.parts[i]);
                }
                for (i = 0; i < aPLZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPLZS.getPoints().get((int)i).X);
                    bw.writeDoubleLE(aPLZS.getPoints().get((int)i).Y);
                }
                bw.writeDoubleLE(aPLZS.getZRange()[0]);
                bw.writeDoubleLE(aPLZS.getZRange()[1]);
                for (i = 0; i < aPLZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPLZS.getZArray()[i]);
                }
                bw.writeDoubleLE(aPLZS.getMRange()[0]);
                bw.writeDoubleLE(aPLZS.getMRange()[1]);
                for (i = 0; i < aPLZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPLZS.getMArray()[i]);
                }
                break;
            }
            case Polygon: {
                int i;
                PolygonShape aPGS = (PolygonShape)aShape;
                bw.writeDoubleLE(aPGS.getExtent().minX);
                bw.writeDoubleLE(aPGS.getExtent().minY);
                bw.writeDoubleLE(aPGS.getExtent().maxX);
                bw.writeDoubleLE(aPGS.getExtent().maxY);
                bw.writeIntLE(aPGS.getPartNum());
                bw.writeIntLE(aPGS.getPointNum());
                for (i = 0; i < aPGS.getPartNum(); ++i) {
                    bw.writeIntLE(aPGS.parts[i]);
                }
                for (i = 0; i < aPGS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPGS.getPoints().get((int)i).X);
                    bw.writeDoubleLE(aPGS.getPoints().get((int)i).Y);
                }
                break;
            }
        }
    }

    private static void writeHeader(EndianDataOutputStream bw, VectorLayer aLayer, int FileLength) throws IOException {
        int i;
        int FileCode = 9994;
        int Unused = 0;
        int Version2 = 1000;
        int aShapeType = aLayer.getShapeType().getValue();
        bw.writeIntBE(FileCode);
        for (i = 0; i < 5; ++i) {
            bw.writeIntBE(Unused);
        }
        bw.writeIntBE(FileLength);
        bw.writeIntLE(Version2);
        bw.writeIntLE(aShapeType);
        bw.writeDoubleLE(aLayer.getExtent().minX);
        bw.writeDoubleLE(aLayer.getExtent().minY);
        bw.writeDoubleLE(aLayer.getExtent().maxX);
        bw.writeDoubleLE(aLayer.getExtent().maxY);
        for (i = 0; i < 4; ++i) {
            bw.writeDoubleLE(0.0);
        }
    }

    private static void writeShxFile(String shxfilepath, VectorLayer aLayer) throws IOException {
        File shxFile = new File(shxfilepath);
        EndianDataOutputStream bw = new EndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(shxFile)));
        int FileLength = aLayer.getShapeNum() * 4 + 50;
        ShapeFileManage.writeHeader(bw, aLayer, FileLength);
        int OffSet = 50;
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            Shape aShape = aLayer.getShapes().get(i);
            int ContentLength = ShapeFileManage.getContentLength(aShape, aLayer.getShapeType());
            bw.writeIntBE(OffSet);
            bw.writeIntBE(ContentLength);
            OffSet = OffSet + 4 + ContentLength;
        }
        bw.close();
    }

    private static void writeDbfFile(String dbffilepath, VectorLayer aLayer) {
        aLayer.getAttributeTable().saveAs(dbffilepath, true);
    }

    private static void writeDbfFile(String dbffilepath, VectorLayer aLayer, String encoding) {
        AttributeTable attTable = aLayer.getAttributeTable();
        attTable.setEncoding(encoding);
        attTable.saveAs(dbffilepath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProjFile(String projFilePath, VectorLayer aLayer) {
        BufferedWriter sw = null;
        try {
            String esriString = aLayer.getProjInfo().toEsriString();
            sw = new BufferedWriter(new FileWriter(new File(projFilePath)));
            sw.write(esriString);
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ShapeFileManage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ShapeFileManage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static int swapByteOrder(int i) {
        byte[] buffer = ShapeFileManage.intToBytes(i);
        return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }

    private static byte[] intToBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    private static int bytesToInt(byte[] buffer) {
        return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }
}

