/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.meteoinfo.data.dataframe.DataFrame;
import org.meteoinfo.data.dataframe.Index;
import org.meteoinfo.data.dataframe.impl.BlockManager;
import org.meteoinfo.data.dataframe.impl.Predicate;
import org.meteoinfo.data.dataframe.impl.SparseBitSet;

public class Selection {
    public static <V> SparseBitSet select(DataFrame df, Predicate<V> predicate) {
        SparseBitSet selected = new SparseBitSet();
        Iterator rows = df.iterator();
        int r = 0;
        while (rows.hasNext()) {
            if (((Boolean)predicate.apply(rows.next())).booleanValue()) {
                selected.set(r);
            }
            ++r;
        }
        return selected;
    }

    public static Index select(Index index, SparseBitSet selected) {
        ArrayList names = new ArrayList(index.getValues());
        Index newidx = new Index();
        int r = selected.nextSetBit(0);
        while (r >= 0) {
            Object name = names.get(r);
            newidx.add(name);
            r = selected.nextSetBit(r + 1);
        }
        return newidx;
    }

    public static <V> BlockManager<V> select(BlockManager<V> blocks, SparseBitSet selected) {
        LinkedList data = new LinkedList();
        for (int c = 0; c < blocks.size(); ++c) {
            ArrayList<V> column = new ArrayList<V>(selected.cardinality());
            int r = selected.nextSetBit(0);
            while (r >= 0) {
                column.add(blocks.get(c, r));
                r = selected.nextSetBit(r + 1);
            }
            data.add(column);
        }
        return new BlockManager(data);
    }

    public static <V> BlockManager<V> select(BlockManager<V> blocks, SparseBitSet rows, SparseBitSet cols) {
        LinkedList data = new LinkedList();
        int c = cols.nextSetBit(0);
        while (c >= 0) {
            ArrayList<V> column = new ArrayList<V>(rows.cardinality());
            int r = rows.nextSetBit(0);
            while (r >= 0) {
                column.add(blocks.get(c, r));
                r = rows.nextSetBit(r + 1);
            }
            data.add(column);
            c = cols.nextSetBit(c + 1);
        }
        return new BlockManager(data);
    }

    public static <V> SparseBitSet[] slice(DataFrame df, Integer rowStart, Integer rowEnd, Integer colStart, Integer colEnd) {
        SparseBitSet rows = new SparseBitSet();
        SparseBitSet cols = new SparseBitSet();
        rows.set((int)rowStart, rowEnd);
        cols.set((int)colStart, colEnd);
        return new SparseBitSet[]{rows, cols};
    }

    public static class DropNaPredicate<V>
    implements Predicate<V> {
        @Override
        public Boolean apply(List<V> values) {
            for (V value : values) {
                if (value != null) continue;
                return false;
            }
            return true;
        }
    }
}

