/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.List;
import org.meteoinfo.data.XYSeriesData;
import ucar.ma2.Array;

public class XYErrorSeriesData
extends XYSeriesData {
    private double[] xerror;
    private double[] xerror_upper;
    private double[] yerror;
    private double[] yerror_upper;
    private double[] bottom;

    public XYErrorSeriesData() {
    }

    public XYErrorSeriesData(String key, double[] xdata, double[] ydata, double[] yerror) {
        super(key, xdata, ydata);
        this.yerror = yerror;
    }

    public XYErrorSeriesData(String key, double[] xdata, double[] ydata, double[] xerror, double[] yerror) {
        super(key, xdata, ydata);
        this.xerror = xerror;
        this.yerror = yerror;
    }

    public double[] getXerror() {
        return this.xerror;
    }

    public void setXerror(double[] value) {
        this.xerror = value;
    }

    public void setXerror(double value) {
        this.xerror = new double[this.dataLength()];
        for (int i = 0; i < this.xerror.length; ++i) {
            this.xerror[i] = value;
        }
    }

    public void setXerror(List<Number> value) {
        this.xerror = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.xerror[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public void setXerror(Array value) {
        this.xerror = new double[(int)value.getSize()];
        for (int i = 0; i < this.xerror.length; ++i) {
            double v = value.getDouble(i);
            this.xerror[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public double[] getXerror_upper() {
        return this.xerror_upper;
    }

    public void setXerror_upper(double[] value) {
        this.xerror_upper = value;
    }

    public double[] getYerror() {
        return this.yerror;
    }

    public void setYerror(double[] value) {
        this.yerror = value;
    }

    public void setYerror(double value) {
        this.yerror = new double[this.dataLength()];
        for (int i = 0; i < this.yerror.length; ++i) {
            this.yerror[i] = value;
        }
    }

    public void setYerror(List<Number> value) {
        this.yerror = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.yerror[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public void setYerror(Array value) {
        this.yerror = new double[(int)value.getSize()];
        for (int i = 0; i < this.yerror.length; ++i) {
            double v = value.getDouble(i);
            this.yerror[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public double[] getYerror_upper() {
        return this.yerror_upper;
    }

    public void setYerror_upper(double[] value) {
        this.yerror_upper = value;
    }

    public double[] getBottom() {
        return this.bottom;
    }

    public void setBottom(double value) {
        this.bottom = new double[this.dataLength()];
        for (int i = 0; i < this.bottom.length; ++i) {
            this.bottom[i] = value;
        }
    }

    public void setBottom(double[] value) {
        this.bottom = value;
    }

    public void setBottom(List<Number> value) {
        this.bottom = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.bottom[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public void setBottom(Array value) {
        this.bottom = new double[(int)value.getSize()];
        for (int i = 0; i < this.bottom.length; ++i) {
            double v = value.getDouble(i);
            this.bottom[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public double getXerror(int idx) {
        return this.xerror[idx];
    }

    public double getYerror(int idx) {
        return this.yerror[idx];
    }

    @Override
    public double getX_max(int idx) {
        double v = this.getX(idx);
        if (this.xerror != null) {
            v += this.xerror[idx];
        }
        return v;
    }

    @Override
    public double getX_min(int idx) {
        double v = this.getX(idx);
        if (this.xerror != null) {
            v -= this.xerror[idx];
        }
        return v;
    }

    @Override
    public double getY_max(int idx) {
        double v = this.getY(idx);
        if (this.yerror != null) {
            v += this.yerror[idx];
        }
        return v;
    }

    @Override
    public double getY_min(int idx) {
        double v = this.getY(idx);
        if (this.yerror != null) {
            v -= this.yerror[idx];
        }
        return v;
    }

    public double getBottom(int idx) {
        return this.bottom[idx];
    }
}

