/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.TableUtil;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;

public class TableData
extends DataTable {
    protected double missingValue = -9999.0;

    public TableData() {
    }

    public TableData(DataTable dataTable) {
        this.columns = dataTable.getColumns();
        this.readOnly = dataTable.isReadOnly();
        this.rows = dataTable.getRows();
        this.tableName = dataTable.getTableName();
        this.tag = dataTable.getTag();
    }

    public String getTimeColName() {
        return null;
    }

    public double getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(double value) {
        this.missingValue = value;
    }

    @Override
    public void addColumnData(String colName, String dt, List<Object> colData) throws Exception {
        DataTypes dataType = TableUtil.toDataTypes(dt);
        switch (dataType) {
            case Date: {
                if (colData.get(0) instanceof Date) {
                    this.addColumnData(colName, dataType, colData);
                    break;
                }
                String dformat = TableUtil.getDateFormat(dt);
                this.addColumn(new DataColumn(colName, dataType, dformat));
                this.setValues(colName, colData);
                break;
            }
            default: {
                this.addColumnData(colName, dataType, colData);
            }
        }
    }

    public void addColumnData(int index, String colName, String dt, List<Object> colData) throws Exception {
        DataTypes dataType = TableUtil.toDataTypes(dt);
        switch (dataType) {
            case Date: {
                if (colData.get(0) instanceof Date) {
                    this.addColumnData(index, colName, dataType, colData);
                    break;
                }
                String dformat = TableUtil.getDateFormat(dt);
                this.addColumn(index, new DataColumn(colName, dataType, dformat));
                this.setValues(colName, colData);
                break;
            }
            default: {
                this.addColumnData(index, colName, dataType, colData);
            }
        }
    }

    public void removeColumn(String colName) {
        this.removeColumn(this.findColumn(colName));
    }

    public DataRow getRow(int idx) {
        return (DataRow)this.getRows().get(idx);
    }

    public List<DataColumn> getDataColumns() {
        ArrayList<DataColumn> cols = new ArrayList<DataColumn>();
        for (DataColumn col : this.getColumns()) {
            if (col.getDataType() == DataTypes.Date) continue;
            cols.add(col);
        }
        return cols;
    }

    public List<Double> getValidColumnValues(DataColumn col) {
        return this.getValidColumnValues(this.getRows(), col);
    }

    public List<Double> getValidColumnValues(List<DataRow> rows, DataColumn col) {
        ArrayList<Double> values = new ArrayList<Double>();
        String colName = col.getColumnName();
        double value = Double.NaN;
        for (DataRow row : rows) {
            if (row.getValue(colName) == null) continue;
            switch (col.getDataType()) {
                case Integer: {
                    value = ((Integer)row.getValue(colName)).intValue();
                    break;
                }
                case Float: {
                    value = ((Float)row.getValue(colName)).floatValue();
                    break;
                }
                case Double: {
                    value = (Double)row.getValue(colName);
                    break;
                }
                case String: {
                    String vstr = (String)row.getValue(colName);
                    value = !vstr.isEmpty() ? Double.parseDouble(vstr) : Double.NaN;
                }
            }
            if (Double.isNaN(value) || MIMath.doubleEquals(value, this.missingValue)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public void setColumnData(String colName, List<Object> values) {
        this.setValues(colName, values);
    }

    public void columnToDouble(String colName) {
        DataColumn col = this.findColumn(colName);
        DataTypes oldType = col.getDataType();
        col.setDataType(DataTypes.Double);
        for (DataRow row : this.getRows()) {
            Object value = row.getValue(colName);
            switch (oldType) {
                case Integer: {
                    row.setValue(col, (Object)((Integer)value));
                    break;
                }
                case Float: {
                    row.setValue(col, (Object)((Float)value).floatValue());
                    break;
                }
                case String: {
                    if (MIMath.isNumeric((String)value)) {
                        row.setValue(col, (Object)Double.parseDouble((String)value));
                        break;
                    }
                    row.setValue(col, (Object)Double.NaN);
                }
            }
        }
    }

    public DataTable average(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        DataRow nRow = rTable.addRow();
        for (DataColumn col : cols) {
            List<Double> values = this.getValidColumnValues(col);
            double mean = Statistics.mean(values);
            nRow.setValue(col, (Object)mean);
        }
        return rTable;
    }

    public DataTable sum(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        DataRow nRow = rTable.addRow();
        for (DataColumn col : cols) {
            List<Double> values = this.getValidColumnValues(col);
            double mean = Statistics.sum(values);
            nRow.setValue(col, (Object)mean);
        }
        return rTable;
    }

    public DataTable ave_stdev(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
            rTable.addColumn(col.getColumnName() + "_sd", DataTypes.Double);
        }
        DataRow nRow = rTable.addRow();
        for (DataColumn col : cols) {
            List<Double> values = this.getValidColumnValues(col);
            double mean = Statistics.mean(values);
            double stdev = Statistics.standardDeviation(values);
            nRow.setValue(col.getColumnName(), (Object)mean);
            nRow.setValue(col.getColumnName() + "_sd", (Object)stdev);
        }
        return rTable;
    }

    public DataTable statistics(List<DataColumn> dataColumns) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Type", DataTypes.String);
        rTable.addColumn("Mean", DataTypes.Double);
        rTable.addColumn("Minimum", DataTypes.Double);
        rTable.addColumn("Q1", DataTypes.Double);
        rTable.addColumn("Meadian", DataTypes.Double);
        rTable.addColumn("Q3", DataTypes.Double);
        rTable.addColumn("Maximum", DataTypes.Double);
        rTable.addColumn("StdDev", DataTypes.Double);
        rTable.addColumn("Count", DataTypes.Integer);
        int i = 0;
        for (DataColumn col : dataColumns) {
            List<Double> values = this.getValidColumnValues(col);
            double mean = Statistics.mean(values);
            double min = Statistics.minimum(values);
            double q1 = Statistics.quantile(values, 1);
            double meadian = Statistics.median(values);
            double q3 = Statistics.quantile(values, 3);
            double max = Statistics.maximum(values);
            double sd = Statistics.standardDeviation(values);
            int n = values.size();
            rTable.addRow();
            rTable.setValue(i, 0, (Object)col.getColumnName());
            rTable.setValue(i, 1, (Object)mean);
            rTable.setValue(i, 2, (Object)min);
            rTable.setValue(i, 3, (Object)q1);
            rTable.setValue(i, 4, (Object)meadian);
            rTable.setValue(i, 5, (Object)q3);
            rTable.setValue(i, 6, (Object)max);
            rTable.setValue(i, 7, (Object)sd);
            rTable.setValue(i, 8, (Object)n);
            ++i;
        }
        return rTable;
    }

    public DataTable statistics() throws Exception {
        return this.statistics(this.getDataColumns());
    }

    public void readASCIIFile(String fileName, String formatSpec) throws FileNotFoundException, IOException, Exception {
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
        String title = sr.readLine().trim();
        String delimiter = GlobalUtil.getDelimiter(title);
        sr.close();
        this.readASCIIFile(fileName, delimiter, 0, formatSpec, "UTF8");
    }

    public void readASCIIFile(String fileName, String delimiter, int headerLines, String formatSpec, String encoding) throws FileNotFoundException, IOException, Exception {
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (headerLines > 0) {
            for (int i = 0; i < headerLines; ++i) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        String[] titleArray = GlobalUtil.split(title, delimiter);
        int colNum = titleArray.length;
        if (titleArray.length < 2) {
            System.out.println("File Format Error!");
            sr.close();
        } else {
            String[] colFormats;
            if (formatSpec == null) {
                colFormats = new String[colNum];
                for (int i = 0; i < colNum; ++i) {
                    colFormats[i] = "C";
                }
            } else {
                colFormats = formatSpec.split("%");
            }
            int idx = 0;
            for (String colFormat : colFormats) {
                if (colFormat.isEmpty()) continue;
                switch (colFormat) {
                    case "C": 
                    case "s": {
                        this.addColumn(titleArray[idx], DataTypes.String);
                        break;
                    }
                    case "i": {
                        this.addColumn(titleArray[idx], DataTypes.Integer);
                        break;
                    }
                    case "f": {
                        this.addColumn(titleArray[idx], DataTypes.Float);
                        break;
                    }
                    case "d": {
                        this.addColumn(titleArray[idx], DataTypes.Double);
                        break;
                    }
                    case "B": {
                        this.addColumn(titleArray[idx], DataTypes.Boolean);
                        break;
                    }
                    default: {
                        if (colFormat.substring(0, 1).equals("{")) {
                            int eidx = colFormat.indexOf("}");
                            String formatStr = colFormat.substring(1, eidx);
                            this.addColumn(new DataColumn(titleArray[idx], DataTypes.Date, formatStr));
                            break;
                        }
                        this.addColumn(titleArray[idx], DataTypes.String);
                    }
                }
                ++idx;
            }
            int rn = 0;
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                String[] dataArray = GlobalUtil.split(line, delimiter);
                this.addRow();
                int cn = 0;
                for (int i = 0; i < dataArray.length; ++i) {
                    this.setValue(rn, cn, (Object)dataArray[i]);
                    ++cn;
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
    }

    public void readASCIIFile(String fileName, List<DataColumn> dataColumns) throws FileNotFoundException, IOException, Exception {
        String separator;
        BufferedReader sr = new BufferedReader(new FileReader(new File(fileName)));
        String title = sr.readLine().trim();
        String[] titleArray = GlobalUtil.split(title, separator = GlobalUtil.getDelimiter(title));
        if (titleArray.length < 2) {
            JOptionPane.showMessageDialog(null, "File Format Error!");
            sr.close();
        } else {
            for (DataColumn col : dataColumns) {
                this.addColumn(col);
            }
            ArrayList<Integer> dataIdxs = new ArrayList<Integer>();
            for (int i = 0; i < titleArray.length; ++i) {
                String fieldName = titleArray[i];
                for (DataColumn col : dataColumns) {
                    if (!fieldName.equals(col.getColumnName())) continue;
                    dataIdxs.add(i);
                }
            }
            int rn = 0;
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] dataArray = GlobalUtil.split(line, separator);
                this.addRow();
                int cn = 0;
                Iterator iterator = dataIdxs.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    this.setValue(rn, cn, (Object)dataArray[idx]);
                    ++cn;
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
    }

    public void readASCIIFile(String fileName) throws FileNotFoundException, IOException, Exception {
        String separator;
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
        String title = sr.readLine().trim();
        String[] titleArray = GlobalUtil.split(title, separator = GlobalUtil.getDelimiter(title));
        if (titleArray.length < 2) {
            JOptionPane.showMessageDialog(null, "File Format Error!");
            sr.close();
        } else {
            ArrayList<Integer> dataIdxs = new ArrayList<Integer>();
            for (int i = 0; i < titleArray.length; ++i) {
                String fieldName = titleArray[i];
                this.addColumn(fieldName, DataTypes.String);
                dataIdxs.add(i);
            }
            int rn = 0;
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] dataArray = GlobalUtil.split(line, separator);
                this.addRow();
                int cn = 0;
                Iterator iterator = dataIdxs.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    this.setValue(rn, cn, (Object)dataArray[idx]);
                    ++cn;
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataTable toSingleRowTable(DataTable inTable, String firstColName, String firstColValue) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn(firstColName, DataTypes.String);
        ArrayList<Object> values = new ArrayList<Object>();
        if (inTable.getColumnCount() == 2) {
            DataColumn col = (DataColumn)inTable.getColumns().get(1);
            String colName = col.getColumnName();
            boolean bl = false;
            for (DataRow row : inTable.getRows()) {
                void var8_11;
                String rowName = row.getValue(0).toString();
                DataColumn newCol = new DataColumn(rowName, col.getDataType());
                rTable.addColumn(newCol);
                values.add(inTable.getValue((int)var8_11, colName));
                ++var8_11;
            }
        } else {
            int i = 0;
            for (DataColumn dataColumn : inTable.getColumns()) {
                if (i > 0) {
                    String colName = dataColumn.getColumnName();
                    int r = 0;
                    for (DataRow row : inTable.getRows()) {
                        String rowName = row.getValue(0).toString();
                        DataColumn newCol = new DataColumn(rowName + "_" + colName, dataColumn.getDataType());
                        rTable.addColumn(newCol);
                        values.add(inTable.getValue(r, colName));
                        ++r;
                    }
                }
                ++i;
            }
        }
        rTable.addRow();
        rTable.setValue(0, 0, (Object)firstColValue);
        int i = 1;
        for (Object e : values) {
            rTable.setValue(0, i, e);
            ++i;
        }
        return rTable;
    }

    /*
     * WARNING - void declaration
     */
    public DataTable toSingleRowTable(DataTable inTable) throws Exception {
        DataTable rTable = new DataTable();
        ArrayList<Object> values = new ArrayList<Object>();
        if (inTable.getColumnCount() == 2) {
            DataColumn col = (DataColumn)inTable.getColumns().get(1);
            String colName = col.getColumnName();
            boolean bl = false;
            for (DataRow row : inTable.getRows()) {
                void var6_9;
                String rowName = row.getValue(0).toString();
                DataColumn newCol = new DataColumn(rowName, col.getDataType());
                rTable.addColumn(newCol);
                values.add(inTable.getValue((int)var6_9, colName));
                ++var6_9;
            }
        } else {
            int i = 0;
            for (DataColumn dataColumn : inTable.getColumns()) {
                if (i > 0) {
                    String colName = dataColumn.getColumnName();
                    int r = 0;
                    for (DataRow row : inTable.getRows()) {
                        String rowName = row.getValue(0).toString();
                        DataColumn newCol = new DataColumn(rowName + "_" + colName, dataColumn.getDataType());
                        rTable.addColumn(newCol);
                        values.add(inTable.getValue(r, colName));
                        ++r;
                    }
                }
                ++i;
            }
        }
        rTable.addRow();
        int i = 0;
        for (Object e : values) {
            rTable.setValue(0, i, e);
            ++i;
        }
        return rTable;
    }

    /*
     * WARNING - void declaration
     */
    public DataTable toSingleRowTable() throws Exception {
        DataTable rTable = new DataTable();
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.getColumnCount() == 2) {
            DataColumn col = (DataColumn)this.getColumns().get(1);
            String colName = col.getColumnName();
            boolean bl = false;
            for (DataRow row : this.getRows()) {
                void var5_8;
                String rowName = row.getValue(0).toString();
                DataColumn newCol = new DataColumn(rowName, col.getDataType());
                rTable.addColumn(newCol);
                values.add(this.getValue((int)var5_8, colName));
                ++var5_8;
            }
        } else {
            int i = 0;
            for (DataColumn dataColumn : this.getColumns()) {
                if (i > 0) {
                    String colName = dataColumn.getColumnName();
                    int r = 0;
                    for (DataRow row : this.getRows()) {
                        String rowName = row.getValue(0).toString();
                        DataColumn newCol = new DataColumn(rowName + "_" + colName, dataColumn.getDataType());
                        rTable.addColumn(newCol);
                        values.add(this.getValue(r, colName));
                        ++r;
                    }
                }
                ++i;
            }
        }
        rTable.addRow();
        int i = 0;
        for (Object e : values) {
            rTable.setValue(0, i, e);
            ++i;
        }
        return rTable;
    }

    public void join(TableData tableData, String colName) {
        this.join(tableData, colName, colName, false);
    }

    public void join(TableData tableData, String thisColName, String otherColName) {
        this.join(tableData, thisColName, otherColName, false);
    }

    @Override
    public Object clone() {
        TableData td = (TableData)super.clone();
        td.missingValue = this.missingValue;
        return td;
    }

    public List<Integer> getYears(String tColName) {
        ArrayList<Integer> years = new ArrayList<Integer>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            int year = cal.get(1);
            if (years.contains(year)) continue;
            years.add(year);
        }
        return years;
    }

    public List<String> getYearMonths(String tColName) {
        ArrayList<String> yms = new ArrayList<String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        for (DataRow row : this.getRows()) {
            String ym = format.format((Date)row.getValue(tColName));
            if (yms.contains(ym)) continue;
            yms.add(ym);
        }
        return yms;
    }

    public List<DataRow> getDataByYear(int year, String tColName) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            if (cal.get(1) != year) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataBySeason(String season, String tColName) {
        List<Integer> months = this.getMonthsBySeason(season);
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            int month = cal.get(2) + 1;
            if (!months.contains(month)) continue;
            rows.add(row);
        }
        return rows;
    }

    private List<Integer> getMonthsBySeason(String season) {
        ArrayList<Integer> months = new ArrayList<Integer>();
        if (season.equalsIgnoreCase("spring")) {
            months.add(3);
            months.add(4);
            months.add(5);
        } else if (season.equalsIgnoreCase("summer")) {
            months.add(6);
            months.add(7);
            months.add(8);
        } else if (season.equalsIgnoreCase("autumn")) {
            months.add(9);
            months.add(10);
            months.add(11);
        } else if (season.equalsIgnoreCase("winter")) {
            months.add(12);
            months.add(1);
            months.add(2);
        }
        return months;
    }

    public List<DataRow> getDataByYearMonth(String yearMonth, String tColName) {
        int year = Integer.parseInt(yearMonth.substring(0, 4));
        int month = Integer.parseInt(yearMonth.substring(4));
        return this.getDataByYearMonth(year, month, tColName);
    }

    public List<DataRow> getDataByYearMonth(int year, int month, String tColName) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            if (cal.get(1) != year || cal.get(2) != month - 1) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByMonth(int month, String tColName) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            if (cal.get(2) != month - 1) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByDayOfWeek(int dow, String tColName) {
        if (++dow == 8) {
            dow = 1;
        }
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            if (cal.get(7) != dow) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByHour(int hour, String tColName) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        Calendar cal = Calendar.getInstance();
        for (DataRow row : this.getRows()) {
            cal.setTime((Date)row.getValue(tColName));
            if (cal.get(11) != hour) continue;
            rows.add(row);
        }
        return rows;
    }

    public DataTable ave_Year(List<DataColumn> cols, String tColName) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Year", DataTypes.Integer);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        List<Integer> years = this.getYears(tColName);
        for (int year : years) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)year);
            List<DataRow> rows = this.getDataByYear(year, tColName);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable ave_Month(List<DataColumn> cols, String tColName) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("YearMonth", DataTypes.String);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        List<String> yms = this.getYearMonths(tColName);
        for (String ym : yms) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)ym);
            List<DataRow> rows = this.getDataByYearMonth(ym, tColName);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable ave_MonthOfYear(List<DataColumn> cols, String tColName) throws Exception {
        int i;
        DataTable rTable = new DataTable();
        rTable.addColumn("Month", DataTypes.String);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        List<String> monthNames = Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (i = 1; i < 13; ++i) {
            months.add(i);
        }
        i = 0;
        Iterator iterator = months.iterator();
        while (iterator.hasNext()) {
            int month = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)monthNames.get(i));
            List<DataRow> rows = this.getDataByMonth(month, tColName);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
            ++i;
        }
        return rTable;
    }

    public DataTable ave_SeasonOfYear(List<DataColumn> cols, String tColName) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Season", DataTypes.String);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        List<String> seasons = Arrays.asList("Spring", "Summer", "Autumn", "Winter");
        for (String season : seasons) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)season);
            List<DataRow> rows = this.getDataBySeason(season, tColName);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable ave_DayOfWeek(List<DataColumn> cols, String tColName) throws Exception {
        int i;
        DataTable rTable = new DataTable();
        rTable.addColumn("Day", DataTypes.String);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        List<String> dowNames = Arrays.asList("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        ArrayList<Integer> dows = new ArrayList<Integer>();
        dows.add(7);
        for (i = 1; i < 7; ++i) {
            dows.add(i);
        }
        i = 0;
        Iterator iterator = dows.iterator();
        while (iterator.hasNext()) {
            int dow = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)dowNames.get(i));
            List<DataRow> rows = this.getDataByDayOfWeek(dow, tColName);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
            ++i;
        }
        return rTable;
    }

    public DataTable ave_HourOfDay(List<DataColumn> cols, String tColName) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Hour", DataTypes.Integer);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataTypes.Double);
        }
        ArrayList<Integer> hours = new ArrayList<Integer>();
        for (int i = 0; i < 24; ++i) {
            hours.add(i);
        }
        Iterator iterator = hours.iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)hour);
            List<DataRow> rows = this.getDataByHour(hour, tColName);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    @Override
    public TableData sqlSelect(String expression) {
        TableData r = new TableData(super.sqlSelect(expression));
        return r;
    }
}

