/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot3d;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.meteoinfo.data.DataMath;

public final class Projector {
    private float scale_x;
    private float scale_y;
    private float scale_z;
    private float distance;
    private float _2D_scale_x;
    private float _2D_scale_y;
    private float rotation;
    private float elevation;
    private float sin_rotation;
    private float cos_rotation;
    private float sin_elevation;
    private float cos_elevation;
    private int _2D_trans_x;
    private int _2D_trans_y;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int center_x;
    private int center_y;
    private int trans_x;
    private int trans_y;
    private float factor_x;
    private float factor_y;
    private float sx_cos;
    private float sy_cos;
    private float sz_cos;
    private float sx_sin;
    private float sy_sin;
    private float sz_sin;
    private final float DEGTORAD = (float)Math.PI / 180;
    float zmin;
    float zmax;
    float zfactor;

    public Projector() {
        this.setScaling(1.0f);
        this.setRotationAngle(0.0f);
        this.setElevationAngle(0.0f);
        this.setDistance(10.0f);
        this.set2DScaling(1.0f);
        this.set2DTranslation(0, 0);
    }

    public void setProjectionArea(Rectangle r) {
        this.x1 = r.x;
        this.x2 = this.x1 + r.width;
        this.y1 = r.y;
        this.y2 = this.y1 + r.height;
        this.center_x = (this.x1 + this.x2) / 2;
        this.center_y = (this.y1 + this.y2) / 2;
        this.trans_x = this.center_x + this._2D_trans_x;
        this.trans_y = this.center_y + this._2D_trans_y;
        this.update2DScaling();
    }

    public void setRotationAngle(float angle) {
        this.rotation = angle;
        this.sin_rotation = (float)Math.sin(angle * ((float)Math.PI / 180));
        this.cos_rotation = (float)Math.cos(angle * ((float)Math.PI / 180));
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
    }

    public float getRotationAngle() {
        return this.rotation;
    }

    public float getSinRotationAngle() {
        return this.sin_rotation;
    }

    public float getCosRotationAngle() {
        return this.cos_rotation;
    }

    public void setElevationAngle(float angle) {
        this.elevation = angle;
        this.sin_elevation = (float)Math.sin(angle * ((float)Math.PI / 180));
        this.cos_elevation = (float)Math.cos(angle * ((float)Math.PI / 180));
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public float getElevationAngle() {
        return this.elevation;
    }

    public float getSinElevationAngle() {
        return this.sin_elevation;
    }

    public float getCosElevationAngle() {
        return this.cos_elevation;
    }

    public void setDistance(float new_distance) {
        this.distance = new_distance;
        this.factor_x = this.distance * this._2D_scale_x;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setXScaling(float scaling) {
        this.scale_x = scaling;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
    }

    public float getXScaling() {
        return this.scale_x;
    }

    public void setYScaling(float scaling) {
        this.scale_y = scaling;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
    }

    public float getYScaling() {
        return this.scale_y;
    }

    public void setZScaling(float scaling) {
        this.scale_z = scaling;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public float getZScaling() {
        return this.scale_z;
    }

    public void setScaling(float x, float y, float z) {
        this.scale_x = x;
        this.scale_y = y;
        this.scale_z = z;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public void setScaling(float scaling) {
        this.scale_y = this.scale_z = scaling;
        this.scale_x = this.scale_z;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public void set2DScaling(float scaling) {
        this._2D_scale_x = scaling;
        this._2D_scale_y = scaling;
        this.factor_x = this.distance * this._2D_scale_x;
        this.factor_y = this.distance * this._2D_scale_y;
    }

    public void setX2DScaling(float scaling) {
        this._2D_scale_x = scaling;
        this.factor_x = this.distance * this._2D_scale_x;
    }

    public void setY2DScaling(float scaling) {
        this._2D_scale_y = scaling;
        this.factor_y = this.distance * this._2D_scale_y;
    }

    public float getX2DScaling() {
        return this._2D_scale_x;
    }

    public float getY2DScaling() {
        return this._2D_scale_y;
    }

    public void set2DTranslation(int x, int y) {
        this._2D_trans_x = x;
        this._2D_trans_y = y;
        this.trans_x = this.center_x + this._2D_trans_x;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public void set2D_xTranslation(int x) {
        this._2D_trans_x = x;
        this.trans_x = this.center_x + this._2D_trans_x;
    }

    public int get2D_xTranslation() {
        return this._2D_trans_x;
    }

    public void set2D_yTranslation(int y) {
        this._2D_trans_y = y;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public int get2D_yTranslation() {
        return this._2D_trans_y;
    }

    public final Point project(float x, float y, float z) {
        float temp = x;
        x = x * this.sx_cos + y * this.sy_sin;
        y = temp * this.sx_sin + y * this.sy_cos;
        float temp_x = this.factor_x / (y * this.cos_elevation - z * this.sz_sin + this.distance);
        float temp_y = this.factor_y / (y * this.cos_elevation - z * this.sz_sin + this.distance);
        return new Point(Math.round(x * temp_x) + this.trans_x, Math.round((y * this.sin_elevation + z * this.sz_cos) * -temp_y) + this.trans_y);
    }

    public double[] projectAL(float x1, float y1, float z1, float x2, float y2, float z2) {
        Point p1 = this.project(x1, y1, z1);
        Point p2 = this.project(x2, y2, z2);
        float u = p2.x - p1.x;
        float v = p2.y - p1.y;
        return DataMath.getDSFromUV(u, v);
    }

    public final Point project_noScale(float x, float y, float z) {
        float temp = x;
        x = x * this.sx_cos + y * this.sy_sin;
        y = temp * this.sx_sin + y * this.sy_cos;
        return new Point(Math.round(x) + this.trans_x, Math.round(y * this.sin_elevation + z * this.sz_cos) + this.trans_y);
    }

    public void setZRange(float zmin, float zmax) {
        this.zmin = zmin;
        this.zmax = zmax;
        this.zfactor = 20.0f / (zmax - zmin);
    }

    public Rectangle getBounds() {
        ArrayList<Point> ps = new ArrayList<Point>();
        ps.add(this.project(10.0f, 10.0f, 10.0f));
        ps.add(this.project(-10.0f, 10.0f, 10.0f));
        ps.add(this.project(10.0f, -10.0f, 10.0f));
        ps.add(this.project(-10.0f, -10.0f, 10.0f));
        ps.add(this.project(10.0f, 10.0f, -10.0f));
        ps.add(this.project(-10.0f, -10.0f, -10.0f));
        ps.add(this.project(-10.0f, 10.0f, -10.0f));
        ps.add(this.project(10.0f, -10.0f, -10.0f));
        int i = 0;
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int maxy = 0;
        for (Point p : ps) {
            if (i == 0) {
                minx = p.x;
                maxx = p.x;
                miny = p.y;
                maxy = p.y;
            } else {
                if (minx > p.x) {
                    minx = p.x;
                } else if (maxx < p.x) {
                    maxx = p.x;
                }
                if (miny > p.y) {
                    miny = p.y;
                } else if (maxy < p.y) {
                    maxy = p.y;
                }
            }
            ++i;
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public Rectangle getBounds_noScale() {
        ArrayList<Point> ps = new ArrayList<Point>();
        ps.add(this.project_noScale(10.0f, 10.0f, 10.0f));
        ps.add(this.project_noScale(-10.0f, 10.0f, 10.0f));
        ps.add(this.project_noScale(10.0f, -10.0f, 10.0f));
        ps.add(this.project_noScale(-10.0f, -10.0f, 10.0f));
        ps.add(this.project_noScale(10.0f, 10.0f, -10.0f));
        ps.add(this.project_noScale(-10.0f, -10.0f, -10.0f));
        ps.add(this.project_noScale(-10.0f, 10.0f, -10.0f));
        ps.add(this.project_noScale(10.0f, -10.0f, -10.0f));
        int i = 0;
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int maxy = 0;
        for (Point p : ps) {
            if (i == 0) {
                minx = p.x;
                maxx = p.x;
                miny = p.y;
                maxy = p.y;
            } else {
                if (minx > p.x) {
                    minx = p.x;
                } else if (maxx < p.x) {
                    maxx = p.x;
                }
                if (miny > p.y) {
                    miny = p.y;
                } else if (maxy < p.y) {
                    maxy = p.y;
                }
            }
            ++i;
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public void update2DScaling() {
        Rectangle rect = this.getBounds();
        float s1 = (float)((double)(this.x2 - this.x1) / rect.getWidth());
        float s2 = (float)((double)(this.y2 - this.y1) / rect.getHeight());
        this.setX2DScaling(s1 *= this._2D_scale_x);
        this.setY2DScaling(s2 *= this._2D_scale_y);
    }
}

