/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.PointF;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.ShapeTypes;

public class ChartColorBar
extends ChartLegend {
    private List<Double> tickLocations = new ArrayList<Double>();
    private List<ChartText> tickLabels = new ArrayList<ChartText>();
    private boolean autoTick = true;
    private boolean insideTick = true;
    private int tickLength = 5;

    public ChartColorBar(LegendScheme ls) {
        super(ls);
    }

    public List<Double> getTickLocations() {
        return this.tickLocations;
    }

    public void setTickLocations(List<Number> value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (Number v : value) {
            this.tickLocations.add(v.doubleValue());
            this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros(String.valueOf(v))));
        }
        this.autoTick = false;
    }

    public void setTickLocations(double[] value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (double v : value) {
            this.tickLocations.add(v);
            this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros(String.valueOf(v))));
        }
        this.autoTick = false;
    }

    public List<ChartText> getTickLabels() {
        return this.tickLabels;
    }

    public List<String> getTickLabelText() {
        ArrayList<String> strs = new ArrayList<String>();
        for (ChartText ct : this.tickLabels) {
            strs.add(ct.toString());
        }
        return strs;
    }

    public void setTickLabelText(List<String> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (String v : value) {
            this.tickLabels.add(new ChartText(v));
        }
        this.autoTick = false;
    }

    public void setTickLabels(List<ChartText> value) {
        this.tickLabels = value;
    }

    public void setTickLabels_Number(List<Number> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (Number v : value) {
            this.tickLabels.add(new ChartText(v.toString()));
        }
        this.autoTick = false;
    }

    public boolean isAutoTick() {
        return this.autoTick;
    }

    public void setAutoTick(boolean value) {
        this.autoTick = value;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int value) {
        this.tickLength = value;
    }

    public boolean isInsideTick() {
        return this.insideTick;
    }

    public void setInsideTick(boolean value) {
        this.insideTick = value;
    }

    @Override
    public void draw(Graphics2D g, PointF point) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(point.X + this.xshift, point.Y + this.yshift);
        if (this.drawBackground) {
            g.setColor(this.background);
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        }
        g.setStroke(new BasicStroke(1.0f));
        switch (this.orientation) {
            case HORIZONTAL: {
                this.drawHorizontalBarLegend(g, this.legendScheme);
                break;
            }
            case VERTICAL: {
                this.drawVerticalBarLegend(g, this.legendScheme);
            }
        }
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawTickLine(Graphics2D g, PointF sP, int tickLen, boolean vertical, float shift) {
        if (vertical) {
            if (this.insideTick) {
                g.draw(new Line2D.Float(sP.X + shift, sP.Y, sP.X + shift, sP.Y - (float)tickLen));
            } else {
                g.draw(new Line2D.Float(sP.X + shift, sP.Y, sP.X + shift, sP.Y + (float)tickLen));
                sP.Y += (float)tickLen;
            }
            sP.Y += 5.0f;
        } else {
            if (this.insideTick) {
                g.draw(new Line2D.Float(sP.X - (float)tickLen, sP.Y + shift, sP.X, sP.Y + shift));
            } else {
                g.draw(new Line2D.Float(sP.X, sP.Y + shift, sP.X + (float)tickLen, sP.Y + shift));
                sP.X += (float)tickLen;
            }
            sP.X += 5.0f;
        }
    }

    private void drawHorizontalBarLegend(Graphics2D g, LegendScheme aLS) {
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = Color.black;
        int bNum = aLS.getBreakNum();
        if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        if (this.autoTick) {
            int tickGap = this.getTickGap(g);
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum - 1;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                ++labNum;
            } else if (this.drawMinLabel) {
                sIdx = 0;
                labNum = bNum;
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                ColorBreak cb = aLS.getLegendBreaks().get(i);
                double v = Double.parseDouble(cb.getEndValue().toString());
                if (this.tickLocations.contains(v)) {
                    labelIdxs.add(i);
                    continue;
                }
                if (i != 0 || !this.tickLocations.contains(v = Double.parseDouble(cb.getStartValue().toString()))) continue;
                labelIdxs.add(i);
            }
        }
        this._hBarHeight = (float)this.legendWidth / (float)this.aspect;
        this._vBarWidth = (float)this.legendWidth / (float)bNum;
        aP.X = -this._vBarWidth / 2.0f;
        float y_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    y_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        for (int i = 0; i < bNum; ++i) {
            PointF[] Points;
            PolygonBreak aPGB;
            int idx = i;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case Polyline: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case Polygon: {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB.isDrawShape();
                    DrawFill = aPGB.isDrawFill();
                    FillColor = aPGB.getColor();
                    break;
                }
                case Image: {
                    ColorBreak aCB = aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            aP.X += this._vBarWidth;
            aP.Y = this._hBarHeight / 2.0f + y_shift;
            if (!DrawShape) continue;
            if (this.extendRect) {
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    PolygonBreak aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB2.setDrawOutline(false);
                    Draw.drawPolygonSymbol((PointF)aP.clone(), this._vBarWidth, this._hBarHeight, aPGB2, g);
                    continue;
                }
                Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, this._vBarWidth, this._hBarHeight, DrawFill, DrawOutline, g);
                continue;
            }
            float extendw = this._vBarWidth;
            if (this.autoExtendFrac) {
                extendw = this._hBarHeight;
            }
            if (i == 0) {
                Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = this._vBarWidth - extendw;
                Points[0].Y = aP.Y;
                Points[1] = new PointF();
                Points[1].X = this._vBarWidth;
                Points[1].Y = y_shift;
                Points[2] = new PointF();
                Points[2].X = this._vBarWidth;
                Points[2].Y = this._hBarHeight + y_shift;
                Points[3] = new PointF();
                Points[3].X = this._vBarWidth - extendw;
                Points[3].Y = aP.Y;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB.setDrawOutline(false);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (i == bNum - 1) {
                Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = (float)i * this._vBarWidth - 1.0f;
                Points[0].Y = this._hBarHeight + y_shift;
                Points[1] = new PointF();
                Points[1].X = (float)i * this._vBarWidth - 1.0f;
                Points[1].Y = y_shift;
                Points[2] = new PointF();
                Points[2].X = (float)i * this._vBarWidth + extendw;
                Points[2].Y = aP.Y;
                Points[3] = new PointF();
                Points[3].X = (float)i * this._vBarWidth - 1.0f;
                Points[3].Y = this._hBarHeight + y_shift;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB.setDrawOutline(false);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (aLS.getShapeType() == ShapeTypes.Polygon) {
                PolygonBreak aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                aPGB3.setDrawOutline(false);
                Draw.drawPolygonSymbol((PointF)aP.clone(), this._vBarWidth, this._hBarHeight, aPGB3, g);
                continue;
            }
            Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, this._vBarWidth, this._hBarHeight, DrawFill, DrawOutline, g);
        }
        g.setColor(Color.black);
        if (this.extendRect) {
            g.draw(new Rectangle2D.Float(0.0f, y_shift, this._vBarWidth * (float)bNum, this._hBarHeight));
        } else {
            float extendw = this._vBarWidth;
            if (this.autoExtendFrac) {
                extendw = this._hBarHeight;
            }
            Polygon p = new Polygon();
            p.addPoint((int)(this._vBarWidth - extendw), (int)(this._hBarHeight / 2.0f + y_shift));
            p.addPoint((int)this._vBarWidth, (int)y_shift);
            p.addPoint((int)(this._vBarWidth * (float)(bNum - 1)), (int)y_shift);
            p.addPoint((int)(this._vBarWidth * (float)(bNum - 1) + extendw), (int)(this._hBarHeight / 2.0f + y_shift));
            p.addPoint((int)(this._vBarWidth * (float)(bNum - 1)), (int)(this._hBarHeight + y_shift));
            p.addPoint((int)this._vBarWidth, (int)(this._hBarHeight + y_shift));
            g.drawPolygon(p);
        }
        aP.X = -this._vBarWidth / 2.0f;
        int tickLen = this.tickLength;
        if (this.insideTick && this._hBarHeight < (float)tickLen) {
            tickLen = (int)this._hBarHeight;
        }
        g.setFont(this.tickLabelFont);
        g.setColor(Color.black);
        int idx = 0;
        for (int i = 0; i < bNum; ++i) {
            String caption;
            aP.X += this._vBarWidth;
            aP.Y = this._hBarHeight / 2.0f + y_shift;
            if (!labelIdxs.contains(i)) continue;
            ColorBreak cb = aLS.getLegendBreaks().get(i);
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                caption = cb.getCaption();
            } else {
                caption = DataConvert.removeTailingZeros(cb.getEndValue().toString());
                if (!this.autoTick && this.tickLabels.size() > idx) {
                    caption = this.tickLabels.get(idx).getText();
                }
            }
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                sP.X = aP.X;
                sP.Y = aP.Y + this._hBarHeight / 2.0f + 5.0f;
                Draw.drawString(g, sP.X, sP.Y, caption, XAlign.CENTER, YAlign.TOP, this.tickLabelAngle, true);
            } else {
                sP.X = aP.X + this._vBarWidth / 2.0f;
                sP.Y = aP.Y + this._hBarHeight / 2.0f;
                PointF ssP = (PointF)sP.clone();
                if (this.autoTick) {
                    if (i < bNum - 1) {
                        this.drawTickLine(g, sP, tickLen, true, 0.0f);
                        Draw.drawString(g, sP.X, sP.Y, caption, XAlign.CENTER, YAlign.TOP, this.tickLabelAngle, true);
                        if (this.drawMinLabel && i == 0) {
                            this.drawTickLine(g, ssP, tickLen, true, -this._vBarWidth);
                            caption = DataConvert.removeTailingZeros(cb.getStartValue().toString());
                            Draw.drawString(g, ssP.X - this._vBarWidth, ssP.Y, caption, XAlign.CENTER, YAlign.TOP, this.tickLabelAngle, true);
                        }
                    } else if (this.drawMaxLabel) {
                        this.drawTickLine(g, sP, tickLen, true, 0.0f);
                        Draw.drawString(g, sP.X, sP.Y, caption, XAlign.CENTER, YAlign.TOP, this.tickLabelAngle, true);
                    }
                } else if (i == 0 && this.tickLocations.get(idx) == Double.parseDouble(cb.getStartValue().toString())) {
                    this.drawTickLine(g, sP, tickLen, true, -this._vBarWidth);
                    Draw.drawString(g, sP.X - this._vBarWidth, sP.Y, caption, XAlign.CENTER, YAlign.TOP, this.tickLabelAngle, true);
                } else {
                    this.drawTickLine(g, sP, tickLen, true, 0.0f);
                    Draw.drawString(g, sP.X, sP.Y, caption, XAlign.CENTER, YAlign.TOP, this.tickLabelAngle, true);
                }
            }
            ++idx;
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    this.x = (float)this.legendWidth * 0.5f;
                    this.y = 2.0f;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.CENTER, YAlign.TOP, this.label.isUseExternalFont());
                    break;
                }
                case "right": {
                    this.x = this.legendWidth + 5;
                    this.y = this._hBarHeight * 0.5f;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.LEFT, YAlign.CENTER, this.label.isUseExternalFont());
                    break;
                }
                case "left": {
                    this.x = -5.0f;
                    this.y = this._hBarHeight * 0.5f;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.RIGHT, YAlign.CENTER, this.label.isUseExternalFont());
                    break;
                }
                default: {
                    this.x = (float)this.legendWidth * 0.5f;
                    this.y = this.height - 2;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.CENTER, YAlign.BOTTOM, this.label.isUseExternalFont());
                }
            }
        }
    }

    private void drawVerticalBarLegend(Graphics2D g, LegendScheme aLS) {
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = Color.black;
        int bNum = aLS.getBreakNum();
        if (aLS.getLegendBreaks().get(bNum - 1).isNoData()) {
            --bNum;
        }
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        if (this.autoTick) {
            int tickGap = this.getTickGap(g);
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum - 1;
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                ++labNum;
            } else if (this.drawMinLabel) {
                sIdx = 0;
                labNum = bNum;
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                ColorBreak cb = aLS.getLegendBreaks().get(i);
                double v = Double.parseDouble(cb.getEndValue().toString());
                if (this.tickLocations.contains(v)) {
                    labelIdxs.add(i);
                    continue;
                }
                if (i != 0 || !this.tickLocations.contains(v = Double.parseDouble(cb.getStartValue().toString()))) continue;
                labelIdxs.add(i);
            }
        }
        this._vBarWidth = (float)this.legendHeight / (float)this.aspect;
        this._hBarHeight = (float)this.legendHeight / (float)bNum;
        aP.Y = (float)this.legendHeight + this._hBarHeight / 2.0f;
        float x_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "left": 
                case "in": {
                    x_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        for (int i = 0; i < bNum; ++i) {
            PolygonBreak aPGB;
            PointF[] Points;
            PolygonBreak aPGB2;
            int idx = i;
            switch (aLS.getShapeType()) {
                case Point: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case Polyline: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.getDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case Polygon: {
                    PolygonBreak aPGB3 = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB3.isDrawShape();
                    DrawFill = aPGB3.isDrawFill();
                    FillColor = aPGB3.getColor();
                    break;
                }
                case Image: {
                    ColorBreak aCB = aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            aP.X = this._vBarWidth / 2.0f + x_shift;
            aP.Y -= this._hBarHeight;
            if (!DrawShape) continue;
            if (this.extendRect) {
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB2.setDrawOutline(false);
                    Draw.drawPolygonSymbol((PointF)aP.clone(), this._vBarWidth, this._hBarHeight, aPGB2, g);
                    continue;
                }
                Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, this._vBarWidth, this._hBarHeight, DrawFill, DrawOutline, g);
                continue;
            }
            if (i == 0) {
                Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = aP.X;
                Points[0].Y = this.legendHeight;
                Points[1] = new PointF();
                Points[1].X = 0.0f;
                Points[1].Y = aP.Y - this._hBarHeight / 2.0f - 1.0f;
                Points[2] = new PointF();
                Points[2].X = this._vBarWidth;
                Points[2].Y = aP.Y - this._hBarHeight / 2.0f - 1.0f;
                Points[3] = new PointF();
                Points[3].X = aP.X;
                Points[3].Y = this.legendHeight;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB.setDrawOutline(false);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (i == bNum - 1) {
                Points = new PointF[4];
                Points[0] = new PointF();
                Points[0].X = 0.0f;
                Points[0].Y = this._hBarHeight;
                Points[1] = new PointF();
                Points[1].X = this._vBarWidth;
                Points[1].Y = this._hBarHeight;
                Points[2] = new PointF();
                Points[2].X = aP.X;
                Points[2].Y = 0.0f;
                Points[3] = new PointF();
                Points[3].X = 0.0f;
                Points[3].Y = this._hBarHeight;
                if (aLS.getShapeType() == ShapeTypes.Polygon) {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                    aPGB.setDrawOutline(false);
                    Draw.drawPolygon(Points, aPGB, g);
                    continue;
                }
                Draw.drawPolygon(Points, FillColor, OutlineColor, DrawFill, DrawOutline, g);
                continue;
            }
            if (aLS.getShapeType() == ShapeTypes.Polygon) {
                aPGB2 = (PolygonBreak)aLS.getLegendBreaks().get(idx).clone();
                aPGB2.setDrawOutline(false);
                Draw.drawPolygonSymbol((PointF)aP.clone(), this._vBarWidth, this._hBarHeight, aPGB2, g);
                continue;
            }
            Draw.drawPolygonSymbol((PointF)aP.clone(), FillColor, OutlineColor, this._vBarWidth, this._hBarHeight, DrawFill, DrawOutline, g);
        }
        g.setColor(Color.black);
        if (this.extendRect) {
            g.draw(new Rectangle2D.Float(x_shift, 0.0f, this._vBarWidth, this._hBarHeight * (float)bNum));
        } else {
            Polygon p = new Polygon();
            p.addPoint((int)(this._vBarWidth / 2.0f + x_shift), 0);
            p.addPoint((int)x_shift, (int)this._hBarHeight);
            p.addPoint((int)x_shift, (int)(this._hBarHeight * (float)(bNum - 1)));
            p.addPoint((int)(this._vBarWidth / 2.0f + x_shift), (int)(this._hBarHeight * (float)bNum));
            p.addPoint((int)(this._vBarWidth + x_shift), (int)(this._hBarHeight * (float)(bNum - 1)));
            p.addPoint((int)(this._vBarWidth + x_shift), (int)this._hBarHeight);
            g.drawPolygon(p);
        }
        aP.Y = (float)this.legendHeight + this._hBarHeight / 2.0f;
        int tickLen = this.tickLength;
        if (this.insideTick && this._vBarWidth < (float)tickLen) {
            tickLen = (int)this._vBarWidth;
        }
        g.setFont(this.tickLabelFont);
        int idx = 0;
        for (int i = 0; i < bNum; ++i) {
            String caption;
            aP.X = this._vBarWidth / 2.0f + x_shift;
            aP.Y -= this._hBarHeight;
            if (!labelIdxs.contains(i)) continue;
            ColorBreak cb = aLS.getLegendBreaks().get(i);
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                caption = cb.getCaption();
            } else {
                caption = DataConvert.removeTailingZeros(cb.getEndValue().toString());
                if (!this.autoTick && this.tickLabels.size() > idx) {
                    caption = this.tickLabels.get(idx).getText();
                }
            }
            if (aLS.getLegendType() == LegendType.UniqueValue) {
                sP.X = aP.X + this._vBarWidth / 2.0f + 5.0f;
                sP.Y = aP.Y;
                g.setColor(Color.black);
                Draw.drawString(g, sP.X, sP.Y, caption, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
            } else {
                sP.X = aP.X + this._vBarWidth / 2.0f;
                sP.Y = aP.Y - this._hBarHeight / 2.0f;
                PointF ssP = (PointF)sP.clone();
                if (this.autoTick) {
                    if (i < bNum - 1) {
                        this.drawTickLine(g, sP, tickLen, false, 0.0f);
                        Draw.drawString(g, sP.X, sP.Y, caption, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                        if (this.drawMinLabel && i == 0) {
                            this.drawTickLine(g, ssP, tickLen, false, this._hBarHeight);
                            caption = DataConvert.removeTailingZeros(cb.getStartValue().toString());
                            Draw.drawString(g, ssP.X, ssP.Y + this._hBarHeight, caption, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                        }
                    } else if (this.drawMaxLabel) {
                        this.drawTickLine(g, sP, tickLen, false, 0.0f);
                        Draw.drawString(g, sP.X, sP.Y, caption, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                    }
                } else if (i == 0 && this.tickLocations.get(idx) == Double.parseDouble(cb.getStartValue().toString())) {
                    this.drawTickLine(g, sP, tickLen, false, this._hBarHeight);
                    Draw.drawString(g, sP.X, sP.Y + this._hBarHeight, caption, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                } else {
                    this.drawTickLine(g, sP, tickLen, false, 0.0f);
                    Draw.drawString(g, sP.X, sP.Y, caption, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                }
            }
            ++idx;
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            Dimension dim = Draw.getStringDimension(this.label.getText(), g);
            switch (this.labelLocation) {
                case "top": {
                    this.x = 0.0f;
                    this.y = -5.0f;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.LEFT, YAlign.BOTTOM, this.label.isUseExternalFont());
                    break;
                }
                case "bottom": {
                    this.x = 0.0f;
                    this.y = this.legendHeight + 5;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.LEFT, YAlign.TOP, this.label.isUseExternalFont());
                    break;
                }
                case "left": 
                case "in": {
                    this.x = 0.0f;
                    this.y = (float)this.legendHeight * 0.5f;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.LEFT, YAlign.CENTER, 90.0f, this.label.isUseExternalFont());
                    break;
                }
                default: {
                    this.x = this.width - dim.height;
                    this.y = (float)this.legendHeight * 0.5f;
                    Draw.drawString(g, this.x, this.y, this.label.getText(), XAlign.LEFT, YAlign.CENTER, 90.0f, this.label.isUseExternalFont());
                }
            }
        }
    }

    @Override
    public Dimension getLegendDimension(Graphics2D g, Dimension limitDim) {
        if (this.legendScheme != null) {
            block0 : switch (this.orientation) {
                case VERTICAL: {
                    this.width = (int)((float)this.getTickWidth(g) + (float)limitDim.height * this.shrink / (float)this.aspect + 5.0f);
                    if (!this.insideTick) {
                        this.width += this.tickLength;
                    }
                    this.legendWidth = this.width;
                    this.legendHeight = this.height;
                    if (this.label == null) break;
                    g.setFont(this.label.getFont());
                    Dimension dim = Draw.getStringDimension(this.label.getText(), g);
                    switch (this.labelLocation) {
                        case "top": 
                        case "bottom": {
                            this.width = Math.max(this.width, dim.width);
                            break block0;
                        }
                    }
                    this.width += dim.height + 5;
                    break;
                }
                default: {
                    g.setFont(this.tickLabelFont);
                    this.height = (int)((float)this.getTickHeight(g) + (float)limitDim.width * this.shrink / (float)this.aspect + 5.0f);
                    if (!this.insideTick) {
                        this.height += this.tickLength;
                    }
                    this.legendWidth = this.width;
                    this.legendHeight = this.height;
                    if (this.label == null) break;
                    g.setFont(this.label.getFont());
                    Dimension dim = Draw.getStringDimension(this.label.getText(), g);
                    switch (this.labelLocation) {
                        case "right": 
                        case "left": {
                            break block0;
                        }
                    }
                    this.height += dim.height + 5;
                }
            }
        }
        return new Dimension(this.width, this.height);
    }
}

