/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.gui;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.meteoinfo.console.JConsole;
import org.meteoinfo.console.JavaCharStream;
import org.meteoinfo.laboratory.event.ConsoleExecEvent;
import org.meteoinfo.laboratory.event.IConsoleExecListener;
import org.meteoinfo.laboratory.gui.ConsoleColors;
import org.python.util.InteractiveConsole;

public class PythonInteractiveInterpreter
extends InteractiveConsole
implements Runnable {
    private Reader in;
    private PrintStream out;
    private PrintStream err;
    JConsole console;
    private final EventListenerList listeners = new EventListenerList();
    private ConsoleColors consoleColors;

    public PythonInteractiveInterpreter(JConsole console) {
        this.cflags.source_is_utf8 = true;
        this.console = console;
        this.in = console.getIn();
        this.out = console.getOut();
        this.err = console.getErr();
        this.setOut(this.out);
        this.setErr(this.err);
    }

    public JConsole getConsole() {
        return this.console;
    }

    public void setConsole(JConsole console) {
        this.console = console;
        this.in = console.getIn();
        this.out = console.getOut();
        this.err = console.getErr();
        this.setOut(this.out);
        this.setErr(this.err);
    }

    public void setConsoleColors(ConsoleColors value) {
        this.consoleColors = value;
    }

    public void upate() {
        this.console.updateOut();
        this.in = this.console.getIn();
        this.out = this.console.getOut();
        this.err = this.console.getErr();
        this.setOut(this.out);
        this.setErr(this.err);
    }

    public boolean isSourceUTF8() {
        return this.cflags.source_is_utf8;
    }

    public void setSourceUTF8(boolean value) {
        this.cflags.source_is_utf8 = value;
    }

    @Override
    public void run() {
        boolean eof = false;
        JavaCharStream stream = new JavaCharStream(this.in, 1, 1);
        String ps1 = ">>> ";
        String ps2 = "... ";
        this.console.print((Object)(PythonInteractiveInterpreter.getDefaultBanner() + "\n"), this.consoleColors.getPromptColor());
        this.console.print((Object)ps1, this.consoleColors.getPromptColor());
        boolean retVal = false;
        while (!eof) {
            this.console.setStyle(this.consoleColors.getCommandColor());
            System.out.flush();
            System.err.flush();
            Thread.yield();
            try {
                boolean eol = false;
                String line = "";
                while (!eol) {
                    char aChar = stream.readChar();
                    eol = aChar == '\n';
                    if (eol) continue;
                    line = line + aChar;
                }
                if (!retVal) {
                    line = line.trim();
                }
                if (line.equals(";")) {
                    line = "";
                }
                if (retVal = this.push(line)) {
                    this.out.print(ps2);
                    continue;
                }
                this.fireConsoleExecEvent();
            }
            catch (Exception e) {
                this.out.print(e.toString() + '\n');
                this.resetbuffer();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PythonInteractiveInterpreter.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.fireConsoleExecEvent();
            }
        }
    }

    public void execfile(InputStream s) {
        this.cflags.source_is_utf8 = false;
        super.execfile(s);
        this.cflags.source_is_utf8 = true;
        this.fireConsoleExecEvent();
    }

    public void execfile(String fn) {
        this.cflags.source_is_utf8 = false;
        super.execfile(fn);
        this.cflags.source_is_utf8 = true;
        this.fireConsoleExecEvent();
    }

    public void addConsoleExecListener(IConsoleExecListener listener) {
        this.listeners.add(IConsoleExecListener.class, listener);
    }

    public void removeConsoleExecListener(IConsoleExecListener listener) {
        this.listeners.remove(IConsoleExecListener.class, listener);
    }

    public void fireConsoleExecEvent() {
        this.fireConsoleExecEvent(new ConsoleExecEvent(this));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PythonInteractiveInterpreter.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.console.print((Object)">>> ", this.consoleColors.getPromptColor());
        this.console.setStyle(this.consoleColors.getCommandColor());
        this.console.setForeground(this.consoleColors.getCommandColor());
    }

    private void fireConsoleExecEvent(ConsoleExecEvent event) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = 0; i < ls.length; i += 2) {
            if (ls[i] != IConsoleExecListener.class) continue;
            ((IConsoleExecListener)ls[i + 1]).consoleExecEvent(event);
        }
    }
}

