/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.chart.jogl.GLChartPanel;
import org.meteoinfo.laboratory.gui.FrmMain;
import org.meteoinfo.laboratory.gui.PythonInteractiveInterpreter;
import org.meteoinfo.ui.ButtonTabComponent;

public class FigureDockable
extends DefaultSingleCDockable {
    private final JTabbedPane tabbedPanel;
    private FrmMain parent;
    private boolean doubleBuffer;

    public FigureDockable(final FrmMain parent, String id, String title, CAction ... actions) {
        super(id, title, actions);
        this.parent = parent;
        this.doubleBuffer = true;
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PythonInteractiveInterpreter interp = parent.getConsoleDockable().getInterpreter();
                if (FigureDockable.this.tabbedPanel.getTabCount() == 0) {
                    try {
                        interp.exec("mipylib.plotlib.miplot.g_figure = None");
                        interp.exec("mipylib.plotlib.miplot.gca = None");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    interp.set("cp", FigureDockable.this.getCurrentFigure());
                    interp.exec("mipylib.plotlib.miplot.g_figure = cp");
                    interp.exec("mipylib.plotlib.miplot.gca = None");
                }
            }
        });
        this.getContentPane().add(this.tabbedPanel);
        CButton button = new CButton();
        button.setText("Select");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/Arrow.png")));
        button.setTooltip("Select");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.SELECT);
                }
            }
        });
        this.addAction((CAction)button);
        this.addSeparator();
        button = new CButton();
        button.setText("Zoom In");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/TSB_ZoomIn.Image.png")));
        button.setTooltip("Zoom In");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.ZOOM_IN);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Zoom Out");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/TSB_ZoomOut.Image.png")));
        button.setTooltip("Zoom Out");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.ZOOM_OUT);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Pan");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/TSB_Pan.Image.png")));
        button.setTooltip("Pan");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.PAN);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Rotate");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/rotate_16.png")));
        button.setTooltip("Rotate");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.ROTATE);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Full Extent");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/TSB_FullExtent.Image.png")));
        button.setTooltip("Full Extent");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.onUndoZoomClick();
                }
            }
        });
        this.addAction((CAction)button);
        this.addSeparator();
        button = new CButton();
        button.setText("Identifer");
        button.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/information.png")));
        button.setTooltip("Identifer");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.IDENTIFER);
                }
            }
        });
        this.addAction((CAction)button);
        this.addSeparator();
    }

    public final IChartPanel addNewFigure(String title, final JPanel cp) {
        if (cp instanceof ChartPanel) {
            ((ChartPanel)cp).setDoubleBuffer(this.doubleBuffer);
        }
        JScrollPane sp = new JScrollPane(cp);
        this.tabbedPanel.add((Component)sp, title);
        this.tabbedPanel.setSelectedComponent(sp);
        ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPanel);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FigureDockable.this.removeFigure(cp);
            }
        });
        this.tabbedPanel.setTabComponentAt(this.tabbedPanel.indexOfComponent(sp), (Component)btc);
        return (IChartPanel)cp;
    }

    public final IChartPanel addFigure(final JPanel ncp) {
        if (ncp instanceof ChartPanel) {
            ((ChartPanel)ncp).setDoubleBuffer(this.doubleBuffer);
        }
        int idx = 1;
        if (this.tabbedPanel.getTabCount() > 0) {
            Object text;
            ArrayList<Integer> idxes = new ArrayList<Integer>();
            for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
                text = this.tabbedPanel.getTitleAt(i);
                String[] strs = ((String)text).split("\\s+");
                if (strs.length <= 1) continue;
                String idxStr = strs[strs.length - 1];
                try {
                    idx = Integer.parseInt(idxStr);
                    idxes.add(idx);
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(idxes);
            idx = 1;
            boolean isIn = false;
            text = idxes.iterator();
            while (text.hasNext()) {
                int i = (Integer)text.next();
                if (idx < i) {
                    isIn = true;
                    break;
                }
                ++idx;
            }
            if (!isIn) {
                idx = idxes.size() + 1;
            }
        }
        JScrollPane sp = new JScrollPane(ncp);
        this.tabbedPanel.add((Component)sp, "Figure " + String.valueOf(idx));
        this.tabbedPanel.setSelectedComponent(sp);
        ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPanel);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FigureDockable.this.removeFigure(ncp);
            }
        });
        this.tabbedPanel.setTabComponentAt(this.tabbedPanel.indexOfComponent(sp), (Component)btc);
        return (IChartPanel)ncp;
    }

    public void removeFigure(JPanel cp) {
        if (cp instanceof GLChartPanel) {
            ((GLChartPanel)cp).animator_stop();
        }
        JScrollPane sp = (JScrollPane)cp.getParent().getParent();
        if (this.tabbedPanel.getTabCount() > 0) {
            this.tabbedPanel.remove(sp);
        }
        PythonInteractiveInterpreter interp = this.parent.getConsoleDockable().getInterpreter();
        if (this.tabbedPanel.getTabCount() == 0) {
            try {
                interp.exec("mipylib.plotlib.miplot.chartpanel = None");
                interp.exec("mipylib.plotlib.miplot.c_plot = None");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            interp.set("cp", this.getCurrentFigure());
            interp.exec("mipylib.plotlib.miplot.chartpanel = cp");
            interp.exec("mipylib.plotlib.miplot.c_plot = None");
        }
    }

    public IChartPanel getCurrentFigure() {
        if (this.tabbedPanel.getTabCount() == 0) {
            return null;
        }
        JScrollPane sp = (JScrollPane)this.tabbedPanel.getSelectedComponent();
        return (IChartPanel)sp.getViewport().getView();
    }

    public ChartPanel getFigure(int idx) {
        if (this.tabbedPanel.getTabCount() > idx) {
            JScrollPane sp = (JScrollPane)this.tabbedPanel.getComponentAt(idx);
            return (ChartPanel)sp.getViewport().getView();
        }
        return null;
    }

    public int getFigureNumber() {
        return this.tabbedPanel.getTabCount();
    }

    public List<ChartPanel> getFigures() {
        ArrayList<ChartPanel> figures = new ArrayList<ChartPanel>();
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            figures.add(this.getFigure(i));
        }
        return figures;
    }

    public void setCurrentFigure(ChartPanel cp) {
        if (this.tabbedPanel.getTabCount() > 0) {
            JScrollPane sp = new JScrollPane((Component)cp);
            this.tabbedPanel.setComponentAt(this.tabbedPanel.getSelectedIndex(), sp);
        }
    }

    public void setDoubleBuffer(boolean doubleBuffer) {
        this.doubleBuffer = doubleBuffer;
        List<ChartPanel> figures = this.getFigures();
        for (ChartPanel figure : figures) {
            figure.setDoubleBuffer(this.doubleBuffer);
            figure.repaintNew();
        }
    }
}

