/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.pool;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.messaginghub.pooled.jms.JmsPoolMessageProducer;
import org.messaginghub.pooled.jms.JmsPoolQueueSender;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.JmsPoolTopicPublisher;
import org.messaginghub.pooled.jms.pool.PooledConnection;
import org.messaginghub.pooled.jms.util.LRUCache;

public final class PooledSessionHolder {
    private final PooledConnection connection;
    private final Session session;
    private final boolean useAnonymousProducer;
    private final int explicitProducerCacheSize;
    private volatile MessageProducer anonymousProducer;
    private volatile TopicPublisher anonymousPublisher;
    private volatile QueueSender anonymousSender;
    private final ProducerLRUCache<JmsPoolMessageProducer> cachedProducers;
    private final ProducerLRUCache<JmsPoolTopicPublisher> cachedPublishers;
    private final ProducerLRUCache<JmsPoolQueueSender> cachedSenders;

    public PooledSessionHolder(PooledConnection connection, Session session, boolean useAnonymousProducer, int namedProducerCacheSize) {
        this.connection = connection;
        this.session = session;
        this.useAnonymousProducer = useAnonymousProducer;
        this.explicitProducerCacheSize = namedProducerCacheSize;
        if (!useAnonymousProducer && namedProducerCacheSize > 0) {
            this.cachedProducers = new ProducerLRUCache(namedProducerCacheSize);
            this.cachedPublishers = new ProducerLRUCache(namedProducerCacheSize);
            this.cachedSenders = new ProducerLRUCache(namedProducerCacheSize);
        } else {
            this.cachedProducers = null;
            this.cachedPublishers = null;
            this.cachedSenders = null;
        }
    }

    public void close() throws JMSException {
        try {
            this.session.close();
        }
        finally {
            this.anonymousProducer = null;
            this.anonymousPublisher = null;
            this.anonymousSender = null;
            if (this.cachedProducers != null) {
                this.cachedProducers.clear();
            }
            if (this.cachedPublishers != null) {
                this.cachedPublishers.clear();
            }
            if (this.cachedSenders != null) {
                this.cachedSenders.clear();
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJmsPoolProducerClosed(JmsPoolMessageProducer producer, boolean force) throws JMSException {
        PooledSessionHolder pooledSessionHolder = this;
        synchronized (pooledSessionHolder) {
            MessageProducer delegate;
            if (!force) {
                try {
                    producer.getDelegate().getDestination();
                    if (this.isUseAnonymousProducer() || producer.isAnonymousProducer()) {
                        return;
                    }
                    if (producer.getRefCount().decrementAndGet() > 0) {
                        return;
                    }
                }
                catch (IllegalStateException jmsISE) {
                    producer.getRefCount().decrementAndGet();
                    force = true;
                }
                catch (Exception ambiguous) {
                    return;
                }
            }
            if ((delegate = producer.getDelegate()) == this.anonymousProducer) {
                this.anonymousProducer = null;
            } else if (delegate == this.anonymousPublisher) {
                this.anonymousPublisher = null;
            } else if (delegate == this.anonymousSender) {
                this.anonymousSender = null;
            }
            if (!producer.isAnonymousProducer()) {
                if (this.cachedProducers != null) {
                    this.cachedProducers.remove(producer.getDelegateDestination());
                }
                if (this.cachedPublishers != null) {
                    this.cachedPublishers.remove(producer.getDelegateDestination());
                }
                if (this.cachedSenders != null) {
                    this.cachedSenders.remove(producer.getDelegateDestination());
                }
            }
            delegate.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsPoolMessageProducer getOrCreateProducer(JmsPoolSession jmsPoolSession, Destination destination) throws JMSException {
        MessageProducer delegate = null;
        AtomicInteger refCount = null;
        PooledSessionHolder pooledSessionHolder = this;
        synchronized (pooledSessionHolder) {
            if (this.isUseAnonymousProducer() || destination == null) {
                delegate = this.anonymousProducer;
                if (delegate == null) {
                    delegate = this.anonymousProducer = this.session.createProducer(null);
                    refCount = new AtomicInteger(0);
                }
            } else if (this.explicitProducerCacheSize > 0) {
                JmsPoolMessageProducer cached = (JmsPoolMessageProducer)this.cachedProducers.get(destination);
                if (cached == null) {
                    delegate = this.session.createProducer(destination);
                    refCount = new AtomicInteger(1);
                    cached = new JmsPoolMessageProducer(jmsPoolSession, delegate, destination, refCount);
                    this.cachedProducers.put(destination, cached);
                } else {
                    delegate = cached.getDelegate();
                    refCount = cached.getRefCount();
                }
                refCount.incrementAndGet();
            } else {
                delegate = this.session.createProducer(destination);
                refCount = new AtomicInteger(1);
            }
        }
        return new JmsPoolMessageProducer(jmsPoolSession, delegate, destination, refCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsPoolTopicPublisher getOrCreatePublisher(JmsPoolSession jmsPoolSession, Topic topic) throws JMSException {
        TopicPublisher delegate = null;
        AtomicInteger refCount = null;
        PooledSessionHolder pooledSessionHolder = this;
        synchronized (pooledSessionHolder) {
            if (this.isUseAnonymousProducer() || topic == null) {
                delegate = this.anonymousPublisher;
                if (delegate == null) {
                    delegate = this.anonymousPublisher = ((TopicSession)this.session).createPublisher(null);
                    refCount = new AtomicInteger(0);
                }
            } else if (this.explicitProducerCacheSize > 0) {
                JmsPoolTopicPublisher cached = (JmsPoolTopicPublisher)this.cachedPublishers.get(topic);
                if (cached == null) {
                    delegate = ((TopicSession)this.session).createPublisher(topic);
                    refCount = new AtomicInteger(1);
                    cached = new JmsPoolTopicPublisher(jmsPoolSession, delegate, (Destination)topic, refCount);
                    this.cachedPublishers.put(topic, cached);
                } else {
                    delegate = (TopicPublisher)cached.getDelegate();
                    refCount = cached.getRefCount();
                }
                refCount.incrementAndGet();
            } else {
                delegate = ((TopicSession)this.session).createPublisher(topic);
                refCount = new AtomicInteger(1);
            }
        }
        return new JmsPoolTopicPublisher(jmsPoolSession, delegate, (Destination)topic, refCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsPoolQueueSender getOrCreateSender(JmsPoolSession jmsPoolSession, Queue queue) throws JMSException {
        QueueSender delegate = null;
        AtomicInteger refCount = null;
        PooledSessionHolder pooledSessionHolder = this;
        synchronized (pooledSessionHolder) {
            if (this.isUseAnonymousProducer() || queue == null) {
                delegate = this.anonymousSender;
                if (delegate == null) {
                    delegate = this.anonymousSender = ((QueueSession)this.session).createSender(null);
                    refCount = new AtomicInteger(0);
                }
            } else if (this.explicitProducerCacheSize > 0) {
                JmsPoolQueueSender cached = (JmsPoolQueueSender)this.cachedSenders.get(queue);
                if (cached == null) {
                    delegate = ((QueueSession)this.session).createSender(queue);
                    refCount = new AtomicInteger(1);
                    cached = new JmsPoolQueueSender(jmsPoolSession, delegate, (Destination)queue, refCount);
                    this.cachedSenders.put(queue, cached);
                } else {
                    delegate = (QueueSender)cached.getDelegate();
                    refCount = cached.getRefCount();
                }
                refCount.incrementAndGet();
            } else {
                delegate = ((QueueSession)this.session).createSender(queue);
                refCount = new AtomicInteger(1);
            }
        }
        return new JmsPoolQueueSender(jmsPoolSession, delegate, (Destination)queue, refCount);
    }

    public PooledConnection getConnection() {
        return this.connection;
    }

    public boolean isUseAnonymousProducer() {
        return this.useAnonymousProducer;
    }

    public String toString() {
        return this.session.toString();
    }

    private static class ProducerLRUCache<E>
    extends LRUCache<Destination, E> {
        private static final long serialVersionUID = -1L;

        public ProducerLRUCache(int maximumCacheSize) {
            super(maximumCacheSize);
        }

        @Override
        protected void onCacheEviction(Map.Entry<Destination, E> eldest) {
            JmsPoolMessageProducer producer = (JmsPoolMessageProducer)eldest.getValue();
            try {
                producer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

