/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.commons.pool2.KeyedObjectPool;
import org.messaginghub.pooled.jms.JmsPoolMessageConsumer;
import org.messaginghub.pooled.jms.JmsPoolMessageProducer;
import org.messaginghub.pooled.jms.JmsPoolQueueBrowser;
import org.messaginghub.pooled.jms.JmsPoolQueueReceiver;
import org.messaginghub.pooled.jms.JmsPoolQueueSender;
import org.messaginghub.pooled.jms.JmsPoolSessionEventListener;
import org.messaginghub.pooled.jms.JmsPoolTopicPublisher;
import org.messaginghub.pooled.jms.JmsPoolTopicSubscriber;
import org.messaginghub.pooled.jms.pool.PooledSessionHolder;
import org.messaginghub.pooled.jms.pool.PooledSessionKey;
import org.messaginghub.pooled.jms.util.JMSExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPoolSession
implements Session,
TopicSession,
QueueSession,
XASession,
AutoCloseable {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmsPoolSession.class);
    private final PooledSessionKey key;
    private final KeyedObjectPool<PooledSessionKey, PooledSessionHolder> sessionPool;
    private final CopyOnWriteArrayList<JmsPoolMessageProducer> producers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JmsPoolMessageConsumer> consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JmsPoolQueueBrowser> browsers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JmsPoolSessionEventListener> sessionEventListeners = new CopyOnWriteArrayList();
    private final AtomicBoolean closed = new AtomicBoolean();
    private PooledSessionHolder sessionHolder;
    private boolean transactional = true;
    private boolean ignoreClose;
    private boolean isXa;

    public JmsPoolSession(PooledSessionKey key, PooledSessionHolder sessionHolder, KeyedObjectPool<PooledSessionKey, PooledSessionHolder> sessionPool, boolean transactional) {
        this.key = key;
        this.sessionHolder = sessionHolder;
        this.sessionPool = sessionPool;
        this.transactional = transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        if (this.ignoreClose) {
            return;
        }
        if (this.closed.compareAndSet(false, true)) {
            boolean invalidate = false;
            try {
                this.getInternalSession().setMessageListener(null);
                for (MessageConsumer messageConsumer : this.consumers) {
                    messageConsumer.close();
                }
                for (QueueBrowser queueBrowser : this.browsers) {
                    queueBrowser.close();
                }
                for (MessageProducer messageProducer : this.producers) {
                    messageProducer.close();
                }
                this.consumers.clear();
                this.producers.clear();
                this.browsers.clear();
                if (this.transactional && !this.isXa) {
                    try {
                        this.getInternalSession().rollback();
                    }
                    catch (JMSException e) {
                        invalidate = true;
                        LOG.warn("Caught exception trying rollback() when putting session back into the pool, will invalidate. " + e, (Throwable)e);
                    }
                }
            }
            catch (JMSException ex) {
                invalidate = true;
                LOG.warn("Caught exception trying close() when putting session back into the pool, will invalidate. " + ex, (Throwable)ex);
            }
            finally {
                this.consumers.clear();
                this.browsers.clear();
                for (JmsPoolSessionEventListener jmsPoolSessionEventListener : this.sessionEventListeners) {
                    jmsPoolSessionEventListener.onSessionClosed(this);
                }
                this.sessionEventListeners.clear();
            }
            if (invalidate) {
                if (this.sessionHolder != null) {
                    try {
                        this.sessionHolder.close();
                    }
                    catch (JMSException e1) {
                        LOG.trace("Ignoring exception on close as discarding session: " + e1, (Throwable)e1);
                    }
                }
                try {
                    this.sessionPool.invalidateObject((Object)this.key, (Object)this.sessionHolder);
                }
                catch (Exception e) {
                    LOG.trace("Ignoring exception on invalidateObject as discarding session: " + e, (Throwable)e);
                }
            } else {
                try {
                    this.sessionPool.returnObject((Object)this.key, (Object)this.sessionHolder);
                }
                catch (Exception e) {
                    IllegalStateException illegalStateException = new IllegalStateException(e.toString());
                    illegalStateException.initCause((Throwable)e);
                    throw illegalStateException;
                }
            }
            this.sessionHolder = null;
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        TemporaryQueue result = this.getInternalSession().createTemporaryQueue();
        for (JmsPoolSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryQueueCreate(result);
        }
        return result;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        TemporaryTopic result = this.getInternalSession().createTemporaryTopic();
        for (JmsPoolSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryTopicCreate(result);
        }
        return result;
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getInternalSession().createQueue(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getInternalSession().createTopic(s);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getInternalSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getInternalSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getInternalSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getInternalSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getInternalSession().createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getInternalSession().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getInternalSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getInternalSession().createTextMessage(s);
    }

    public void unsubscribe(String s) throws JMSException {
        this.getInternalSession().unsubscribe(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getInternalSession().getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        return this.getInternalSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getInternalSession().recover();
    }

    public void commit() throws JMSException {
        this.getInternalSession().commit();
    }

    public void rollback() throws JMSException {
        this.getInternalSession().rollback();
    }

    public XAResource getXAResource() {
        PooledSessionHolder session;
        try {
            session = this.safeGetSessionHolder();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
        if (session.getSession() instanceof XASession) {
            return ((XASession)session.getSession()).getXAResource();
        }
        return null;
    }

    public Session getSession() {
        return this;
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getInternalSession().getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getInternalSession().setMessageListener(messageListener);
    }

    public void run() {
        PooledSessionHolder session;
        try {
            session = this.safeGetSessionHolder();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
        if (session != null) {
            session.getSession().run();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue, selector));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination));
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector));
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector, noLocal));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, selector));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, name, selector, noLocal));
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.addTopicSubscriber(((TopicSession)this.getInternalSession()).createSubscriber(topic));
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return this.addTopicSubscriber(((TopicSession)this.getInternalSession()).createSubscriber(topic, selector, local));
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.addQueueReceiver(((QueueSession)this.getInternalSession()).createReceiver(queue));
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        return this.addQueueReceiver(((QueueSession)this.getInternalSession()).createReceiver(queue, selector));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        PooledSessionHolder state = this.safeGetSessionHolder();
        state.getConnection().checkClientJMSVersionSupport(2, 0);
        return this.addConsumer(state.getSession().createSharedConsumer(topic, sharedSubscriptionName));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        PooledSessionHolder state = this.safeGetSessionHolder();
        state.getConnection().checkClientJMSVersionSupport(2, 0);
        return this.addConsumer(state.getSession().createSharedConsumer(topic, sharedSubscriptionName, messageSelector));
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        PooledSessionHolder state = this.safeGetSessionHolder();
        state.getConnection().checkClientJMSVersionSupport(2, 0);
        return this.addConsumer(state.getSession().createDurableConsumer(topic, name));
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        PooledSessionHolder state = this.safeGetSessionHolder();
        state.getConnection().checkClientJMSVersionSupport(2, 0);
        return this.addConsumer(state.getSession().createDurableConsumer(topic, name, messageSelector, noLocal));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        PooledSessionHolder state = this.safeGetSessionHolder();
        state.getConnection().checkClientJMSVersionSupport(2, 0);
        return this.addConsumer(state.getSession().createSharedDurableConsumer(topic, name));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        PooledSessionHolder state = this.safeGetSessionHolder();
        state.getConnection().checkClientJMSVersionSupport(2, 0);
        return this.addConsumer(state.getSession().createSharedDurableConsumer(topic, name, messageSelector));
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        JmsPoolMessageProducer result = this.safeGetSessionHolder().getOrCreateProducer(this, destination);
        this.producers.add(result);
        return result;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        JmsPoolQueueSender result = this.safeGetSessionHolder().getOrCreateSender(this, queue);
        this.producers.add(result);
        return result;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        JmsPoolTopicPublisher result = this.safeGetSessionHolder().getOrCreatePublisher(this, topic);
        this.producers.add(result);
        return result;
    }

    public void addSessionEventListener(JmsPoolSessionEventListener listener) throws JMSException {
        this.checkClosed();
        if (!this.sessionEventListeners.contains(listener)) {
            this.sessionEventListeners.add(listener);
        }
    }

    public Session getInternalSession() throws JMSException {
        return this.safeGetSessionHolder().getSession();
    }

    public void setIsXa(boolean isXa) {
        this.isXa = isXa;
    }

    public boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    public void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + " { " + this.safeGetSessionHolder() + " }";
        }
        catch (JMSException e) {
            return this.getClass().getSimpleName() + " { null }";
        }
    }

    protected void onConsumerClose(JmsPoolMessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    protected void onQueueBrowserClose(JmsPoolQueueBrowser browser) {
        this.browsers.remove(browser);
    }

    protected void onMessageProducerClosed(JmsPoolMessageProducer producer, boolean force) throws JMSException {
        this.producers.remove(producer);
        this.safeGetSessionHolder().onJmsPoolProducerClosed(producer, force);
    }

    protected void checkClientJMSVersionSupport(int major, int minor) throws JMSException {
        this.safeGetSessionHolder().getConnection().checkClientJMSVersionSupport(major, minor);
    }

    protected boolean isJMSVersionSupported(int major, int minor) throws JMSException {
        return this.safeGetSessionHolder().getConnection().isJMSVersionSupported(major, minor);
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        browser = new JmsPoolQueueBrowser(this, browser);
        this.browsers.add((JmsPoolQueueBrowser)browser);
        return browser;
    }

    private MessageConsumer addConsumer(MessageConsumer consumer) {
        consumer = new JmsPoolMessageConsumer(this, consumer);
        this.consumers.add((JmsPoolMessageConsumer)consumer);
        return consumer;
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        subscriber = new JmsPoolTopicSubscriber(this, subscriber);
        this.consumers.add((JmsPoolMessageConsumer)subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        receiver = new JmsPoolQueueReceiver(this, receiver);
        this.consumers.add((JmsPoolMessageConsumer)receiver);
        return receiver;
    }

    private PooledSessionHolder safeGetSessionHolder() throws JMSException {
        PooledSessionHolder sessionHolder = this.sessionHolder;
        if (sessionHolder == null) {
            throw new IllegalStateException("The session has already been closed");
        }
        return sessionHolder;
    }
}

