/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.messaginghub.pooled.jms.JmsPoolSession;

public class JmsPoolQueueBrowser
implements QueueBrowser,
AutoCloseable {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final JmsPoolSession session;
    private final QueueBrowser delegate;

    public JmsPoolQueueBrowser(JmsPoolSession session, QueueBrowser delegate) {
        this.session = session;
        this.delegate = delegate;
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return this.delegate.getQueue();
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.delegate.getMessageSelector();
    }

    public Enumeration<?> getEnumeration() throws JMSException {
        this.checkClosed();
        return this.delegate.getEnumeration();
    }

    @Override
    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.session.onQueueBrowserClose(this);
            this.delegate.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.delegate + " }";
    }

    public QueueBrowser getQueueBrowser() throws JMSException {
        this.checkClosed();
        return this.delegate;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The QueueBrowser is closed");
        }
    }
}

