/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.meruvian.yama.core.commons.FileInfo;
import org.meruvian.yama.core.role.Role;
import org.meruvian.yama.core.role.UserRole;
import org.meruvian.yama.core.role.UserRoleRepository;
import org.meruvian.yama.core.user.User;
import org.meruvian.yama.core.user.UserRepository;
import org.meruvian.yama.webapi.service.UserService;
import org.meruvian.yama.webapi.service.commons.FileInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RestUserService
implements UserService,
EnvironmentAware {
    private final Logger log = LoggerFactory.getLogger(RestUserService.class);
    @Inject
    private UserRepository userRepository;
    @Inject
    private UserRoleRepository userRoleRepository;
    @Inject
    private PasswordEncoder passwordEncoder;
    @Inject
    private FileInfoService fileInfoService;
    private String uploadPath;
    private String profilePicPath;
    @Context
    private HttpServletRequest request;

    public void setEnvironment(Environment environment) {
        this.uploadPath = environment.getProperty("upload.path.profile_pic");
        this.profilePicPath = environment.getProperty("default.profile_pic.path");
    }

    public User getUserByUsernameOrId(String username) {
        User u = (User)this.userRepository.findById(username);
        u = u == null ? this.userRepository.findByUsername(username) : u;
        u = u == null ? this.userRepository.findByEmail(username) : u;
        return u;
    }

    public Page<User> findUserByKeyword(String keyword, Pageable pageable) {
        return this.userRepository.findByUsername(keyword, 1, pageable);
    }

    @Transactional
    public void removeUser(String username) {
        this.getUserByUsernameOrId(username).getLogInformation().setActiveFlag(0);
    }

    @Transactional
    public User saveUser(User user) {
        if (StringUtils.isNotBlank((CharSequence)user.getPassword())) {
            user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        } else {
            user.setPassword(this.passwordEncoder.encode((CharSequence)RandomStringUtils.random((int)9)));
        }
        return (User)this.userRepository.save((Object)user);
    }

    @Transactional
    public User updateUser(String username, User user) {
        User u = this.getUserByUsernameOrId(username);
        u.setUsername(user.getUsername());
        u.setName(user.getName());
        u.setEmail(user.getEmail());
        u.setAddress(user.getAddress());
        return u;
    }

    @Transactional
    public User updateUserPassword(String username, User user) {
        User u = this.getUserByUsernameOrId(username);
        u.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        return u;
    }

    @Transactional
    public boolean addRoleToUser(String username, String roleId) {
        User u = this.getUserByUsernameOrId(username);
        for (UserRole ur : u.getRoles()) {
            if (!ur.getRole().getId().equals(roleId)) continue;
            return false;
        }
        UserRole userRole = new UserRole();
        userRole.setUser(u);
        Role role = new Role();
        role.setId(roleId);
        userRole.setRole(role);
        this.userRoleRepository.save((Object)userRole);
        return true;
    }

    @Transactional
    public boolean removeRoleFromUser(String username, String roleId) {
        User u = this.getUserByUsernameOrId(username);
        UserRole ur = this.userRoleRepository.findByUserIdAndRoleId(u.getId(), roleId);
        this.userRoleRepository.delete((Object)ur);
        return true;
    }

    @Transactional
    public boolean removeAllRoleFromUser(String username) {
        User u = this.getUserByUsernameOrId(username);
        this.userRoleRepository.delete((Iterable)u.getRoles());
        return true;
    }

    public Page<Role> findRoleByUser(String username, Pageable pageable) {
        User u = this.getUserByUsernameOrId(username);
        Page userRoles = this.userRoleRepository.findByUserId(u.getId(), pageable);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (UserRole ur : userRoles) {
            roles.add(ur.getRole());
        }
        return new PageImpl(roles, pageable, userRoles.getTotalElements());
    }

    public Response getUserPhoto(String username) throws FileNotFoundException {
        String filePath;
        File file;
        User u = this.getUserByUsernameOrId(username);
        FileInfo info = u.getFileInfo();
        if (info != null && (file = new File(filePath = info.getPath())).exists()) {
            return Response.ok((Object)file, (String)info.getContentType()).build();
        }
        return Response.seeOther((URI)URI.create(this.profilePicPath)).build();
    }

    @Transactional
    public boolean updateUserPhoto(String username, InputStream inputStream) throws IOException {
        User u = this.getUserByUsernameOrId(username);
        String uploadPath = StringUtils.join((Object[])new String[]{this.uploadPath, "/", u.getId()});
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDataBlob(inputStream);
        fileInfo.setContentType(this.request.getContentType());
        fileInfo = this.fileInfoService.saveFileInfo(uploadPath, fileInfo);
        u.setFileInfo(fileInfo);
        return true;
    }
}

