/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service;

import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.meruvian.yama.core.application.Application;
import org.meruvian.yama.core.application.ApplicationRepository;
import org.meruvian.yama.webapi.service.ApplicationService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RestApplicationService
implements ApplicationService {
    @Inject
    private ApplicationRepository applicationRepository;

    public Application getApplicationById(String id) {
        return (Application)this.applicationRepository.findById(id);
    }

    @Transactional
    public Application saveApplication(Application application) {
        application.setId(null);
        application.setSecret(RandomStringUtils.randomAlphanumeric((int)64));
        application.getAuthorizedGrantTypes().add(Application.GrantType.REFRESH_TOKEN.toString());
        return (Application)this.applicationRepository.save((Object)application);
    }

    @Transactional
    public Application updateApplication(Application application) {
        Application a = this.getApplicationById(application.getId());
        a.setDisplayName(application.getDisplayName());
        a.setNamespace(application.getNamespace());
        a.setDomain(application.getDomain());
        a.setSite(application.getSite());
        a.setRegisteredRedirectUri(application.getRegisteredRedirectUri());
        a.setAutoApprove(Boolean.valueOf(application.isAutoApprove()));
        a.setAuthorizedGrantTypes(application.getAuthorizedGrantTypes());
        return a;
    }

    @Transactional
    public Application generateNewSecret(String id) {
        Application a = this.getApplicationById(id);
        a.setSecret(RandomStringUtils.randomAlphanumeric((int)64));
        return a;
    }

    @Transactional
    public void removeApplication(String id) {
        this.getApplicationById(id).getLogInformation().setActiveFlag(0);
    }

    public Page<Application> findApplicationByName(String name, Pageable pageable) {
        return this.applicationRepository.findByName(name, 1, pageable);
    }
}

