/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service.commons;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.meruvian.yama.core.commons.FileInfo;
import org.meruvian.yama.core.commons.FileInfoRepository;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FileInfoService
implements EnvironmentAware {
    @Inject
    private FileInfoRepository fileInfoRepository;
    private String uploadBasePath;

    @Transactional
    public FileInfo saveFileInfo(String path, FileInfo fileInfo) throws IOException {
        FileInfo info = new FileInfo();
        info.setPath(StringUtils.join((Object[])new String[]{this.uploadBasePath, path}));
        info.setOriginalName(StringUtils.defaultString((String)fileInfo.getOriginalName()));
        File file = new File(info.getPath());
        if (!file.exists()) {
            file.mkdirs();
        }
        info.setContentType(fileInfo.getContentType());
        info = (FileInfo)this.fileInfoRepository.save((Object)info);
        info.setPath(StringUtils.join((Object[])new String[]{info.getPath(), "/", info.getId()}));
        if (StringUtils.isBlank((CharSequence)fileInfo.getOriginalName())) {
            info.setOriginalName(info.getId());
        }
        InputStream inputStream = fileInfo.getDataBlob();
        FileOutputStream outputStream = new FileOutputStream(info.getPath());
        info.setSize((long)IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream));
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return info;
    }

    public void setEnvironment(Environment environment) {
        this.uploadBasePath = environment.getProperty("upload.path.base");
    }
}

