/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.meruvian.yama.core.role.Role;
import org.meruvian.yama.core.user.User;
import org.meruvian.yama.webapi.interceptor.DetectCurrentUser;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

@Path(value="/api/users")
@Produces(value={"application/json"})
@DetectCurrentUser
public interface UserService {
    @GET
    @Path(value="/{username}")
    public User getUserByUsernameOrId(@PathParam(value="username") String var1);

    @GET
    public Page<User> findUserByKeyword(@QueryParam(value="q") @DefaultValue(value="") String var1, Pageable var2);

    @DELETE
    @Path(value="/{username}")
    public void removeUser(@PathParam(value="username") String var1);

    @POST
    public User saveUser(User var1);

    @PUT
    @Path(value="/{username}")
    public User updateUser(@PathParam(value="username") String var1, User var2);

    @POST
    @Path(value="/{username}/password")
    public User updateUserPassword(@PathParam(value="username") String var1, User var2);

    @GET
    @Path(value="/{username}/roles")
    public Page<Role> findRoleByUser(@PathParam(value="username") String var1, Pageable var2);

    @PUT
    @Path(value="/{username}/roles/{roleId}")
    public boolean addRoleToUser(@PathParam(value="username") String var1, @PathParam(value="roleId") String var2);

    @DELETE
    @Path(value="/{username}/roles/{roleId}")
    public boolean removeRoleFromUser(@PathParam(value="username") String var1, @PathParam(value="roleId") String var2);

    @DELETE
    @Path(value="/{username}/roles")
    public boolean removeAllRoleFromUser(@PathParam(value="username") String var1);

    @GET
    @Path(value="/{username}/photo")
    @Produces(value={"application/octet-stream"})
    public Response getUserPhoto(@PathParam(value="username") String var1) throws FileNotFoundException;

    @POST
    @Consumes(value={"image/*"})
    @Path(value="/{username}/photo")
    public boolean updateUserPhoto(@PathParam(value="username") String var1, InputStream var2) throws IOException;
}

