/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.config;

import javax.inject.Inject;
import org.meruvian.yama.core.user.User;
import org.meruvian.yama.social.connection.SocialConnectionRepository;
import org.meruvian.yama.social.core.SocialConnectionService;
import org.meruvian.yama.social.core.SocialService;
import org.meruvian.yama.social.core.SocialServiceLocator;
import org.meruvian.yama.social.core.SocialServiceRegistry;
import org.meruvian.yama.social.core.SocialUsersConnectionService;
import org.meruvian.yama.social.facebook.FacebookService;
import org.meruvian.yama.social.google.GooglePlusService;
import org.meruvian.yama.social.mervid.MervidService;
import org.meruvian.yama.social.mervid.connect.MervidConnectionFactory;
import org.meruvian.yama.web.SessionCredentials;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.Environment;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.social.google.connect.GoogleConnectionFactory;

@Configuration
public class SocialConfig {
    @Inject
    private Environment env;

    @Bean
    public SocialServiceLocator socialServiceLocator() {
        SocialServiceRegistry registry = new SocialServiceRegistry();
        registry.addSocialService((SocialService)this.facebookService());
        registry.addSocialService((SocialService)this.googlePlusService());
        registry.addSocialService((SocialService)this.mervidService());
        return registry;
    }

    @Bean
    public SocialUsersConnectionService usersConnectionRepository(SocialServiceLocator locator, SocialConnectionRepository repository, ConnectionSignUp connectionSignUp) {
        SocialUsersConnectionService s = new SocialUsersConnectionService(locator, repository);
        s.setConnectionSignUp(connectionSignUp);
        return s;
    }

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public SocialConnectionService connectionRepository(SocialUsersConnectionService usersConnectionRepository) {
        User user = SessionCredentials.getCurrentUser();
        if (user == null) {
            return null;
        }
        return usersConnectionRepository.createConnectionRepository(user.getId());
    }

    @Bean
    public FacebookService facebookService() {
        String appId = this.env.getProperty("social.facebook.appId");
        String appSecret = this.env.getProperty("social.facebook.appSecret");
        String redirectUri = this.env.getProperty("social.facebook.redirectUri");
        String scope = this.env.getProperty("social.facebook.scope");
        FacebookConnectionFactory factory = new FacebookConnectionFactory(appId, appSecret);
        FacebookService facebookService = new FacebookService((OAuth2ConnectionFactory)factory);
        facebookService.setRedirectUri(redirectUri);
        facebookService.setScope(scope);
        return facebookService;
    }

    @Bean
    public GooglePlusService googlePlusService() {
        String appId = this.env.getProperty("social.google.appId");
        String appSecret = this.env.getProperty("social.google.appSecret");
        String redirectUri = this.env.getProperty("social.google.redirectUri");
        String scope = this.env.getProperty("social.google.scope");
        GoogleConnectionFactory factory = new GoogleConnectionFactory(appId, appSecret);
        GooglePlusService gPlusService = new GooglePlusService((OAuth2ConnectionFactory)factory);
        gPlusService.setRedirectUri(redirectUri);
        gPlusService.setScope(scope);
        return gPlusService;
    }

    @Bean
    public MervidService mervidService() {
        String appId = this.env.getProperty("social.mervid.appId");
        String appSecret = this.env.getProperty("social.mervid.appSecret");
        String redirectUri = this.env.getProperty("social.mervid.redirectUri");
        String scope = this.env.getProperty("social.mervid.scope");
        MervidConnectionFactory factory = new MervidConnectionFactory(appId, appSecret);
        MervidService mervidService = new MervidService((OAuth2ConnectionFactory)factory);
        mervidService.setRedirectUri(redirectUri);
        mervidService.setScope(scope);
        return mervidService;
    }
}

