/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.i18n.openlocationcode;

import com.google.openlocationcode.OpenLocationCode;
import java.net.URI;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.meeuw.i18n.regions.Region;

public class OpenLocation
implements Region,
Comparable<OpenLocation> {
    private final OpenLocationCode code;

    OpenLocation(OpenLocationCode code) {
        this.code = code;
    }

    public String toString() {
        return this.getCode();
    }

    public String getCode() {
        return this.code.getCode();
    }

    public int getLength() {
        char ch;
        int notPaddedLength = 0;
        String c = this.getCode();
        for (int i = 0; i < c.length() && (ch = c.charAt(i)) != '0' && ch != '+'; ++i) {
            ++notPaddedLength;
        }
        return notPaddedLength / 2;
    }

    public URI getPlusURL() {
        return URI.create("https://plus.codes/" + this.getCode());
    }

    public OpenLocationCode getOpenLocationCode() {
        return this.code;
    }

    public @Nullable Locale toLocale() {
        return null;
    }

    public Region.Type getType() {
        return Region.Type.UNDEFINED;
    }

    public String getName() {
        return this.code.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenLocation location = (OpenLocation)o;
        return this.code.equals((Object)location.code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @Override
    public int compareTo(OpenLocation o) {
        return this.getCode().compareTo(o.getCode());
    }
}

