/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.text.TextUtils;
import android.util.Log;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.matrix.olm.OlmException;

public class OlmUtility {
    private static final String LOG_TAG = "OlmUtility";
    public static final int RANDOM_KEY_SIZE = 32;
    private long mNativeId;

    public OlmUtility() throws OlmException {
        this.initUtility();
    }

    private void initUtility() throws OlmException {
        try {
            this.mNativeId = this.createUtilityJni();
        }
        catch (Exception e) {
            throw new OlmException(500, e.getMessage());
        }
    }

    private native long createUtilityJni();

    public void releaseUtility() {
        if (0L != this.mNativeId) {
            this.releaseUtilityJni();
        }
        this.mNativeId = 0L;
    }

    private native void releaseUtilityJni();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void verifyEd25519Signature(String aSignature, String aFingerprintKey, String aMessage) throws OlmException {
        messageBuffer = null;
        try {
            if (TextUtils.isEmpty((CharSequence)aSignature) || TextUtils.isEmpty((CharSequence)aFingerprintKey) || TextUtils.isEmpty((CharSequence)aMessage)) {
                Log.e((String)"OlmUtility", (String)"## verifyEd25519Signature(): invalid input parameters");
                errorMessage = "JAVA sanity check failure - invalid input parameters";
            } else {
                messageBuffer = aMessage.getBytes("UTF-8");
                errorMessage = this.verifyEd25519SignatureJni(aSignature.getBytes("UTF-8"), aFingerprintKey.getBytes("UTF-8"), messageBuffer);
            }
            ** if (messageBuffer == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                Log.e((String)"OlmUtility", (String)("## verifyEd25519Signature(): failed " + e.getMessage()));
                errorMessage = e.getMessage();
                ** if (messageBuffer == null) goto lbl-1000
            }
            catch (Throwable var7_7) {
                if (messageBuffer != null) {
                    Arrays.fill(messageBuffer, (byte)0);
                }
                throw var7_7;
            }
lbl-1000:
            // 1 sources

            {
                Arrays.fill(messageBuffer, (byte)0);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Arrays.fill(messageBuffer, (byte)0);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
            throw new OlmException(501, errorMessage);
        }
    }

    private native String verifyEd25519SignatureJni(byte[] var1, byte[] var2, byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sha256(String aMessageToHash) {
        String hashRetValue = null;
        if (null != aMessageToHash) {
            byte[] messageBuffer = null;
            try {
                messageBuffer = aMessageToHash.getBytes("UTF-8");
                hashRetValue = new String(this.sha256Jni(messageBuffer), "UTF-8");
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## sha256(): failed " + e.getMessage()));
            }
            finally {
                if (null != messageBuffer) {
                    Arrays.fill(messageBuffer, (byte)0);
                }
            }
        }
        return hashRetValue;
    }

    private native byte[] sha256Jni(byte[] var1);

    public static byte[] getRandomKey() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] buffer = new byte[32];
        secureRandom.nextBytes(buffer);
        for (int i = 0; i < 32; ++i) {
            buffer[i] = (byte)(buffer[i] & 0x7F);
        }
        return buffer;
    }

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public static Map<String, String> toStringMap(JSONObject jsonObject) {
        if (null != jsonObject) {
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                try {
                    Object value = jsonObject.get(key);
                    if (value instanceof String) {
                        map.put(key, (String)value);
                        continue;
                    }
                    Log.e((String)LOG_TAG, (String)("## toStringMap(): unexpected type " + value.getClass()));
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)("## toStringMap(): failed " + e.getMessage()));
                }
            }
            return map;
        }
        return null;
    }

    public static Map<String, Map<String, String>> toStringMapMap(JSONObject jsonObject) {
        if (null != jsonObject) {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            Iterator keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                try {
                    Object value = jsonObject.get(key);
                    if (value instanceof JSONObject) {
                        map.put(key, OlmUtility.toStringMap((JSONObject)value));
                        continue;
                    }
                    Log.e((String)LOG_TAG, (String)("## toStringMapMap(): unexpected type " + value.getClass()));
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)("## toStringMapMap(): failed " + e.getMessage()));
                }
            }
            return map;
        }
        return null;
    }
}

