/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.json.JSONObject;
import org.matrix.olm.CommonSerializeUtils;
import org.matrix.olm.OlmException;
import org.matrix.olm.OlmSession;
import org.matrix.olm.OlmUtility;

public class OlmAccount
extends CommonSerializeUtils
implements Serializable {
    private static final long serialVersionUID = 3497486121598434824L;
    private static final String LOG_TAG = "OlmAccount";
    public static final String JSON_KEY_ONE_TIME_KEY = "curve25519";
    public static final String JSON_KEY_IDENTITY_KEY = "curve25519";
    public static final String JSON_KEY_FINGER_PRINT_KEY = "ed25519";
    private transient long mNativeId;

    public OlmAccount() throws OlmException {
        try {
            this.mNativeId = this.createNewAccountJni();
        }
        catch (Exception e) {
            throw new OlmException(10, e.getMessage());
        }
    }

    private native long createNewAccountJni();

    long getOlmAccountId() {
        return this.mNativeId;
    }

    public void releaseAccount() {
        if (0L != this.mNativeId) {
            this.releaseAccountJni();
        }
        this.mNativeId = 0L;
    }

    private native void releaseAccountJni();

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public Map<String, String> identityKeys() throws OlmException {
        byte[] identityKeysBuffer;
        JSONObject identityKeysJsonObj = null;
        try {
            identityKeysBuffer = this.identityKeysJni();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## identityKeys(): Failure - " + e.getMessage()));
            throw new OlmException(102, e.getMessage());
        }
        if (null != identityKeysBuffer) {
            try {
                identityKeysJsonObj = new JSONObject(new String(identityKeysBuffer, "UTF-8"));
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## identityKeys(): Exception - Msg=" + e.getMessage()));
            }
        } else {
            Log.e((String)LOG_TAG, (String)"## identityKeys(): Failure - identityKeysJni()=null");
        }
        return OlmUtility.toStringMap(identityKeysJsonObj);
    }

    private native byte[] identityKeysJni();

    public long maxOneTimeKeys() {
        return this.maxOneTimeKeysJni();
    }

    private native long maxOneTimeKeysJni();

    public void generateOneTimeKeys(int aNumberOfKeys) throws OlmException {
        try {
            this.generateOneTimeKeysJni(aNumberOfKeys);
        }
        catch (Exception e) {
            throw new OlmException(103, e.getMessage());
        }
    }

    private native void generateOneTimeKeysJni(int var1);

    public Map<String, Map<String, String>> oneTimeKeys() throws OlmException {
        byte[] oneTimeKeysBuffer;
        JSONObject oneTimeKeysJsonObj = null;
        try {
            oneTimeKeysBuffer = this.oneTimeKeysJni();
        }
        catch (Exception e) {
            throw new OlmException(104, e.getMessage());
        }
        if (null != oneTimeKeysBuffer) {
            try {
                oneTimeKeysJsonObj = new JSONObject(new String(oneTimeKeysBuffer, "UTF-8"));
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## oneTimeKeys(): Exception - Msg=" + e.getMessage()));
            }
        } else {
            Log.e((String)LOG_TAG, (String)"## oneTimeKeys(): Failure - identityKeysJni()=null");
        }
        return OlmUtility.toStringMapMap(oneTimeKeysJsonObj);
    }

    private native byte[] oneTimeKeysJni();

    public void removeOneTimeKeys(OlmSession aSession) throws OlmException {
        if (null != aSession) {
            try {
                this.removeOneTimeKeysJni(aSession.getOlmSessionId());
            }
            catch (Exception e) {
                throw new OlmException(105, e.getMessage());
            }
        }
    }

    private native void removeOneTimeKeysJni(long var1);

    public void markOneTimeKeysAsPublished() throws OlmException {
        try {
            this.markOneTimeKeysAsPublishedJni();
        }
        catch (Exception e) {
            throw new OlmException(106, e.getMessage());
        }
    }

    private native void markOneTimeKeysAsPublishedJni();

    public String signMessage(String aMessage) throws OlmException {
        String result = null;
        if (null != aMessage) {
            byte[] utf8String = null;
            try {
                byte[] signedMessage;
                utf8String = aMessage.getBytes("UTF-8");
                if (null != utf8String && null != (signedMessage = this.signMessageJni(utf8String))) {
                    result = new String(signedMessage, "UTF-8");
                }
            }
            catch (Exception e) {
                throw new OlmException(107, e.getMessage());
            }
            finally {
                if (null != utf8String) {
                    Arrays.fill(utf8String, (byte)0);
                }
            }
        }
        return result;
    }

    private native byte[] signMessageJni(byte[] var1);

    private void writeObject(ObjectOutputStream aOutStream) throws IOException {
        this.serialize(aOutStream);
    }

    private void readObject(ObjectInputStream aInStream) throws Exception {
        this.deserialize(aInStream);
    }

    @Override
    protected byte[] serialize(byte[] aKey, StringBuffer aErrorMsg) {
        byte[] pickleRetValue = null;
        if (null == aErrorMsg) {
            Log.e((String)LOG_TAG, (String)"## serialize(): invalid parameter - aErrorMsg=null");
        } else if (null == aKey) {
            aErrorMsg.append("Invalid input parameters in serializeDataWithKey()");
        } else {
            aErrorMsg.setLength(0);
            try {
                pickleRetValue = this.serializeJni(aKey);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## serialize() failed " + e.getMessage()));
                aErrorMsg.append(e.getMessage());
            }
        }
        return pickleRetValue;
    }

    private native byte[] serializeJni(byte[] var1);

    @Override
    protected void deserialize(byte[] aSerializedData, byte[] aKey) throws Exception {
        String errorMsg = null;
        try {
            if (null == aSerializedData || null == aKey) {
                Log.e((String)LOG_TAG, (String)"## deserialize(): invalid input parameters");
                errorMsg = "invalid input parameters";
            } else {
                this.mNativeId = this.deserializeJni(aSerializedData, aKey);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## deserialize() failed " + e.getMessage()));
            errorMsg = e.getMessage();
        }
        if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
            this.releaseAccount();
            throw new OlmException(101, errorMsg);
        }
    }

    private native long deserializeJni(byte[] var1, byte[] var2);

    public byte[] pickle(byte[] aKey, StringBuffer aErrorMsg) {
        return this.serialize(aKey, aErrorMsg);
    }

    public void unpickle(byte[] aSerializedData, byte[] aKey) throws Exception {
        this.deserialize(aSerializedData, aKey);
    }

    public void generateFallbackKey() throws OlmException {
        try {
            this.generateFallbackKeyJni();
        }
        catch (Exception e) {
            throw new OlmException(108, e.getMessage());
        }
    }

    private native void generateFallbackKeyJni();

    public Map<String, Map<String, String>> fallbackKey() throws OlmException {
        byte[] fallbackKeyBuffer;
        JSONObject fallbackKeyJsonObj = null;
        try {
            fallbackKeyBuffer = this.fallbackKeyJni();
        }
        catch (Exception e) {
            throw new OlmException(109, e.getMessage());
        }
        if (null != fallbackKeyBuffer) {
            try {
                fallbackKeyJsonObj = new JSONObject(new String(fallbackKeyBuffer, "UTF-8"));
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## fallbackKey(): Exception - Msg=" + e.getMessage()));
            }
        } else {
            Log.e((String)LOG_TAG, (String)"## fallbackKey(): Failure - identityKeysJni()=null");
        }
        return OlmUtility.toStringMapMap(fallbackKeyJsonObj);
    }

    private native byte[] fallbackKeyJni();
}

