/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.matrix.olm.OlmException;
import org.matrix.olm.OlmUtility;

abstract class CommonSerializeUtils {
    private static final String LOG_TAG = "CommonSerializeUtils";

    CommonSerializeUtils() {
    }

    protected void serialize(ObjectOutputStream aOutStream) throws IOException {
        aOutStream.defaultWriteObject();
        byte[] key = OlmUtility.getRandomKey();
        StringBuffer errorMsg = new StringBuffer();
        byte[] pickledData = this.serialize(key, errorMsg);
        if (null == pickledData) {
            throw new OlmException(100, String.valueOf(errorMsg));
        }
        aOutStream.writeObject(new String(key, "UTF-8"));
        aOutStream.writeObject(new String(pickledData, "UTF-8"));
    }

    protected void deserialize(ObjectInputStream aInStream) throws Exception {
        aInStream.defaultReadObject();
        String keyAsString = (String)aInStream.readObject();
        String pickledDataAsString = (String)aInStream.readObject();
        try {
            byte[] key = keyAsString.getBytes("UTF-8");
            byte[] pickledData = pickledDataAsString.getBytes("UTF-8");
            this.deserialize(pickledData, key);
        }
        catch (Exception e) {
            throw new OlmException(101, e.getMessage());
        }
        Log.d((String)LOG_TAG, (String)"## deserializeObject(): success");
    }

    protected abstract byte[] serialize(byte[] var1, StringBuffer var2);

    protected abstract void deserialize(byte[] var1, byte[] var2) throws Exception;
}

