/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.util.Log;
import java.util.Arrays;
import org.matrix.olm.OlmException;

public class OlmPkSigning {
    private static final String LOG_TAG = "OlmPkSigning";
    private transient long mNativeId;

    public OlmPkSigning() throws OlmException {
        try {
            this.mNativeId = this.createNewPkSigningJni();
        }
        catch (Exception e) {
            throw new OlmException(800, e.getMessage());
        }
    }

    private native long createNewPkSigningJni();

    private native void releasePkSigningJni();

    public void releaseSigning() {
        if (0L != this.mNativeId) {
            this.releasePkSigningJni();
        }
        this.mNativeId = 0L;
    }

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public static native int seedLength();

    public static byte[] generateSeed() throws OlmException {
        try {
            return OlmPkSigning.generateSeedJni();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## generateSeed(): failed " + e.getMessage()));
            throw new OlmException(801, e.getMessage());
        }
    }

    public static native byte[] generateSeedJni();

    public String initWithSeed(byte[] seed) throws OlmException {
        try {
            byte[] pubKey = this.setKeyFromSeedJni(seed);
            return new String(pubKey, "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## initWithSeed(): failed " + e.getMessage()));
            throw new OlmException(802, e.getMessage());
        }
    }

    public native byte[] setKeyFromSeedJni(byte[] var1);

    public String sign(String aMessage) throws OlmException {
        if (null == aMessage) {
            return null;
        }
        byte[] messageBuffer = null;
        try {
            messageBuffer = aMessage.getBytes("UTF-8");
            byte[] signature = this.pkSignJni(messageBuffer);
            String string = new String(signature, "UTF-8");
            return string;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## pkSign(): failed " + e.getMessage()));
            throw new OlmException(803, e.getMessage());
        }
        finally {
            if (null != messageBuffer) {
                Arrays.fill(messageBuffer, (byte)0);
            }
        }
    }

    private native byte[] pkSignJni(byte[] var1);
}

