/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.matrix.olm.CommonSerializeUtils;
import org.matrix.olm.OlmException;

public class OlmOutboundGroupSession
extends CommonSerializeUtils
implements Serializable {
    private static final long serialVersionUID = -3133097431283604416L;
    private static final String LOG_TAG = "OlmOutboundGroupSession";
    private transient long mNativeId;

    public OlmOutboundGroupSession() throws OlmException {
        try {
            this.mNativeId = this.createNewSessionJni();
        }
        catch (Exception e) {
            throw new OlmException(300, e.getMessage());
        }
    }

    private native long createNewSessionJni();

    public void releaseSession() {
        if (0L != this.mNativeId) {
            this.releaseSessionJni();
        }
        this.mNativeId = 0L;
    }

    private native void releaseSessionJni();

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public String sessionIdentifier() throws OlmException {
        try {
            return new String(this.sessionIdentifierJni(), "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## sessionIdentifier() failed " + e.getMessage()));
            throw new OlmException(302, e.getMessage());
        }
    }

    private native byte[] sessionIdentifierJni();

    public int messageIndex() {
        return this.messageIndexJni();
    }

    private native int messageIndexJni();

    public String sessionKey() throws OlmException {
        try {
            byte[] sessionKeyBuffer = this.sessionKeyJni();
            String ret = new String(sessionKeyBuffer, "UTF-8");
            Arrays.fill(sessionKeyBuffer, (byte)0);
            return ret;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## sessionKey() failed " + e.getMessage()));
            throw new OlmException(303, e.getMessage());
        }
    }

    private native byte[] sessionKeyJni();

    public String encryptMessage(String aClearMsg) throws OlmException {
        String retValue = null;
        if (!TextUtils.isEmpty((CharSequence)aClearMsg)) {
            try {
                byte[] clearMsgBuffer = aClearMsg.getBytes("UTF-8");
                byte[] encryptedBuffer = this.encryptMessageJni(clearMsgBuffer);
                Arrays.fill(clearMsgBuffer, (byte)0);
                if (null != encryptedBuffer) {
                    retValue = new String(encryptedBuffer, "UTF-8");
                }
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## encryptMessage() failed " + e.getMessage()));
                throw new OlmException(304, e.getMessage());
            }
        }
        return retValue;
    }

    private native byte[] encryptMessageJni(byte[] var1);

    private void writeObject(ObjectOutputStream aOutStream) throws IOException {
        this.serialize(aOutStream);
    }

    private void readObject(ObjectInputStream aInStream) throws Exception {
        this.deserialize(aInStream);
    }

    @Override
    protected byte[] serialize(byte[] aKey, StringBuffer aErrorMsg) {
        byte[] pickleRetValue = null;
        if (null == aErrorMsg) {
            Log.e((String)LOG_TAG, (String)"## serialize(): invalid parameter - aErrorMsg=null");
        } else if (null == aKey) {
            aErrorMsg.append("Invalid input parameters in serialize()");
        } else {
            try {
                pickleRetValue = this.serializeJni(aKey);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## serialize(): failed " + e.getMessage()));
                aErrorMsg.append(e.getMessage());
            }
        }
        return pickleRetValue;
    }

    private native byte[] serializeJni(byte[] var1);

    @Override
    protected void deserialize(byte[] aSerializedData, byte[] aKey) throws Exception {
        String errorMsg = null;
        try {
            if (null == aSerializedData || null == aKey) {
                Log.e((String)LOG_TAG, (String)"## deserialize(): invalid input parameters");
                errorMsg = "invalid input parameters";
            } else {
                this.mNativeId = this.deserializeJni(aSerializedData, aKey);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## deserialize() failed " + e.getMessage()));
            errorMsg = e.getMessage();
        }
        if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
            this.releaseSession();
            throw new OlmException(101, errorMsg);
        }
    }

    private native long deserializeJni(byte[] var1, byte[] var2);
}

