/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;

public class Parameter<T>
implements org.mariadb.jdbc.client.util.Parameter {
    public static final Parameter<?> NULL_PARAMETER = new Parameter(null, (Object)null){

        @Override
        public int getBinaryEncodeType() {
            return DataType.VARCHAR.get();
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };
    protected final Codec<T> codec;
    protected final T value;
    protected final Long length;

    public Parameter(Codec<T> codec, T value) {
        this.codec = codec;
        this.value = value;
        this.length = null;
    }

    public Parameter(Codec<T> codec, T value, Long length) {
        this.codec = codec;
        this.value = value;
        this.length = length;
    }

    @Override
    public void encodeText(Writer encoder, Context context) throws IOException, SQLException {
        this.codec.encodeText(encoder, context, this.value, null, this.length);
    }

    @Override
    public void encodeBinary(Writer encoder) throws IOException, SQLException {
        this.codec.encodeBinary(encoder, this.value, null, this.length);
    }

    @Override
    public void encodeLongData(Writer encoder) throws IOException, SQLException {
        this.codec.encodeLongData(encoder, this.value, this.length);
    }

    @Override
    public byte[] encodeData() throws IOException, SQLException {
        return this.codec.encodeData(this.value, this.length);
    }

    @Override
    public boolean canEncodeLongData() {
        return this.codec.canEncodeLongData();
    }

    @Override
    public int getBinaryEncodeType() {
        return this.codec.getBinaryEncodeType();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }
}

