/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.ClientImpl;
import org.mariadb.jdbc.client.ClientReplayImpl;
import org.mariadb.jdbc.client.MultiPrimaryClient;
import org.mariadb.jdbc.client.MultiPrimaryReplicaClient;
import org.mariadb.jdbc.pool.Pools;
import org.mariadb.jdbc.util.VersionFactory;

public final class Driver
implements java.sql.Driver {
    public static Connection connect(Configuration configuration) throws SQLException {
        Client client;
        ReentrantLock lock = new ReentrantLock();
        switch (configuration.haMode()) {
            case LOADBALANCE: 
            case SEQUENTIAL: {
                client = new MultiPrimaryClient(configuration, lock);
                break;
            }
            case REPLICATION: {
                client = new MultiPrimaryReplicaClient(configuration, lock);
                break;
            }
            default: {
                HostAddress hostAddress = configuration.addresses().isEmpty() ? null : configuration.addresses().get(0);
                client = configuration.transactionReplay() ? new ClientReplayImpl(configuration, hostAddress, lock, false) : new ClientImpl(configuration, hostAddress, lock, false);
            }
        }
        return new Connection(configuration, lock, client);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        Configuration configuration = Configuration.parse(url, props);
        if (configuration != null) {
            if (configuration.pool()) {
                return Pools.retrievePool(configuration).getPoolConnection().getConnection();
            }
            return Driver.connect(configuration);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return Configuration.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Configuration conf = Configuration.parse(url, info);
        if (conf == null) {
            return new DriverPropertyInfo[0];
        }
        Properties propDesc = new Properties();
        try (InputStream inputStream2 = Driver.class.getClassLoader().getResourceAsStream("driver.properties");){
            propDesc.load(inputStream2);
        }
        catch (IOException inputStream2) {
            // empty catch block
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        for (Field field : Configuration.Builder.class.getDeclaredFields()) {
            if (field.getName().startsWith("_")) continue;
            try {
                Field fieldConf = Configuration.class.getDeclaredField(field.getName());
                fieldConf.setAccessible(true);
                Object obj = fieldConf.get(conf);
                String value = obj == null ? null : obj.toString();
                DriverPropertyInfo propertyInfo = new DriverPropertyInfo(field.getName(), value);
                propertyInfo.description = value == null ? "" : (String)propDesc.get(field.getName());
                propertyInfo.required = false;
                props.add(propertyInfo);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return props.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return VersionFactory.getInstance().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return VersionFactory.getInstance().getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

