/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol.tls;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.Utils;

public class HostnameVerifierImpl
implements HostnameVerifier {
    private static Logger logger = LoggerFactory.getLogger(HostnameVerifierImpl.class);

    private static boolean matchDns(String hostname, String tlsDnsPattern) throws SSLException {
        boolean hostIsIp = Utils.isIPv4(hostname) || Utils.isIPv6(hostname);
        StringTokenizer hostnameSt = new StringTokenizer(hostname.toLowerCase(), ".");
        StringTokenizer templateSt = new StringTokenizer(tlsDnsPattern.toLowerCase(), ".");
        if (hostnameSt.countTokens() != templateSt.countTokens()) {
            return false;
        }
        try {
            while (hostnameSt.hasMoreTokens()) {
                if (HostnameVerifierImpl.matchWildCards(hostIsIp, hostnameSt.nextToken(), templateSt.nextToken())) continue;
                return false;
            }
        }
        catch (SSLException exception) {
            throw new SSLException("host \"" + hostname + "\" doesn't correspond to certificate CN \"" + tlsDnsPattern + "\" : wildcards not possible for IPs");
        }
        return true;
    }

    private static boolean matchWildCards(boolean hostIsIp, String hostnameToken, String tlsDnsToken) throws SSLException {
        int wildcardIndex = tlsDnsToken.indexOf("*");
        if (wildcardIndex != -1) {
            if (hostIsIp) {
                throw new SSLException("WildCards not possible when using IP's");
            }
            boolean first = true;
            String afterWildcard = tlsDnsToken;
            while (wildcardIndex != -1) {
                String beforeWildcard = afterWildcard.substring(0, wildcardIndex);
                afterWildcard = afterWildcard.substring(wildcardIndex + 1);
                int beforeStartIdx = hostnameToken.indexOf(beforeWildcard);
                if (beforeStartIdx == -1 || first && beforeStartIdx != 0) {
                    return false;
                }
                first = false;
                hostnameToken = hostnameToken.substring(beforeStartIdx + beforeWildcard.length());
                wildcardIndex = afterWildcard.indexOf("*");
            }
            return hostnameToken.endsWith(afterWildcard);
        }
        return hostnameToken.equals(tlsDnsToken);
    }

    static String extractCommonName(String principal) throws SSLException {
        if (principal == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(principal);
            for (Rdn rdn : ldapName.getRdns()) {
                Object obj;
                if (!rdn.getType().equalsIgnoreCase("CN") || (obj = rdn.getValue()) == null) continue;
                return obj.toString();
            }
            return null;
        }
        catch (InvalidNameException e) {
            throw new SSLException("DN value \"" + principal + "\" is invalid");
        }
    }

    private static String normaliseAddress(String hostname) {
        try {
            if (hostname == null) {
                return hostname;
            }
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unexpected) {
            return hostname;
        }
    }

    private SubjectAltNames getSubjectAltNames(X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> entries = cert.getSubjectAlternativeNames();
        SubjectAltNames subjectAltNames = new SubjectAltNames();
        if (entries != null) {
            for (List<?> entry : entries) {
                String altNameIp;
                String altNameDns;
                if (entry.size() < 2) continue;
                int type = (Integer)entry.get(0);
                if (type == 2 && (altNameDns = (String)entry.get(1)) != null) {
                    String normalizedSubjectAlt = altNameDns.toLowerCase(Locale.ROOT);
                    subjectAltNames.add(new GeneralName(normalizedSubjectAlt, Extension.DNS));
                }
                if (type != 7 || (altNameIp = (String)entry.get(1)) == null) continue;
                subjectAltNames.add(new GeneralName(altNameIp, Extension.IP));
            }
        }
        return subjectAltNames;
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate cert = (X509Certificate)certs[0];
            this.verify(host, cert);
            return true;
        }
        catch (SSLException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), ex);
            }
            return false;
        }
    }

    public void verify(String host, X509Certificate cert) throws SSLException {
        String normalizedCn;
        try {
            SubjectAltNames subjectAltNames = this.getSubjectAltNames(cert);
            if (!subjectAltNames.isEmpty()) {
                if (Utils.isIPv4(host)) {
                    for (GeneralName entry : subjectAltNames.getGeneralNames()) {
                        if (entry.extension != Extension.IP || !host.equals(entry.value)) continue;
                        return;
                    }
                    throw new SSLException("No IPv4 corresponding to host \"" + host + "\" in certificate alt-names " + subjectAltNames.toString());
                }
                if (Utils.isIPv6(host)) {
                    String normalisedHost = HostnameVerifierImpl.normaliseAddress(host);
                    for (GeneralName entry : subjectAltNames.getGeneralNames()) {
                        String normalizedSubjectAlt;
                        if (entry.extension != Extension.IP || Utils.isIPv4(entry.value) || !normalisedHost.equals(normalizedSubjectAlt = HostnameVerifierImpl.normaliseAddress(entry.value))) continue;
                        return;
                    }
                    throw new SSLException("No IPv6 corresponding to host \"" + host + "\" in certificate alt-names " + subjectAltNames.toString());
                }
                String normalizedHost = host.toLowerCase(Locale.ROOT);
                for (GeneralName entry : subjectAltNames.getGeneralNames()) {
                    String normalizedSubjectAlt;
                    if (entry.extension != Extension.DNS || !HostnameVerifierImpl.matchDns(normalizedHost, normalizedSubjectAlt = entry.value.toLowerCase(Locale.ROOT))) continue;
                    return;
                }
                throw new SSLException("DNS host \"" + host + "\" not found in certificate alt-names " + subjectAltNames.toString());
            }
        }
        catch (CertificateParsingException subjectAltNames) {
            // empty catch block
        }
        X500Principal subjectPrincipal = cert.getSubjectX500Principal();
        String cn = HostnameVerifierImpl.extractCommonName(subjectPrincipal.getName("RFC2253"));
        if (cn == null) {
            throw new SSLException("CN not found in certificate principal \"" + subjectPrincipal + "\"");
        }
        String normalizedHost = host.toLowerCase(Locale.ROOT);
        if (!HostnameVerifierImpl.matchDns(normalizedHost, normalizedCn = cn.toLowerCase(Locale.ROOT))) {
            throw new SSLException("host \"" + normalizedHost + "\" doesn't correspond to certificate CN \"" + normalizedCn + "\"");
        }
    }

    private class SubjectAltNames {
        List<GeneralName> generalNames = new ArrayList<GeneralName>();

        private SubjectAltNames() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("certificate SubjectAltNames[");
            boolean first = true;
            for (GeneralName generalName : this.generalNames) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(generalName.toString());
            }
            sb.append("]");
            return sb.toString();
        }

        public List<GeneralName> getGeneralNames() {
            return this.generalNames;
        }

        public void add(GeneralName generalName) {
            this.generalNames.add(generalName);
        }

        public boolean isEmpty() {
            return this.generalNames.isEmpty();
        }
    }

    private class GeneralName {
        String value;
        Extension extension;

        public GeneralName(String value, Extension extension) {
            this.value = value;
            this.extension = extension;
        }

        public String toString() {
            return "{\"" + this.value + "\"|" + (Object)((Object)this.extension) + "}";
        }
    }

    private static enum Extension {
        DNS,
        IP;

    }
}

