/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import org.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;

public class SendOldPasswordAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    public SendOldPasswordAuthPacket(String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException {
        if (this.password == null || this.password.equals("")) {
            pos.writeEmptyPacket(this.packSeq);
            return;
        }
        pos.startPacket(this.packSeq);
        byte[] seed = Utils.copyWithLength(this.authData, 8);
        pos.write(this.cryptOldFormatPassword(this.password, new String(seed)));
        pos.write(0);
        pos.flush();
    }

    private byte[] cryptOldFormatPassword(String password, String seed) {
        byte[] result = new byte[seed.length()];
        if (password == null || password.length() == 0) {
            return new byte[0];
        }
        long[] seedHash = this.hashPassword(seed);
        long[] passHash = this.hashPassword(password);
        RandStruct randSeed = new RandStruct(seedHash[0] ^ passHash[0], seedHash[1] ^ passHash[1]);
        for (int i = 0; i < seed.length(); ++i) {
            result[i] = (byte)Math.floor(this.random(randSeed) * 31.0 + 64.0);
        }
        byte extra = (byte)Math.floor(this.random(randSeed) * 31.0);
        int i = 0;
        while (i < seed.length()) {
            int n = i++;
            result[n] = (byte)(result[n] ^ extra);
        }
        return result;
    }

    private double random(RandStruct rand) {
        rand.seed1 = (rand.seed1 * 3L + rand.seed2) % rand.maxValue;
        rand.seed2 = (rand.seed1 + rand.seed2 + 33L) % rand.maxValue;
        double d = rand.seed1;
        rand.getClass();
        return d / 1.073741823E9;
    }

    private long[] hashPassword(String password) {
        long nr = 1345345333L;
        long nr2 = 305419889L;
        long add = 7L;
        for (int i = 0; i < password.length(); ++i) {
            char currChar = password.charAt(i);
            if (currChar == ' ' || currChar == '\t') continue;
            long tmp = currChar;
            nr ^= ((nr & 0x3FL) + add) * tmp + (nr << 8);
            nr2 += nr2 << 8 ^ nr;
            add += tmp;
        }
        return new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
    }

    private class RandStruct {
        final long maxValue = 0x3FFFFFFFL;
        long seed1;
        long seed2;

        public RandStruct(long seed1, long seed2) {
            this.seed1 = seed1 % 0x3FFFFFFFL;
            this.seed2 = seed2 % 0x3FFFFFFFL;
        }
    }
}

