/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class ComStmtExecute
implements InterfaceSendPacket {
    private final int parameterCount;
    private final ParameterHolder[] parameters;
    private final int statementId;
    private ColumnType[] parameterTypeHeader;
    private final byte cursorFlag;

    public ComStmtExecute(int statementId, ParameterHolder[] parameters, int parameterCount, ColumnType[] parameterTypeHeader, byte cursorFlag) {
        this.parameterCount = parameterCount;
        this.parameters = parameters;
        this.statementId = statementId;
        this.parameterTypeHeader = parameterTypeHeader;
        this.cursorFlag = cursorFlag;
    }

    public static void writeCmd(int statementId, ParameterHolder[] parameters, int parameterCount, ColumnType[] parameterTypeHeader, PacketOutputStream pos, byte cursorFlag) throws IOException {
        pos.write(23);
        pos.writeInt(statementId);
        pos.write(cursorFlag);
        pos.writeInt(1);
        if (parameterCount > 0) {
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                if (!parameters[i2].isNullData()) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = false;
            if (parameterCount == 0 || parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterTypeHeader[i].equals((Object)parameters[i].getColumnType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                pos.write(1);
                for (i = 0; i < parameterCount; ++i) {
                    parameterTypeHeader[i] = parameters[i].getColumnType();
                    pos.writeShort((short)parameterTypeHeader[i].getType());
                }
            } else {
                pos.write(0);
            }
        }
        for (int i = 0; i < parameterCount; ++i) {
            ParameterHolder holder = parameters[i];
            if (holder.isNullData() || holder.isLongData()) continue;
            holder.writeBinary(pos);
        }
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException {
        pos.startPacket(0);
        ComStmtExecute.writeCmd(this.statementId, this.parameters, this.parameterCount, this.parameterTypeHeader, pos, this.cursorFlag);
        pos.flush();
    }
}

