/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;

public class ColumnNameMap {
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;
    private final ColumnInformation[] columnInfo;

    public ColumnNameMap(ColumnInformation[] columnInformations) {
        this.columnInfo = columnInformations;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        String lowerName = name.toLowerCase();
        if (this.aliasMap == null) {
            this.aliasMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null && !columnAlias.isEmpty()) {
                    String tableName;
                    if (!this.aliasMap.containsKey(columnAlias = columnAlias.toLowerCase())) {
                        this.aliasMap.put(columnAlias, counter);
                    }
                    if ((tableName = ci.getTable()) != null && !tableName.isEmpty() && !this.aliasMap.containsKey((tableName = tableName.toLowerCase()) + "." + columnAlias)) {
                        this.aliasMap.put(tableName + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.aliasMap.get(lowerName)) != null) {
            return res;
        }
        if (this.originalMap == null) {
            this.originalMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null && !columnRealName.isEmpty()) {
                    String tableName;
                    if (!this.originalMap.containsKey(columnRealName = columnRealName.toLowerCase())) {
                        this.originalMap.put(columnRealName, counter);
                    }
                    if ((tableName = ci.getOriginalTable()) != null && !tableName.isEmpty() && !this.originalMap.containsKey((tableName = tableName.toLowerCase()) + "." + columnRealName)) {
                        this.originalMap.put(tableName + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.originalMap.get(lowerName)) == null) {
            throw new SQLException("No such column :" + name);
        }
        return res;
    }
}

