/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.com.send.gssapi.StandardGssapiAuthentication;
import org.mariadb.jdbc.internal.com.send.gssapi.WindowsNativeSspiAuthentication;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SendGssApiAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    private PacketInputStream reader;

    public SendGssApiAuthPacket(PacketInputStream reader, String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
        this.reader = reader;
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException, SQLException {
        Buffer buffer = new Buffer(this.authData);
        String serverPrincipalName = buffer.readStringNullEnd(Buffer.UTF_8);
        String mechanisms = buffer.readStringNullEnd(Buffer.UTF_8);
        if (mechanisms.equals("")) {
            mechanisms = "Kerberos";
        }
        GssapiAuth gssapiAuth = this.getAuthenticationMethod();
        gssapiAuth.authenticate(pos, serverPrincipalName, mechanisms);
    }

    @Override
    public void handleResultPacket(PacketInputStream reader) throws SQLException, IOException {
        try {
            Buffer buffer = reader.getPacket(true);
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                String message = ep.getMessage();
                throw new SQLException("Could not connect: " + message, ep.getSqlState(), ep.getErrorNumber());
            }
        }
        catch (EOFException e) {
            throw new SQLException("Authentication exception", "28000", 1045, e);
        }
    }

    private GssapiAuth getAuthenticationMethod() {
        try {
            Class<?> platformClass = Class.forName("com.sun.jna.Platform");
            Method method = platformClass.getMethod("isWindows", new Class[0]);
            Boolean isWindows = (Boolean)method.invoke(platformClass, new Object[0]);
            if (isWindows.booleanValue()) {
                try {
                    Class.forName("waffle.windows.auth.impl.WindowsAuthProviderImpl");
                    return new WindowsNativeSspiAuthentication(this.reader, this.packSeq);
                }
                catch (ClassNotFoundException cle) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StandardGssapiAuthentication(this.reader, this.packSeq);
    }
}

