/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public class ProtocolLoggingProxy
implements InvocationHandler {
    private static final NumberFormat numberFormat = DecimalFormat.getInstance();
    private static Logger logger = LoggerFactory.getLogger(ProtocolLoggingProxy.class);
    protected boolean profileSql;
    protected Long slowQueryThresholdNanos;
    protected int maxQuerySizeToLog;
    protected Protocol protocol;

    public ProtocolLoggingProxy(Protocol protocol, Options options) {
        this.protocol = protocol;
        this.profileSql = options.profileSql;
        this.slowQueryThresholdNanos = options.slowQueryThresholdNanos;
        this.maxQuerySizeToLog = options.maxQuerySizeToLog;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long startTime = System.nanoTime();
        try {
            if ("executeQuery".equals(method.getName()) || "executePreparedQuery".equals(method.getName()) || "executeBatch".equals(method.getName()) || "executeBatchMulti".equals(method.getName()) || "executeBatchRewrite".equals(method.getName()) || "executeBatchMultiple".equals(method.getName()) || "prepareAndExecutes".equals(method.getName()) || "prepareAndExecute".equals(method.getName())) {
                Object returnObj = method.invoke((Object)this.protocol, args);
                if (logger.isInfoEnabled() && (this.profileSql || this.slowQueryThresholdNanos != null && System.nanoTime() - startTime > this.slowQueryThresholdNanos)) {
                    logger.info("Query - conn:" + this.protocol.getServerThreadId() + "(" + (this.protocol.isMasterConnection() ? "M" : "S") + ") - " + numberFormat.format(((double)System.nanoTime() - (double)startTime) / 1000000.0) + " ms" + this.logQuery(method.getName(), args, returnObj));
                }
                return returnObj;
            }
            return method.invoke((Object)this.protocol, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private String logQuery(String methodName, Object[] args, Object returnObj) {
        String sql = "";
        if ("executeQuery".equals(methodName)) {
            switch (args.length) {
                case 1: {
                    sql = (String)args[0];
                    break;
                }
                case 3: {
                    sql = (String)args[2];
                    break;
                }
                case 4: 
                case 5: {
                    if (Charset.class.isInstance(args[3])) {
                        sql = (String)args[2];
                        break;
                    }
                    ClientPrepareResult clientPrepareResult = (ClientPrepareResult)args[2];
                    sql = this.getQueryFromPrepareParameters(clientPrepareResult, (ParameterHolder[])args[3], clientPrepareResult.getParamCount());
                    break;
                }
            }
        } else if ("executeBatchMulti".equals(methodName)) {
            ClientPrepareResult clientPrepareResult = (ClientPrepareResult)args[2];
            sql = this.getQueryFromPrepareParameters(clientPrepareResult.getSql(), (List)args[3], clientPrepareResult.getParamCount());
        } else if ("executeBatch".equals(methodName)) {
            List queries = (List)args[2];
            for (int counter = 0; counter < queries.size(); ++counter) {
                sql = sql + (String)queries.get(counter) + ";";
                if (this.maxQuerySizeToLog <= 0 || sql.length() <= this.maxQuerySizeToLog) {
                    continue;
                }
                break;
            }
        } else if ("executeBatchMultiple".equals(methodName)) {
            List multipleQueries = (List)args[2];
            if (multipleQueries.size() == 1) {
                sql = (String)multipleQueries.get(0);
            } else {
                for (int counter = 0; counter < multipleQueries.size(); ++counter) {
                    if (this.maxQuerySizeToLog > 0 && sql.length() + ((String)multipleQueries.get(counter)).length() + 1 > this.maxQuerySizeToLog) {
                        sql = sql + ((String)multipleQueries.get(counter)).substring(1, Math.max(1, this.maxQuerySizeToLog - sql.length()));
                    } else {
                        sql = sql + (String)multipleQueries.get(counter) + ";";
                        if (this.maxQuerySizeToLog <= 0 || sql.length() < this.maxQuerySizeToLog) {
                            continue;
                        }
                    }
                    break;
                }
            }
        } else if ("prepareAndExecute".equals(methodName)) {
            ParameterHolder[] parameters = (ParameterHolder[])args[4];
            ServerPrepareResult serverPrepareResult1 = (ServerPrepareResult)returnObj;
            sql = this.getQueryFromPrepareParameters(serverPrepareResult1, parameters, serverPrepareResult1.getParamCount());
        } else if ("prepareAndExecutes".equals(methodName)) {
            List parameterList = (List)args[4];
            ServerPrepareResult serverPrepareResult = (ServerPrepareResult)returnObj;
            sql = this.getQueryFromPrepareParameters(serverPrepareResult.getSql(), parameterList, serverPrepareResult.getParamCount());
        } else if ("executeBatchRewrite".equals(methodName)) {
            ClientPrepareResult prepareResultRewrite = (ClientPrepareResult)args[2];
            List parameterListRewrite = (List)args[3];
            sql = this.getQueryFromPrepareParameters(prepareResultRewrite.getSql(), parameterListRewrite, prepareResultRewrite.getParamCount());
        } else if ("executePreparedQuery".equals(methodName)) {
            ServerPrepareResult prepareResult = (ServerPrepareResult)args[1];
            sql = args[3] instanceof ParameterHolder[] ? this.getQueryFromPrepareParameters(prepareResult, (ParameterHolder[])args[3], prepareResult.getParamCount()) : this.getQueryFromPrepareParameters(prepareResult.getSql(), (List)args[3], prepareResult.getParameters().length);
        }
        if (this.maxQuerySizeToLog > 0) {
            return " - \"" + (sql.length() < this.maxQuerySizeToLog ? sql : sql.substring(0, this.maxQuerySizeToLog) + "...") + "\"";
        }
        return " - \"" + sql + "\"";
    }

    private String getQueryFromPrepareParameters(String sql, List<ParameterHolder[]> parameterList, int parameterLength) {
        if (parameterLength == 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(sql).append(", parameters ");
        for (int paramNo = 0; paramNo < parameterList.size(); ++paramNo) {
            ParameterHolder[] parameters = parameterList.get(paramNo);
            if (paramNo != 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int i = 0; i < parameterLength; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            if (this.maxQuerySizeToLog > 0 && sb.length() > this.maxQuerySizeToLog) break;
            sb.append("]");
        }
        return sb.toString();
    }

    private String getQueryFromPrepareParameters(PrepareResult serverPrepareResult, ParameterHolder[] paramHolders, int parameterLength) {
        StringBuilder sb = new StringBuilder(serverPrepareResult.getSql());
        if (paramHolders.length > 0) {
            sb.append(", parameters [");
            for (int i = 0; i < parameterLength; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(paramHolders[i].toString());
                if (this.maxQuerySizeToLog > 0 && sb.length() > this.maxQuerySizeToLog) break;
            }
            return sb.append("]").toString();
        }
        return serverPrepareResult.getSql();
    }
}

